<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>
<%@ include file="/oemNoscript.jspf"%>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 
 <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResourceBundle"
             class="oracle.sysman.resources.MntrResourceBundle"/>
              
  <uix:document>
   <%@ include file="/enablePPR.jspf"%>
   <%@ include file="/oemTitle.jspf"%>
  
   <uix:body>  
    <uix:form name="applyTemplateReviewForm" method="POST">
    
       <uix:pageLayout titleBinding="header@viewBean@servletRequest">
        <%@ include file="/oemGlobal.jspf" %>
        <%@ include file="../../health/header.jsp"%>
        
        <uix:location>
         <uix:train renderedBinding="showNavigation@viewBean@servletRequest"
                    valueBinding="currentStep@navData@servletRequest">
          <uix:contents childDataBinding="steps@navData@servletRequest">
           <uix:link textBinding="text"/>
          </uix:contents>
         </uix:train>
        </uix:location>
        
        <uix:messages>
         <uix:messageBox rendered="false"
                         renderedBinding="renderErrorMessageBox@viewBean@servletRequest"
                         messageBinding="errorMessage@viewBean@servletRequest"
                         messageType="error">
         </uix:messageBox>
        </uix:messages>
        
        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:submitButton name="event"
                            textBinding="CANCEL@commonResourceBundle"
                            value="<%=Constants.CANCEL_EVENT%>"/>
          <uix:submitButton renderedBinding="showOK@viewBean@servletRequest"
                            textBinding="OK@commonResourceBundle"
                            name="event" 
                            value="<%=Constants.SUBMIT_EVENT%>"/>                
          <uix:navigationBar renderedBinding="showNavigation@viewBean@servletRequest"
                             name="applyTemplateNavigationBar"
                             blockSize="-1" 
                             formSubmitted="true"
                             maxValueBinding="numberOfSteps@navData@servletRequest"
                             minValue="1"
                             valueBinding="currentStep@navData@servletRequest"/>
          <uix:submitButton rendered="false"
                            renderedBinding="isFinalStep@navData@servletRequest"
                            textBinding="FINISH@commonResourceBundle"
                            name="event" 
                            value="<%=Constants.SUBMIT_EVENT%>"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
          
        <uix:contents>
         <%-- Tests segment --%>
         <uix:ref refID="webapp/tmpl/reviewWebappTemplateSegment"/> 
        </uix:contents>
          
      </uix:pageLayout>
     
    </uix:form>
   </uix:body>
   </uix:document>
  </uix:renderingContext>