<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.metrics.template.TemplateConstants"%>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 
 <uix:bundle name="templateMsg"
              class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
 <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResourceBundle"
             class="oracle.sysman.resources.MntrResourceBundle"/>
              
  <uix:document>
   <%@ include file="/enablePPR.jspf"%>
   <%@ include file="/oemTitle.jspf"%>
  
   <uix:body>  
    <uix:form name="applyTemplateUDMCredentialsForm" method="POST">
    
     <uix:pageLayout titleBinding="header@viewBean@servletRequest">
      <%@ include file="/oemGlobal.jspf" %>
      <%@ include file="../../health/header.jsp"%>
         
        <uix:location>
         <uix:train renderedBinding="showNavigation@viewBean@servletRequest"
                    valueBinding="currentStep@navData@servletRequest">
          <uix:contents childDataBinding="steps@navData@servletRequest">
           <uix:link textBinding="text"/>
          </uix:contents>
         </uix:train>
        </uix:location>
        
         <uix:messages>
          <uix:flowLayout>
           <uix:messageBox rendered="false"
                           renderedBinding="renderErrorMessageBox@viewBean@servletRequest"
                           messageBinding="errorMessage@viewBean@servletRequest"
                           messageType="error">
          </uix:messageBox>
         
          <uix:messageBox rendered="false"
                          renderedBinding="showInformationalMessage@servletRequest"
                          messageBinding="APPLY_HOST_UDM_INFORMATION_MESSAGE@templateMsg"
                          messageType="info">
          </uix:messageBox>
         
          <uix:messageBox rendered="false"
                          renderedBinding="showErrorMessage@errMap@servletRequest"
                          messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle"
                          messageType="error">
           <uix:contents childDataBinding ="errMsgs@errMap@servletRequest">
            <uix:link textBinding="label" 
                      longDescBinding="message"
                      destinationBinding="destination"/>
           </uix:contents>
          </uix:messageBox>
         </uix:flowLayout>
        </uix:messages>
        
        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:submitButton name="event"
                            textBinding="CANCEL@commonResourceBundle"
                            value="<%=Constants.CANCEL_EVENT%>"/>
          <uix:submitButton renderedBinding="showOK@viewBean@servletRequest"
                            textBinding="OK@commonResourceBundle"
                            name="event" 
                            value="<%=Constants.SUBMIT_EVENT%>"/>                
          <uix:navigationBar renderedBinding="showNavigation@viewBean@servletRequest"
                             name="applyTemplateNavigationBar"
                             blockSize="-1"
                             formSubmitted="true"
                             maxValueBinding="numberOfSteps@navData@servletRequest"
                             minValue="1"
                             valueBinding="currentStep@navData@servletRequest"/>
          <uix:submitButton rendered="false"
                            renderedBinding="isFinalStep@navData@servletRequest"
                            textBinding="FINISH@commonResourceBundle"
                            name="event" 
                            value="<%=Constants.SUBMIT_EVENT%>"/>
         </uix:pageButtonBar>
        </uix:pageButtons>
        
        <uix:contents>
           
         <uix:stackLayout>
          <uix:contents>
        
          <uix:spacer height="5"/>
          
          <uix:tableLayout width="100%"> 
           <uix:rowLayout>
            <uix:cellFormat hAlign="left">
             <%--<uix:styledText styleClass="OraFieldText"
                             textBinding="APPLY_UDM_CREDENTIALS_CHOICE_LABEL@templateMsg"/>
             <uix:spacer width="4"/>--%>
             <uix:choice name="specifyUDMCredentials"
                         onChangeBinding="choiceOnChangeBinding@dataMap@servletRequest"
                         selectedValueBinding="choice@dataMap@servletRequest">
              <uix:contents childDataBinding="choices@dataMap@servletRequest">
               <uix:option textBinding="text"
                           valueBinding="value"/>
              </uix:contents>
             </uix:choice>
            </uix:cellFormat>
           </uix:rowLayout>
          </uix:tableLayout>
          
          <uix:tableLayout>
          <uix:rowLayout> 
           <uix:spacer height="25"/>
          </uix:rowLayout> 
          </uix:tableLayout>
         
          <uix:switcher childNameBinding="choice@dataMap@servletRequest">
           <uix:case name="<%=TemplateConstants.ONE_CRED_FOR_ALL_UDMS_TGTS%>">
           
            <uix:stackLayout>
             <uix:styledText textBinding="APPLY_ALL_UDMS_ALL_TARGETS_TEXT@templateMsg" 
                             styleClass="OraInstructionText"/>
             
             <uix:spacer height="15"/>
           
             <uix:labeledFieldLayout fieldWidth="90%" labelWidth="10%">                      
              <uix:contents> 
               <uix:messageTextInput name="username"
                                     promptBinding="USERNAME@mntrResourceBundle"
                                     textBinding="username@dataMap@servletRequest"
                                     columns="20"
                                     noAutoComplete="true"
                                     messageTypeBinding="messageType@errMap@servletRequest"
                                     messageBinding="userNameErrMessage@errMap@servletRequest"
                                     anchor="userNameAnchor"/>
               <uix:messageTextInput name="password"
                                     promptBinding="PASSWORD@commonResourceBundle"
                                     textBinding="password@dataMap@servletRequest"
                                     secret="true"
                                     noAutoComplete="true"
                                     columns="20"
                                     messageTypeBinding="messageType@errMap@servletRequest"
                                     messageBinding="passwordErrMessage@errMap@servletRequest"
                                     anchor="passwordAnchor"/>
              </uix:contents>
             </uix:labeledFieldLayout>                   
            </uix:stackLayout>
           </uix:case> 
           <uix:case name="<%=TemplateConstants.CRED_PER_UDM_FOR_ALL_TGTS%>">
            <uix:stackLayout>
            
             <uix:styledText textBinding="APPLY_EACH_UDM_ALL_TARGETS_TEXT@templateMsg" 
                             styleClass="OraInstructionText"/>
              
             <uix:spacer height="15"/>
            
             <uix:table 
                  name="<%=TemplateConstants.CRED_PER_UDM_FOR_ALL_TGTS_TABLE%>" 
                  id="<%=TemplateConstants.CRED_PER_UDM_FOR_ALL_TGTS_TABLE%>" 
                  alternateTextBinding="NO_DATA_STR@mntrResourceBundle"
                  width="75%" 
                  formSubmitted="true" 
                  showAll="yes"
                  valueBinding="tableValue@udmTableView@dataMap@servletRequest" 
                  minValueBinding="minValue@udmTableView@dataMap@servletRequest" 
                  maxValueBinding="maxValue@udmTableView@dataMap@servletRequest" 
                  blockSizeBinding="blockSize@udmTableView@dataMap@servletRequest" 
                  tableDataBinding="tableData@udmTableView@dataMap@servletRequest" 
                  columnFormatsBinding="tableColumnFormats@udmTableView@dataMap@servletRequest" 
                  columnHeaderDataBinding="tableColumnHeaders@udmTableView@dataMap@servletRequest">
               <uix:tableFormat tableBanding="rowBanding"/>
               <uix:columnHeaderStamp>
                 <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
               </uix:columnHeaderStamp>
               <uix:contents>
                 <uix:styledText textBinding="<%=Constants.METRIC_LABEL_KEY%>"/>
                 <uix:textInput name="<%=TemplateConstants.USER_NAME%>"
                                noAutoComplete="true"
                                columns="20"
                                textBinding="<%=TemplateConstants.USER_NAME%>"/>
                 <uix:textInput name="password"
                                columns="20"
                                secret="true"
                                noAutoComplete="true"
                                textBinding="password"/>
                 <uix:formValue name="key"
                                valueBinding="key"/>
               </uix:contents>
             </uix:table>
            </uix:stackLayout> 
           </uix:case>
           <uix:case name="<%=TemplateConstants.CRED_PER_UDM_PER_TGT%>">
            <uix:stackLayout>
            
             <uix:styledText textBinding="APPLY_EACH_UDM_EACH_TARGET_TEXT@templateMsg" 
                             styleClass="OraInstructionText"/>
              
             <uix:spacer height="15"/>
            
             <uix:rowLayout>
              <uix:submitButton textBinding="APPLY_BATCH_UPDATE_BUTTON_LABEL@templateMsg" 
                                name="event" 
                                value="batchUpdate"/>
             </uix:rowLayout>
            
             <uix:ref refID="<%=TemplateConstants.CRED_PER_UDM_PER_TGT_TABLE%>" />

            </uix:stackLayout> 
           </uix:case>
          </uix:switcher>
          
         </uix:contents>
        </uix:stackLayout>
       </uix:contents>
       
      </uix:pageLayout>
     </uix:form>
    </uix:body>
   </uix:document>
</uix:renderingContext>
