<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.metrics.template.TemplateConstants"%>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
 
 <uix:bundle name="templBundle"
              class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
 <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResourceBundle"
             class="oracle.sysman.resources.MntrResourceBundle"/>
              
  <uix:document>
   <%@ include file="/enablePPR.jspf"%>
   <%@ include file="/oemTitle.jspf"%>
  
   <uix:body>  
    <uix:form name="specifyUDMCredentialsForm" method="POST">
    
     <uix:pageLayout titleBinding="header@viewBean@servletRequest">
      <%@ include file="/oemGlobal.jspf" %>
      <%@ include file="../../health/header.jsp"%>
        
        <uix:pageHeader >
         <uix:globalHeader selectedIndex="0">
          <uix:contents>
           <uix:link textBinding="SETUP_HEADER@commonResourceBundle"
                     styleClass="OraGlobalPageTitle"
                     destination="" />
          </uix:contents>
         </uix:globalHeader>
        </uix:pageHeader>
        
        <uix:location>
         <uix:train valueBinding="currentStep@navData@servletRequest">
          <uix:contents childDataBinding="steps@navData@servletRequest">
           <uix:link textBinding="text"/>
          </uix:contents>
         </uix:train>
        </uix:location>

        <uix:messages>
         <uix:messageBox rendered="false"
                         renderedBinding="showErrorMessage@errMap@servletRequest"
                         messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle"
                         messageType="error">
           <uix:contents childDataBinding ="errMsgs@errMap@servletRequest">
             <uix:link textBinding="label" 
                       longDescBinding="message"
                       destinationBinding="destination"/>
           </uix:contents>
         </uix:messageBox>
        </uix:messages>
  
                                                                                
        <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:submitButton name="event"
                                    textBinding="CANCEL@commonResourceBundle"
                                    value="<%=Constants.CANCEL_EVENT%>"/>
                  <uix:spacer width="4"/>
                  <uix:submitButton name="event"
                                    textBinding="CONTINUE@commonResourceBundle"
                                    value="batchUpdate"/>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

         <uix:contents>
         
          <uix:stackLayout>
           <uix:contents>
            <uix:tableLayout cellSpacing="5">
              <uix:rowLayout>
                <uix:cellFormat vAlign="top" width="50%">
                  <uix:header textBinding="SELECT_TARGETS@templBundle">
                    <uix:contents>
                      <uix:table name="<%=TemplateConstants.CRED_BAT_UPD_TGT_TABLE%>"
                                 id="<%=TemplateConstants.CRED_BAT_UPD_TGT_TABLE%>"
                                 showAll="yes"
                                 formSubmitted="true"
                                 valueBinding="tableValue@tgtTableView@dataMap@servletRequest"
                                 minValueBinding="minValue@tgtTableView@dataMap@servletRequest"
                                 maxValueBinding="maxValue@tgtTableView@dataMap@servletRequest"
                                 blockSizeBinding="blockSize@tgtTableView@dataMap@servletRequest"
                                 tableDataBinding="tableData@tgtTableView@dataMap@servletRequest"
                                 columnFormatsBinding="tableColumnFormats@tgtTableView@dataMap@servletRequest"
                                 columnHeaderDataBinding="tableColumnHeaders@tgtTableView@dataMap@servletRequest">
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>

                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:tableSelection>
                            <uix:multipleSelection selectionBinding="tableData@tgtTableView@dataMap@servletRequest" selectedBinding="selected"/>
                          </uix:tableSelection>
                          <uix:contents>
                            <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"/>
                          </uix:contents>
                      </uix:table>
                    </uix:contents>
                  </uix:header>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="50%">
                  <uix:header textBinding="SELECT_USER_DEFINED_METRICS@templBundle">
                    <uix:contents>
                      <uix:table name="<%=TemplateConstants.CRED_BAT_UPD_UDM_TABLE%>"
                                 id="<%=TemplateConstants.CRED_BAT_UPD_UDM_TABLE%>"
                                 showAll="yes"
                                 formSubmitted="true"
                                 valueBinding="tableValue@udmTableView@dataMap@servletRequest"
                                 minValueBinding="minValue@udmTableView@dataMap@servletRequest"
                                 blockSizeBinding="blockSize@udmTableView@dataMap@servletRequest"
                                 maxValueBinding="maxValue@udmTableView@dataMap@servletRequest"
                                 tableDataBinding="tableData@udmTableView@dataMap@servletRequest"
                                 columnFormatsBinding="tableColumnFormats@udmTableView@dataMap@servletRequest"
                                 columnHeaderDataBinding="tableColumnHeaders@udmTableView@dataMap@servletRequest">
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>

                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:tableSelection>
                            <uix:multipleSelection selectionBinding="selection@udmTableView@dataMap@servletRequest" selectedBinding="selected"/>
                          </uix:tableSelection>
                          <uix:contents>
                            <uix:styledText textBinding="udm"/>
                          </uix:contents>
                      </uix:table>
                    </uix:contents>
                  </uix:header>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:header textBinding="SPECIFY_UDM_CREDENTIALS_HEADER@templBundle">
              <uix:contents>
                <uix:labeledFieldLayout fieldWidth="90%" labelWidth="10%">                      
                  <uix:contents> 
                   <uix:messageTextInput name="<%=TemplateConstants.USER_NAME%>"
                                  promptBinding="USERNAME@mntrResourceBundle"
                                  textBinding="username@dataMap@servletRequest"
                                  noAutoComplete="true"
                                  anchor="userNameAnchor"
                                  columns="20"/>
              
                   <uix:messageTextInput name="password"
                                  promptBinding="PASSWORD@commonResourceBundle"
                                  textBinding="password@dataMap@servletRequest"
                                  secret="true"
                                  noAutoComplete="true"
                                  anchor="passwordAnchor"
                                  columns="20"/>
                 </uix:contents>
                </uix:labeledFieldLayout>
              </uix:contents>
            </uix:header>
           </uix:contents>
          </uix:stackLayout>
         </uix:contents> 
          
      </uix:pageLayout>
     </uix:form>
    </uix:body>
   </uix:document>
</uix:renderingContext>
