<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.metrics.target.CollectionSettingsViewBean"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemNoscript.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
      <uix:form name="CSForm" method="POST">
        <uix:pageLayout titleBinding="header@viewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
          
          <% CollectionSettingsViewBean collectionViewBean = (CollectionSettingsViewBean)request.getAttribute("viewBean"); %>

          <% if (collectionViewBean.getShowHealthHeader() == true) { %>
          <%@ include file="/health/header.jsp"%>
          <% } %>
           
          <uix:messages>
            
            <uix:switcher childNameBinding="displayMarkedForDelete@data@viewBean@servletRequest">
                <uix:case name="true">
		    <uix:messageBox messageType="info"
				    messageBinding="markForDeleteIndoText@data@viewBean@servletRequest"
				    rendered="false" 
				    renderedBinding="displayMarkedForDelete@data@viewBean@servletRequest">
		    </uix:messageBox>                    
                </uix:case>
                <uix:default>
		    <uix:messageBox rendered="false"
				    renderedBinding="errorOccurred@errData@viewBean@servletRequest"
				    messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle"
				    messageType="error">
		      <uix:contents childDataBinding="errorList@errData@viewBean@servletRequest">
			<uix:link textBinding="label"
				  longDescBinding="message"
				  destinationBinding="destination"/>
		      </uix:contents>
		    </uix:messageBox>                
                </uix:default>
	      </uix:switcher> 
          </uix:messages> 

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
                    <uix:case name="okNode">
                      <uix:cellFormat>
                        <uix:submitButton name="event"
                                          textBinding="CANCEL@sdkUIMsg"
                                          value="Cancel"
                                          renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:spacer width="4" renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:switcher childNameBinding="hasPrivString@viewBean@servletRequest">
                         <uix:case name="false">
                          <uix:submitButton name="event"
                                            textBinding="OK@sdkUIMsg"
                                            value="Continue"/>
                         </uix:case>
                         <uix:case name="true">
                          <uix:submitButton name="event"
                                            textBinding="CONTINUE@sdkUIMsg"
                                            value="Continue"/>
                         </uix:case>
                        </uix:switcher>
                      </uix:cellFormat>
                    </uix:case>
                    <uix:case name="errNode">
                      <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        value="Error"/>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
            <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
              <uix:case name="okNode">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="COLLECTION_SETTINGS_INSTRUCTION@mntrResourceBundle"/>
                              
                  <uix:header textBinding="COLLECTION_SCHEDULE@mntrResourceBundle">
                    <uix:stackLayout renderedBinding="showDataCollection@viewBean@servletRequest">
                      <uix:stackLayout rendered="false" renderedBinding="showSGAMessage@data@viewBean@servletRequest">
                        <uix:styledText styleClass="OraInstructionText"
                                        textBinding="COLLECTION_SERVER_GENERATED_ALERT@mntrResourceBundle"/>
                        <uix:spacer height="8"/>
                      </uix:stackLayout>

                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:cellFormat>
                            <uix:styledText styleClass="OraFieldText"
                                            textBinding="DATA_COLLECTION@mntrResourceBundle"/>
                            <uix:spacer height="8"/>
                            <uix:styledText styleClass="OraDatatext"
                                            textBinding="isEnabledState@data@viewBean@servletRequest"/>
                            <uix:spacer height="4"/>
                            <uix:submitButton name="event"
                                              textBinding="isEnabledButton@data@viewBean@servletRequest"
                                              value="Collect"
                                              renderedBinding="showIsEnabledButton@data@viewBean@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout rendered="false" renderedBinding="showRequiredCollHint@data@viewBean@servletRequest">
                          <uix:cellFormat>
                            <uix:styledText styleClass="OraInlineInfoText"
                                            textBinding="REQUIRED_COLLECTION_HINT@mntrResourceBundle"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:stackLayout>

                    <uix:stackLayout renderedBinding="isEnabled@data@viewBean@servletRequest">
                      <uix:header textBinding="COLLECTION_FREQUENCY@mntrResourceBundle">
                        <uix:stackLayout rendered="false" renderedBinding="showSMMMessage@data@viewBean@servletRequest">
                          <uix:styledText styleClass="OraInstructionText"
                                          textBinding="COLLECTION_SERVER_MANAGED_METRIC@mntrResourceBundle"/>
                          <uix:spacer height="8"/>
                        </uix:stackLayout>
  
                        <%-- include the schedule pagesegment. --%>
                        <uix:ref refID="SCHEDULE_SEGMENT_UINODE"/>
                      </uix:header>
  
                      <uix:header rendered="false" renderedBinding="showUpload@data@viewBean@servletRequest"
                                  textBinding="USE_OF_METRIC_DATA@mntrResourceBundle">
                        <uix:tableLayout width="100%">
                          <uix:rowLayout>
                            <uix:cellFormat hAlign="left" vAlign="top" width="50%">
                              <uix:tableLayout>
                                <uix:rowLayout>
                                  <uix:cellFormat>
                                    <uix:radioButton name="radioButton"
                                                     disabledBinding="displayRadio@viewBean@servletRequest"
                                                     readOnlyBinding="displayRadio@viewBean@servletRequest"
                                                     selectedValueBinding="selectedButton@data@viewBean@servletRequest"
                                                     shortDescBinding="ALERTING_HISTORICAL_TRENDING@mntrResourceBundle"
                                                     value="0"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="ALERTING_HISTORICAL_TRENDING@mntrResourceBundle"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>
  
                                <uix:rowLayout>
                                  <uix:cellFormat>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:inlineMessage messageTypeBinding="uploadIntervalMsgType@errData@viewBean@servletRequest"
                                                       anchorBinding="uploadIntervalAnchor@errData@viewBean@servletRequest"
                                                       messageBinding="uploadIntervalInlineMsg@errData@viewBean@servletRequest">
                                      <uix:styledText styleClass="OraFieldText"
                                                      textBinding="UPLOAD_INTERVAL@mntrResourceBundle"/>
                                      <uix:spacer width="8"/>
                                      <uix:textInput name="upload"
                                                     columns="1"
                                                     readOnlyBinding="displayRadio@viewBean@servletRequest"
                                                     textBinding="upload@data@viewBean@servletRequest"
                                                     shortDescBinding="UPLOAD_INTERVAL@mntrResourceBundle"/>
                                      <uix:styledText styleClass="OraFieldText"
                                                      textBinding="COLLECTIONS@mntrResourceBundle"/>
                                    </uix:inlineMessage>
                                  </uix:cellFormat>
                                </uix:rowLayout>
  
                                <uix:rowLayout>
                                  <uix:cellFormat>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:styledText styleClass="OraInlineInfoText"
                                                    textBinding="ALERTING_HISTORICAL_TRENDING_HINT@mntrResourceBundle"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>
    
                                <uix:rowLayout>
                                  <uix:cellFormat>
                                    <uix:radioButton name="radioButton"
                                                     disabledBinding="displayRadio@viewBean@servletRequest"
                                                     readOnlyBinding="displayRadio@viewBean@servletRequest"
                                                     selectedValueBinding="selectedButton@data@viewBean@servletRequest"
                                                     shortDescBinding="ALERTING_ONLY@mntrResourceBundle"
                                                     value="1"/>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:styledText styleClass="OraFieldText"
                                                    textBinding="ALERTING_ONLY@mntrResourceBundle"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>
  
                                <uix:rowLayout>
                                  <uix:cellFormat>
                                  </uix:cellFormat>
                                  <uix:cellFormat>
                                    <uix:styledText styleClass="OraInlineInfoText"
                                                    textBinding="ALERTING_ONLY_HINT@mntrResourceBundle"/>
                                  </uix:cellFormat>
                                </uix:rowLayout>
                              </uix:tableLayout>
                            </uix:cellFormat>
    
                            <uix:cellFormat hAlign="right" vAlign="top" width="50%">
                              <uix:contentContainer background="light" width="100%">
                                <uix:styledText styleClass="OraInstructionText"
                                                textBinding="UPLOAD_INTERVAL_INSTRUCTION@mntrResourceBundle"/>
                              </uix:contentContainer>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:tableLayout>
                      </uix:header>
                    </uix:stackLayout>
                  </uix:header>

                  <uix:tableLayout width="100%">
                    <uix:rowLayout>
                      <uix:cellFormat vAlign="top" width="50%">
                        <uix:header textBinding="AFFECTED_METRICS@mntrResourceBundle">
                          <uix:table id="metricTable"
                                     summaryBinding="AFFECTED_METRICS@mntrResourceBundle"
                                     tableDataBinding="row@metricTableData@viewBean@servletRequest"
                                     columnHeaderDataBinding="column@metricTableData@viewBean@servletRequest"
                                     width="100%"
                                     showAll="yes"
                                     formSubmitted="true"
                                     blockSizeBinding="blockSize@metricTableData@viewBean@servletRequest"
                                     minValueBinding="minValue@metricTableData@viewBean@servletRequest"
                                     maxValueBinding="maxValue@metricTableData@viewBean@servletRequest"
                                     valueBinding="value@metricTableData@viewBean@servletRequest"
                                     alternateTextBinding="NO_METRICS_ALT@mntrResourceBundle">
                            <uix:tableFormat tableBanding="rowBanding"/>
                            <uix:columnHeaderStamp>
                              <uix:sortableHeader sortableBinding="sortable"
                                                  textBinding="text"/>
                            </uix:columnHeaderStamp>
                            <uix:styledText textBinding="metricName"/>
                          </uix:table>
                        </uix:header>
                      </uix:cellFormat>

                      <uix:cellFormat vAlign="top" width="50%">
                        <uix:header textBinding="AFFECTED_POLICIES@mntrResourceBundle">
                          <uix:table id="policyTable"
                                     summaryBinding="AFFECTED_POLICIES@mntrResourceBundle"
                                     tableDataBinding="row@policyTableData@viewBean@servletRequest"
                                     columnHeaderDataBinding="column@policyTableData@viewBean@servletRequest"
                                     width="100%"
                                     showAll="yes"
                                     formSubmitted="true"
                                     blockSizeBinding="blockSize@policyTableData@viewBean@servletRequest"
                                     minValueBinding="minValue@policyTableData@viewBean@servletRequest"
                                     maxValueBinding="maxValue@policyTableData@viewBean@servletRequest"
                                     valueBinding="value@policyTableData@viewBean@servletRequest"
                                     alternateTextBinding="NO_POLICIES_ALT@mntrResourceBundle">
                            <uix:tableFormat tableBanding="rowBanding"/>
                            <uix:columnHeaderStamp>
                              <uix:sortableHeader sortableBinding="sortable"
                                                  textBinding="text"/>
                            </uix:columnHeaderStamp>
                            <uix:styledText textBinding="policyName"/>
                          </uix:table>
                        </uix:header>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout>

                  <uix:formValue name="hasPriv" valueBinding="hasPrivString@viewBean@servletRequest"/>
                </uix:stackLayout>
              </uix:case>

              <uix:case name="errNode">
                <uix:messageBox messageBinding="errorMessage@viewBean@servletRequest"
                                messageType="error"
                                shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                                textBinding="ERR_OCCUR@mntrResourceBundle">
                </uix:messageBox>
              </uix:case>
            </uix:switcher>
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
