<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="templBundle"
  class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
  <uix:bundle name="commonResourceBundle"
  class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
  class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>  
    <uix:body>  
      <uix:form name="compareSettingsForm" method="POST">
        <uix:pageLayout titleBinding="header@viewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>
          <%@ include file="../../health/header.jsp"%>
          <uix:messages>
            <uix:flowLayout>
              <uix:messageBox rendered="false"
                renderedBinding="showErrorMessage@errMap@servletRequest"
                messageBinding="CORRECT_ERRORS_MSG@mntrResourceBundle"
                messageType="error">
                <uix:contents childDataBinding ="errMsgs@errMap@servletRequest">
                  <uix:link textBinding="label" 
                  longDescBinding="message"
                  destinationBinding="destination"/>
                </uix:contents>
              </uix:messageBox>
              <uix:messageBox rendered="false"
                renderedBinding="showErrorMessage@viewBean@servletRequest"
                messageBinding="errorMessage@viewBean@servletRequest"
                messageType="error"/>
              <uix:messageBox rendered="false"
                renderedBinding="showInformationalMessage@servletRequest"
                messageBinding="OLDER_AGENTS_INFORMATIONAL_MESSAGE@templBundle"
                messageType="info"/>
            </uix:flowLayout>
          </uix:messages>
          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:submitButton name="event"
                         textBinding="CANCEL@commonResourceBundle"
                               value="<%=Constants.CANCEL_EVENT%>"/>
              <uix:submitButton name="event" 
                         textBinding="CONTINUE@commonResourceBundle"
                               value="<%=Constants.SUBMIT_EVENT%>"/>
            </uix:pageButtonBar>
          </uix:pageButtons>
          <uix:contents>
            <uix:stackLayout>
              <uix:contents>
                <uix:tableLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="APPLY_SOURCE_TEMPLATE_PROMPT@templBundle"
                                        styleClass="OraInstructionText"/>
                      </uix:cellFormat>                 
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText textBinding="templateNameKey@dataMap@servletRequest"
                                          styleClass="OraInstructionTextStrong"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="TARGET_TYPE@mntrResourceBundle"
                                      styleClass="OraInstructionText"/>
                      </uix:cellFormat>                 
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText textBinding="templateTargetTypeNLS@dataMap@servletRequest"
                                         styleClass="OraInstructionTextStrong"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="OWNER@mntrResourceBundle"
                                       styleClass="OraInstructionText"/>
                      </uix:cellFormat>                 
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText textBinding="templateOwner@dataMap@servletRequest"
                                         styleClass="OraInstructionTextStrong"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout> 
                <uix:spacer height="5"/>
                <uix:header textBinding="DESTINATION_TARGETS@mntrResourceBundle">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:contents>
                        <uix:styledText textBinding="compareSettingsDescriptiveText@dataMap@servletRequest"
                                         styleClass="OraInstructionText"/>
                        <uix:spacer height="5"/>
                          <uix:table name="destinationTargetsTable" 
                                      id="destinationTargetsTable" 
                                      partialRenderMode="self" 
                                      alternateTextBinding="NO_DATA_STR@mntrResourceBundle"
                                      width="75%" 
                                      showAll="yes" 
                                      summaryBinding="DESTINATION_TARGETS@mntrResourceBundle"
                                      formSubmitted="true" 
                                      valueBinding="tableValue@tgtTableView@dataMap@servletRequest" 
                                      minValueBinding="minValue@tgtTableView@dataMap@servletRequest" 
                                      maxValueBinding="maxValue@tgtTableView@dataMap@servletRequest" 
                                      blockSizeBinding="blockSize@tgtTableView@dataMap@servletRequest" 
                                      tableDataBinding="tableData@tgtTableView@dataMap@servletRequest" 
                                      columnFormatsBinding="tableColumnFormats@tgtTableView@dataMap@servletRequest" 
                                      columnHeaderDataBinding="tableColumnHeaders@tgtTableView@dataMap@servletRequest">
                            <uix:tableFormat tableBanding="rowBanding"/>
                            <uix:columnHeaderStamp>
                              <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                            </uix:columnHeaderStamp>
                            <uix:tableSelection >
                              <uix:multipleSelection selectionBinding="selection@tgtTableView@dataMap@servletRequest"                            shortDescBinding="SELECT@commonResourceBundle"
                                                      selectedBinding="selected">
                                <uix:submitButton textBinding="REMOVE@commonResourceBundle" 
                                                        name="event" 
                                                        value="<%=Constants.REMOVE_EVENT%>"/>
                              </uix:multipleSelection>
                            </uix:tableSelection>
                            <uix:tableActions>    
                              <oem:targetSelection textBinding="ADD@commonResourceBundle"/>
                            </uix:tableActions>
                            <uix:contents>
                              <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"/>
                              <uix:styledText textBinding="typeDisplayName"/>
                            </uix:contents>
                          </uix:table>
                      </uix:contents>
                    </uix:stackLayout>
                  </uix:contents> 
                </uix:header>
                <uix:spacer height="5" renderedBinding="showApplyThresholdOption@viewBean@servletRequest"/>
                  <uix:hideShowHeader 
                        id="showMutliKeyAttribute"
                        textBinding="SETTINGS_HEADER_NEW@templBundle"
                        partialRenderMode="self"
                        disclosedBinding="showdetails@viewBean@servletRequest"
                        formSubmitted="true"
                        unvalidated="true"
                        renderedBinding="showApplyThresholdOption@viewBean@servletRequest">
                    <uix:contents>
                      <uix:tableLayout width="100%">
                        <uix:cellFormat width="50%" hAlign="left">
                          <uix:rowLayout>
                            <uix:spacer height="5"/>
                          </uix:rowLayout>
                         <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:radioButton name="applyOption"
                                    selectedBinding="applyAllWithRetainOption@dataMap@servletRequest"
                                    shortDescBinding="COMPARE_FULLY_RADIO_NEW@templBundle"
                                    value="2"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraFieldText"
                                              textBinding="COMPARE_FULLY_RADIO_NEW@templBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:spacer width="20"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:styledText styleClass="OraInlineInfoText"
                                             textBinding="COMPARE_FULLY_TIP_NEW@templBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:radioButton name="applyOption"
                                    selectedBinding="applyAllThresholds@dataMap@servletRequest"
                                    shortDescBinding="REPLACE_ALL_RADIO_NEW@templBundle"
                                               value="0"/>
                            </uix:cellFormat>
                            <uix:cellFormat hAlign="left">
                              <uix:styledText styleClass="OraFieldText"
                                             textBinding="REPLACE_ALL_RADIO_NEW@templBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout> 
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:spacer width="20"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:styledText styleClass="OraInlineInfoText"
                                             textBinding="REPLACE_ALL_TIP_NEW@templBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:radioButton name="applyOption"
                                    selectedBinding="applyCommonThresholds@dataMap@servletRequest"
                                    shortDescBinding="COMPARE_COMMON_RADIO_NEW@templBundle"
                                               value="1"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:styledText styleClass="OraFieldText"
                                             textBinding="COMPARE_COMMON_RADIO_NEW@templBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                          <uix:rowLayout>
                            <uix:cellFormat>
                              <uix:spacer width="20"/>
                            </uix:cellFormat>
                            <uix:cellFormat>
                              <uix:styledText styleClass="OraInlineInfoText"
                                             textBinding="COMPARE_COMMON_TIP_NEW@templBundle"/>
                            </uix:cellFormat>
                          </uix:rowLayout>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="right" vAlign="top" height="100%" width="50%">
                          <uix:contentContainer background="light" width="60%"
                            textBinding="KEY_VALUE_QSN_NEW@templBundle">
                            <uix:styledText styleClass="OraInstructionText"
                            textBinding="KEY_VALUE_ANS_NEW@templBundle"/>
                          </uix:contentContainer>
                        </uix:cellFormat>
                      </uix:tableLayout>
                      <uix:rowLayout>
                        <uix:spacer height="10"/>
                      </uix:rowLayout>
                      <uix:rowLayout> 
                        <uix:tip>
                          <uix:contents>
                            <uix:styledText textBinding="APPLY_GENERAL_TIP@templBundle"/>
                          </uix:contents>
                        </uix:tip>
                      </uix:rowLayout>
                    </uix:contents>
                  </uix:hideShowHeader>
                </uix:contents>
            </uix:stackLayout> 
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
