<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

    <uix:bundle name="templBundle"
                class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
    <uix:bundle name="commonResourceBundle"
                class="oracle.sysman.resources.CommonResourceBundle"/>
    <uix:bundle name="mntrResourceBundle"
                class="oracle.sysman.resources.MntrResourceBundle"/>
      <uix:document>
        <%@ include file="/enablePPR.jspf"%>
        <%@ include file="/oemTitle.jspf"%>
        <%@ include file="/oemNoscript.jspf" %>  
        <uix:body>  
          <uix:form name="compareSettingsUIForm" method="POST">
            <uix:pageLayout titleBinding="pageHeader@viewBean@servletRequest">
              <%@ include file="/oemGlobal.jspf" %>
              <%@ include file="../../health/header.jsp"%>
 
                 <uix:pageButtons>
                  <uix:pageButtonBar>
                    <uix:submitButton name="event"
                                      textBinding="cancelButton@modelBean@servletRequest"
                                      shortDescBinding="cancelButton@modelBean@servletRequest"
                                      value="<%=Constants.CANCEL_EVENT%>"/>
                    <uix:submitButton name="event"
                                      textBinding="BACK@commonResourceBundle"
                                      shortDescBinding="BACK@commonResourceBundle"
                                      value="backButton"/>
                    <uix:submitButton name="event"
                                      textBinding="APPLY_TEMPLATE@templBundle"
                                      shortDescBinding="APPLY_TEMPLATE@templBundle"
                                      value="<%=Constants.APPLY_EVENT%>"/>
                  </uix:pageButtonBar>
                </uix:pageButtons>
                <uix:contents>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="APPLY_SOURCE_TEMPLATE_PROMPT@templBundle"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="templateName@modelBean@servletRequest"
                                              styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="TARGET_TYPE@mntrResourceBundle"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="localizedTemplateType@modelBean@servletRequest"
                                            styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="OWNER@mntrResourceBundle"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="templateOwner@modelBean@servletRequest"
                                            styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="TARGET_NAME@mntrResourceBundle"
                                            styleClass="OraInstructionText"/>

                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="target@modelBean@servletRequest"
                                            styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                        <uix:rowLayout renderedBinding="showApplyThresholdOption@modelBean@servletRequest">
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="APPLY_OPTION@templBundle"
                                            styleClass="OraInstructionText"/>
                          </uix:cellFormat>                 
                          <uix:spacer width="5"/>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="applyOption@modelBean@servletRequest"
                                            styleClass="OraInstructionTextStrong"/>
                          </uix:cellFormat>
                        </uix:rowLayout>

                      </uix:tableLayout>
                      <uix:spacer width="1"/>
                      <uix:header textBinding="showCurrentLabel@modelBean@servletRequest">
                        <uix:rowLayout  width="1095">
                       <%--
                          <uix:cellFormat hAlign="left">
                            <uix:messageChoice name="target"
                                               promptBinding="promptString@modelBean@servletRequest"
                                               selectedValueBinding="target@modelBean@servletRequest">
                              <uix:end>
                                <uix:submitButton textBinding="GO_BUTTON@mntrResourceBundle"
                                                  shortDescBinding="GO_BUTTON@mntrResourceBundle"
                                                  name="event" value="<%=Constants.GOTO_EVENT%>"/>
                              </uix:end>
                              <uix:contents childDataBinding="targetsList@modelBean@servletRequest">
                                <uix:option  textBinding="text"
                                             rendered="true"/>
                                </uix:contents>
                            </uix:messageChoice>
                          </uix:cellFormat>
                       --%>
                          <uix:cellFormat hAlign="left">
                            <uix:messageChoice name="currentViewModeFilter"
                                               promptBinding="VIEW@mntrResourceBundle" 
                                               shortDescBinding="VIEW@mntrResourceBundle"
                                               selectedValueBinding="currentViewMode@modelBean@servletRequest">
                              <uix:end>
                                <uix:submitButton textBinding="GO_BUTTON@mntrResourceBundle"
                                                  shortDescBinding="GO_BUTTON@mntrResourceBundle"
                                                  name="event" value="<%=Constants.GOTO_EVENT%>"/>
                              </uix:end>
                              <uix:contents childDataBinding="viewModes@modelBean@servletRequest">
                                <uix:option  textBinding="text"
                                             valueBinding="value"
                                             rendered="true"/>
                                </uix:contents>
                            </uix:messageChoice>
                          </uix:cellFormat>
                          <uix:cellFormat hAlign="right">
                            <uix:styledText textBinding="showLabel@modelBean@servletRequest" 
                                            shortDescBinding="showLabel@modelBean@servletRequest"
                                            destinationBinding="showLink@modelBean@servletRequest"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:spacer width="5"/>
                        <uix:tip renderedBinding="displayTip@servletRequest">
                          <uix:styledText textBinding="udmTipText@modelBean@servletRequest"
                                          shortDescBinding="udmTipText@modelBean@servletRequest"/>
                        </uix:tip>
                        <uix:spacer width="5"/>
                        <uix:rowLayout width="100%">
                          <uix:tableLayout width="100%">
                            <uix:include nodeBinding="compareSettingsTable@modelBean@servletRequest"/>
                          </uix:tableLayout>
                        </uix:rowLayout>
                        <uix:spacer width="10"/>
                        <%-- <uix:tip renderedBinding="displayTip@servletRequest">
                          <uix:styledText textBinding="udmTipText@modelBean@servletRequest"
                                          shortDescBinding="udmTipText@modelBean@servletRequest"/>
                        </uix:tip>
                        <uix:spacer width="5"/> --%>
                        <uix:rowLayout width="100%">
                          <uix:include nodeBinding="legendTable@modelBean@servletRequest"/>
                        </uix:rowLayout>
                      </uix:header>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:contents>
            </uix:pageLayout>  
          </uix:form>
        </uix:body>
      </uix:document>
</uix:renderingContext>
