<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>

<uix:dataScope>
  <uix:bundle name="templBundle"
              class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle" 
              class="oracle.sysman.resources.MntrResourceBundle"/>
    <uix:stackLayout>
      <uix:contents>
        <uix:formValue name="normalTargetType" 
                       valueBinding="normalTargetType@comparisonSummaryBean@servletRequest"/>
        <uix:formValue name="targetType" 
                       valueBinding="targetType@comparisonSummaryBean@servletRequest"/>
        <uix:formValue name="templateOwner" 
                       valueBinding="templateOwner@comparisonSummaryBean@servletRequest"/>
        <uix:formValue name="templateName" 
                       valueBinding="templateName@comparisonSummaryBean@servletRequest"/>
        <uix:header textBinding="COMPARE_SUMMARY_HEADER@templBundle">
          <uix:stackLayout>
            <uix:switcher childNameBinding="showTargetsTable@comparisonSummaryBean@servletRequest">
              <uix:case name="true">
                <uix:stackLayout>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText textBinding="APPLY_SOURCE_TEMPLATE_PROMPT@templBundle"
                                        styleClass="OraInstructionText"/>
                      </uix:cellFormat>                 
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText textBinding="templateName@comparisonSummaryBean@servletRequest"
                                        styleClass="OraInstructionTextStrong"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText textBinding="TARGET_TYPE@mntrResourceBundle"
                                        styleClass="OraInstructionText"/>
                      </uix:cellFormat>                 
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText textBinding="targetType@comparisonSummaryBean@servletRequest"
                                        styleClass="OraInstructionTextStrong"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right">
                        <uix:styledText textBinding="OWNER@mntrResourceBundle"
                                        styleClass="OraInstructionText"/>
                      </uix:cellFormat>                 
                      <uix:spacer width="5"/>
                      <uix:cellFormat hAlign="left">
                        <uix:styledText textBinding="templateOwner@comparisonSummaryBean@servletRequest"
                                        styleClass="OraInstructionTextStrong"/>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout> 
                  <uix:spacer width="10"/>
                  <uix:tableLayout>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="left">
                        <uix:messageChoice name="currentViewModeFilter"
                                           promptBinding="VIEW@mntrResourceBundle" 
                                           shortDescBinding="VIEW@mntrResourceBundle"
                                           selectedValueBinding="currentViewMode@comparisonSummaryBean@servletRequest">
                          <uix:end>
                            <uix:submitButton textBinding="GO_BUTTON@mntrResourceBundle"
                                              shortDescBinding="GO_BUTTON@mntrResourceBundle"
                                              name="event" 
                                              value="go_button"/>
                          </uix:end>
                          <uix:contents childDataBinding="viewModes@comparisonSummaryBean@servletRequest">
                            <uix:option  textBinding="text"
                                         valueBinding="value"
                                         rendered="true"/>
                          </uix:contents>
                        </uix:messageChoice>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:tableLayout> 
                  <uix:spacer height="15"/>
                  <uix:stackLayout>
                    <uix:contents>
                      <uix:table name="comparisonSummaryTable" 
                                 id="comparisonSummaryTable" 
                                 partialRenderMode="self" 
                                 alternateTextBinding="NO_DATA_STR@mntrResourceBundle"
                                 width="75%" 
                                 showAll="yes" 
                                 summaryBinding="DESTINATION_TARGETS@mntrResourceBundle"
                                 formSubmitted="true" 
                                 valueBinding="value@comparisonSummaryBean@servletRequest" 
                                 minValueBinding="minValue@comparisonSummaryBean@servletRequest" 
                                 maxValueBinding="maxValue@comparisonSummaryBean@servletRequest" 
                                 blockSizeBinding="blockSize@comparisonSummaryBean@servletRequest" 
                                 tableDataBinding="tableDataKey@tableData@comparisonSummaryBean@servletRequest" 
                                 columnFormatsBinding="columnFormats@comparisonSummaryBean@servletRequest" 
                                 columnHeaderDataBinding="columnHeaderData@comparisonSummaryBean@servletRequest">
                        <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>
                          <uix:tableSelection >
                            <uix:multipleSelection    
                                    selectionBinding="selection@comparisonSummaryBean@servletRequest" 
                                    shortDescBinding="SELECT@commonResourceBundle"
                                    selectedBinding="selected">
                              <uix:submitButton textBinding="APPLY_TEMPLATE@templBundle"
                                                name="event" 
                                                value="apply_template"/>
                            </uix:multipleSelection>
                          </uix:tableSelection>
                          <uix:contents>
                            <uix:styledText textBinding="target_name"/>
                            <uix:styledText textBinding="comparison_result"
                                            destinationBinding="diffDestination"/>
                            <uix:formValue name="target_name" valueBinding="target_name"/>
                          </uix:contents>
                      </uix:table>
                    </uix:contents>
                  </uix:stackLayout>
                </uix:stackLayout>
              </uix:case>
              <uix:case name="false">
                <uix:cellFormat hAlign="left">
                  <uix:styledText styleClass="OraInstructionText"
                                    textBinding="noTargetsDisplayLabel@comparisonSummaryBean@servletRequest"/>
                </uix:cellFormat>
              </uix:case>
            </uix:switcher>
          </uix:stackLayout>
        </uix:header>
        <uix:spacer height="5"/>
      </uix:contents>
    </uix:stackLayout> 
</uix:dataScope>
