<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.metrics.template.TemplateConstants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>
<jsp:useBean id="defaultBean" 
             scope="request" 
             type="oracle.sysman.eml.metrics.template.PendingChangesData"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

 <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResourceBundle"
             class="oracle.sysman.resources.MntrResourceBundle"/>
 <uix:bundle name="templBundle"
             class="oracle.sysman.eml.metrics.template.TemplateMsg"/>            

  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>

    
    <uix:body>
     <uix:form name="pendingChangesForm" method="POST">
      
        <uix:pageLayout titleBinding="pageHeader@servletRequest">
          <%@ include file="/oemGlobal.jspf"%> 
          <%@ include file="../../health/header.jsp"%>
          
          <uix:messages>
           <uix:flowLayout>
            <uix:messageBox renderedBinding="showConfirmationMessage@defaultBean@servletRequest"
                            messageBinding="confirmationMessage@defaultBean@servletRequest" 
                            messageType="confirmation" 
                            shortDescBinding="CONFIRMATION@commonResourceBundle" 
                            textBinding="CONFIRMATION@commonResourceBundle"/>
            <uix:messageBox renderedBinding="showErrorMessage@defaultBean@servletRequest"
                            messageBinding="errorMessage@defaultBean@servletRequest" 
                            messageType="error" 
                            shortDescBinding="ERROR@commonResourceBundle" 
                            textBinding="ERROR@commonResourceBundle"/>  
           </uix:flowLayout>
          </uix:messages>
          
          <uix:contentFooter>
           <uix:pageButtonBar>                    
            <uix:tableLayout>
             <uix:rowLayout>
              <uix:submitButton name="event"
                                textBinding="OK@commonResourceBundle"
                                value="<%=Constants.SUBMIT_EVENT%>"/>
             </uix:rowLayout>
            </uix:tableLayout>
           </uix:pageButtonBar>
          </uix:contentFooter>
          
          <uix:contents>
          
          <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
           <uix:case name="<%=Constants.OK_NODE_VALUE%>">
               
               <uix:stackLayout>
                <uix:contents>
                
                 <uix:tableLayout>
                  <uix:contents>
                    <uix:cellFormat width="30%" vAlign="top">
                     <uix:rowLayout hAlign="right">
                      <uix:cellFormat wrappingDisabled="true">
                       <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED@mntrResourceBundle"/>
                      </uix:cellFormat>
                      <uix:spacer width="7"/>
                      <uix:cellFormat wrappingDisabled="true">
                       <uix:styledText styleClass="OraTipLabel" textBinding="timestamp@defaultBean@servletRequest"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat wrappingDisabled="true">
                       <uix:submitButton textBinding="REFRESH@commonResourceBundle" shortDescBinding="REFRESH@commonResourceBundle" name="event" value="<%=Constants.REFRESH_EVENT%>"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat>
                       <uix:submitButton name="event"
                                         textBinding="OK@commonResourceBundle"
                                         value="<%=Constants.SUBMIT_EVENT%>"/>
                      </uix:cellFormat>             
                     </uix:rowLayout>
                    </uix:cellFormat>
                   </uix:contents>
                  </uix:tableLayout>
                
                 <uix:spacer height="5"/>   
                 
                 <%--<uix:rowLayout >
                  <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                 </uix:rowLayout>--%>

                <uix:header textBinding="SEARCH@commonResourceBundle">
                <uix:tableLayout width="100%" cellSpacing="3">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:styledText textBinding="TEMPLATE_NAME_PROMPT@templBundle"
                                            shortDescBinding="TEMPLATE_NAME_PROMPT@templBundle"
                                            styleClass="OraPromptText"/>
                            <uix:spacer width="5"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:choice name="choiceTemplateName"
                                        id="choiceTemplateName"
                                        selectedValueBinding="operatorTemplateName@defaultBean@servletRequest"
                                        shortDesc="choiceTemplateName">
                              <uix:contents >
                                <uix:option textBinding="CONTAINS@templBundle"
                                            value="contains_TemplateName"/>
                                <uix:option textBinding="IS_EXACTLY@templBundle"
                                            value="is_exactly_TemplateName"/>
                              </uix:contents>
                            </uix:choice>
                            <uix:spacer width="5"
                                    rendered="true"/>
                            <uix:textInput name="templateName"
                                           id="templateName"
                                           textBinding="templateName@defaultBean@servletRequest"
                                           shortDesc="searchTemplateName"/>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat width="15%" hAlign="right">
                          <uix:contents>
                            <uix:styledText textBinding="TARGET_TYPE@templBundle"
                                            shortDescBinding="TARGET_TYPE@templBundle"
                                            labeledNodeId="selectTargetTypeNodeId"
                                            styleClass="OraPromptText"/>
                            <uix:spacer width="5"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat width="85%" hAlign="left">
                          <uix:contents>
                            <uix:choice name="templateTargetType"
                                        id="templateTargetType"
                                        selectedValueBinding="templateTargetType@defaultBean@servletRequest">
                            <uix:contents childDataBinding="templateList@defaultBean@servletRequest">
                            <uix:option  textBinding="text"
                                         valueBinding="value"
                                         rendered="true"/>
                            </uix:contents>
                            </uix:choice>

                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:styledText textBinding="TARGET_NAME@templBundle"
                                            shortDescBinding="TARGET_NAME@templBundle"
                                            styleClass="OraPromptText"/>
                            <uix:spacer width="5"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:choice name="choiceTargetName"
                                        id="choiceTargetName"
                                        shortDesc="choiceTargetName"
                                        selectedValueBinding="operatorTargetName@defaultBean@servletRequest">
                              <uix:contents >
                                <uix:option textBinding="CONTAINS@templBundle"
                                            value="contains_TargetName"/>
                                <uix:option textBinding="IS_EXACTLY@templBundle"
                                            value="is_exactly_TargetName"/>
                              </uix:contents>
                            </uix:choice>
                            <uix:spacer width="5"
                                    rendered="true"/>
                            <uix:textInput name="target"
                                           id="target"
                                           textBinding="target@defaultBean@servletRequest"
                                           shortDesc="searchTargetName"/>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:styledText textBinding="VIEW_APPLY_OPERATIONS_DROPDOWN_LABEL@templBundle"
                                            shortDescBinding="VIEW_APPLY_OPERATIONS_DROPDOWN_LABEL@templBundle"
                                            labeledNodeId="selectAView"
                                            styleClass="OraPromptText"/>
                            <uix:spacer width="5"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:choice name="view"
                                        id="view"
                                        selectedValueBinding="view@defaultBean@servletRequest">
                              <uix:contents>
                                <uix:option textBinding="PAST_STATUS@templBundle"
                                            value="past"/>
                                <uix:option textBinding="PENDING_STATUS@templBundle"
                                            value="pending"/>
                              </uix:contents>
                            </uix:choice>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:contents>
                        <uix:cellFormat hAlign="right">
                          <uix:contents>
                            <uix:spacer width="5"/>
                          </uix:contents>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left">
                          <uix:contents>
                            <uix:spacer width="5"/>
                            <uix:submitButton textBinding="GO@commonResourceBundle"
                                              shortDescBinding="GO@commonResourceBundle"
                                              name="event"
                                              value="searchTemplateOperations"/> 
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:contents>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:tableLayout>
                </uix:header>

                 <uix:spacer height="10"/> 
                       
                 <uix:table name="pendingChangesTable" 
                            id="pendingChangesTable" 
                            alternateTextBinding="NO_DATA_STR@mntrResourceBundle" 
                            width="100%" 
                            formSubmitted="true" 
                            blockSize="10" 
                            valueBinding="tableValue@defaultBean@servletRequest" 
                            minValueBinding="minValue@defaultBean@servletRequest" 
                            maxValueBinding="maxValue@defaultBean@servletRequest" 
                            summaryBinding="pageHeader@servletRequest"
                            tableDataBinding="tableDataKey@tableData@defaultBean@servletRequest" 
                            columnFormatsBinding="tableColumnFormats@defaultBean@servletRequest" 
                            columnHeaderDataBinding="tableColumnHeaders@defaultBean@servletRequest">
                                   
                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>
                          
                          <uix:tableSelection>
                           <uix:multipleSelection selectionBinding="selection@defaultBean@servletRequest" 
                                                  disabledBinding="disableRow"
                                                  selectedBinding="<%=MetricThresholdConstants.SELECTED_KEY%>"
                                                  shortDescBinding="SELECT@commonResourceBundle">
                            <uix:flowLayout>                     
                             <uix:submitButton textBinding="STOP_APPLY_OPERATION_BUTTON_LABEL@templBundle" 
                                               renderedBinding="hasScheduled@defaultBean@servletRequest"
                                               name="event" 
                                               value="<%=TemplateConstants.STOP_PENDING_JOBS_CONFIRMATION_EVENT%>"/>
                             <uix:spacer width="2"/>
                             <uix:submitButton textBinding="DELETE_APPLY_OPERATIONS_BUTTON_LABEL@templBundle" 
                                               renderedBinding="hasPast@defaultBean@servletRequest"
                                               name="event" 
                                               value="<%=TemplateConstants.DELETE_PAST_JOBS_CONFIRMATION_EVENT%>"/>
                            </uix:flowLayout>                   
                           </uix:multipleSelection>                  
                          </uix:tableSelection>     
                          
                          <uix:tableActions>  
                           <uix:flowLayout>
                            <uix:submitButton textBinding="STOP_ALL_APPLY_OPERATIONS_BUTTON_LABEL@templBundle" 
                                              renderedBinding="hasScheduled@defaultBean@servletRequest"
                                              name="event" 
                                              value="<%=TemplateConstants.STOP_ALL_PENDING_JOBS_CONFIRMATION_EVENT%>"/>
                            <uix:submitButton textBinding="DELETE_ALL_APPLY_OPERATIONS_BUTTON_LABEL@templBundle" 
                                              renderedBinding="hasPast@defaultBean@servletRequest"
                                              name="event" 
                                              value="<%=TemplateConstants.DELETE_ALL_PAST_JOBS_CONFIRMATION_EVENT%>"/>                  
                           </uix:flowLayout>                  
                          </uix:tableActions>
                
                          <uix:contents>
                           <uix:styledText textBinding="<%=Constants.TEMPLATE_NAME_KEY%>"/>
                           <uix:link textBinding="<%=Constants.TARGET_NAME_KEY%>"
                                     destinationBinding="<%=Constants.DESTINATION_KEY%>"/>
                           <uix:styledText textBinding="<%=Constants.TEMPLATE_TARGET_TYPE_KEY%>"/>
                           <uix:styledText textBinding="<%=TemplateConstants.AGENT_NAME_KEY%>"/>
                           <uix:styledText textBinding="appliedBy"/>
                           <uix:styledText textBinding="<%=Constants.TIMESTAMP_DATE_KEY%>"/>
                           <uix:styledText textBinding="runStatus"/>
                           <uix:styledText textBinding="errorMessage"/>
                           <uix:image sourceBinding="iconSource"
                                      destinationBinding="iconDestination"
                                      shortDescBinding="shortDescription"/>
                           <uix:formValue valueBinding="executionID"
                                          name="executionID"/>
                          </uix:contents>
                        </uix:table>
                        
                        <%--<uix:rowLayout width="85%">
                        <uix:tip renderedBinding="showTableTip@defaultBean@servletRequest">
                         <uix:contents>
                          <uix:styledText textBinding="tableTip@defaultBean@servletRequest"/>
                         </uix:contents>
                        </uix:tip>
                        </uix:rowLayout>--%>
                         
                      </uix:contents>
                    </uix:stackLayout>
              </uix:case>
              <uix:case name="<%=Constants.ERR_NODE_VALUE%>">
            <uix:messageBox messageBinding="tableErrorMessage@defaultBean@servletRequest" 
                            messageType="error" 
                            shortDescBinding="ERR_OCCUR@mntrResourceBundle" 
                            textBinding="ERR_OCCUR@mntrResourceBundle"/>
          </uix:case>
         </uix:switcher>
            
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
