<%@ include file="/oemNoscript.jspf" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<%@ page import="oracle.sysman.eml.metrics.target.ReorderObjectViewBean"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>
      <uix:form name="ROForm" method="POST">
        <uix:pageLayout titleBinding="header@viewBean@servletRequest">
          <%@ include file="/oemGlobal.jspf" %>

          <% ReorderObjectViewBean reorderObjectViewBean = (ReorderObjectViewBean)request.getAttribute("viewBean"); %>

          <% if (reorderObjectViewBean.getShowHealthHeader() == true) { %>
          <%@ include file="/health/header.jsp"%>
          <% } %>

          <uix:pageButtons>
            <uix:pageButtonBar>
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
                    <uix:case name="okNode">
                      <uix:cellFormat>
                        <uix:submitButton name="event"
                                          textBinding="CANCEL@sdkUIMsg"
                                          value="Cancel"
                                          renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:spacer width="4" renderedBinding="hasPriv@viewBean@servletRequest"/>
                        <uix:submitButton name="event"
                                          textBinding="CONTINUE@sdkUIMsg"
                                          value="Continue"/>
                      </uix:cellFormat>
                    </uix:case>
                    <uix:case name="errNode">
                      <uix:submitButton name="event"
                                        textBinding="CONTINUE@sdkUIMsg"
                                        value="Error"/>
                    </uix:case>
                  </uix:switcher>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:pageButtonBar>
          </uix:pageButtons>

          <uix:contents>
            <uix:switcher childNameBinding="nodeValue@viewBean@servletRequest">
              <uix:case name="okNode">
                <uix:stackLayout>
                  <uix:styledText styleClass="OraInstructionText"
                                  textBinding="REORDER_OBJECTS_INSTRUCTION@mntrResourceBundle"/>

                  <uix:shuttle name="shuttle"
                               leadingHeaderBinding="keyColumnLabel@viewBean@servletRequest"
                               size="5">
                    <uix:leading>
                      <uix:list shortDescBinding="keyColumnLabel@viewBean@servletRequest" >
                        <uix:contents childDataBinding="keyValueList@viewBean@servletRequest">
                          <uix:option textBinding="text"
                                      valueBinding="value"/>
                        </uix:contents>
                      </uix:list>
                    </uix:leading>
                  </uix:shuttle>

                  <uix:formValue name="hasPriv" valueBinding="hasPrivString@viewBean@servletRequest"/>
                </uix:stackLayout>
              </uix:case>

              <uix:case name="errNode">
                <uix:messageBox messageBinding="errorMessage@viewBean@servletRequest"
                                messageType="error"
                                shortDescBinding="ERR_OCCUR@mntrResourceBundle"
                                textBinding="ERR_OCCUR@mntrResourceBundle">
                </uix:messageBox>
              </uix:case>
            </uix:switcher>
          </uix:contents>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
