<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.emSDK.tgt.sel.TargetSelectionUtil"%>
<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>

 <uix:bundle name="templBundle"
             class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
 <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResourceBundle"
             class="oracle.sysman.resources.MntrResourceBundle"/>

  <uix:document>
   <%@ include file="/oemTitle.jspf"%>
   <%@ include file="/oemNoscript.jspf" %>    
    <uix:body>
    <uix:form name="selectTargetForm" method="POST" id="selectTargetForm" destination="/console/metrics/template/selectTarget">
     
       <uix:pageLayout titleBinding="pageHeader@servletRequest">
        <%@ include file="/oemGlobal.jspf"%>   
        <%@ include file="../../health/header.jsp"%>

        <uix:contentFooter>
         <uix:pageButtonBar>                    
          <uix:contents>
           <uix:tableLayout>
            <uix:contents>
             <uix:rowLayout>
              <uix:contents>
               <uix:submitButton textBinding="CANCEL@commonResourceBundle" 
                                    name="event"
                                    value="<%=Constants.CANCEL_EVENT%>"/> 
               <uix:spacer width="3"/> 
               <uix:submitButton textBinding="CONTINUE@commonResourceBundle" 
                                    name="event"
                                    value="<%=Constants.CONTINUE_EVENT%>"/> 
              </uix:contents>
             </uix:rowLayout>
            </uix:contents>
           </uix:tableLayout>
          </uix:contents>
         </uix:pageButtonBar>
        </uix:contentFooter>
        
        <uix:spacer height="5"/>
        <uix:contents>
        
        <uix:switcher childNameBinding="showTargetErrorMessage@servletRequest">
         <uix:case name="true">
          <uix:stackLayout>
            <uix:messageBox messageBinding="targetErrorMessage@servletRequest" 
                            messageType="error" 
                            shortDescBinding="ERROR@mntrResourceBundle" 
                            textBinding="ERROR@mntrResourceBundle"/>
          </uix:stackLayout> 
         </uix:case>
        </uix:switcher>
           
        <uix:spacer height="5"/>
        
        <uix:switcher childNameBinding="nodeValue@servletRequest">
         <uix:case name="<%=Constants.OK_NODE_VALUE%>">
           
           <uix:stackLayout>
           
            <uix:rowLayout hAlign="right">
             <uix:submitButton textBinding="CANCEL@commonResourceBundle" 
                               name="event" 
                               value="<%=Constants.CANCEL_EVENT%>"/>
             <uix:spacer height="3"/>
             <uix:submitButton textBinding="CONTINUE@commonResourceBundle" 
                               name="event" 
                               value="<%=Constants.CONTINUE_EVENT%>"/>
            </uix:rowLayout>
            
            <uix:rowLayout>
             <uix:spacer height="20"/>
            </uix:rowLayout> 
            
            <uix:rowLayout>
             <uix:styledText textBinding="SELECT_TARGET_DESCRIPTIVE_TEXT@templBundle" 
                             styleClass="OraInstructionText"/>
            </uix:rowLayout>                  
                            
            <uix:spacer height="10"/>
            
            <uix:rowLayout>
             <uix:cellFormat vAlign="top">
              <uix:messageLovField name="selectedTargetName"
                                   promptBinding="SELECT_TARGET_LOV_FIELD_LABEL@templBundle"
                                   required="uiOnly"
                                   textBinding="selectedTarget@servletRequest"
                                   searchDescBinding="SELECT_TARGET_LOV_FIELD_LABEL@templBundle"
                                   shortDescBinding="SELECT_TARGET_LOV_FIELD_LABEL@templBundle"
                                   onClick="<%=TargetSelectionUtil.getOnClick()%>"/>
             </uix:cellFormat>
             <uix:cellFormat width="60%" 
                             hAlign="right">
              <uix:contentContainer textBinding="TIP@templBundle"
                                    width="100%">
               <uix:styledText textBinding="SELECT_TARGET_CONTAINER@templBundle"
                               styleClass="OraInstructionText"/>
              </uix:contentContainer>
             </uix:cellFormat> 
                  
            </uix:rowLayout>
            <uix:rowLayout>
             <uix:formValue name="searchPage"/>                     
            </uix:rowLayout>
            
           </uix:stackLayout>
         
       </uix:case>
       <uix:case name="<%=Constants.ERR_NODE_VALUE%>">
        <uix:messageBox messageBinding="errorMessage@servletRequest" 
                        messageType="error" 
                        shortDescBinding="ERR_OCCUR@mntrResourceBundle" 
                        textBinding="ERR_OCCUR@mntrResourceBundle"/>
       </uix:case>
      </uix:switcher>
     </uix:contents>
        
    </uix:pageLayout>
      
   </uix:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
