<%--
  -- Page:        templateSetup.jsp
  --
  --  MODIFIED    (MM/DD/YY)
  --   hmodawel    02/27/06 - fix ojsp 1013 compilation errors 
  --   paachary    12/01/05 - Adding the "Compare Settings" submit button on this page
  --   paachary    08/07/06 - Backport paachary_bug-5396307 from main
  --   njuillar    07/27/05 - Make template name link generate an event 
  --   njuillar    07/13/05 - Put error/info messages above page header 
  --   njuillar    07/01/05 - 
  --   njuillar    05/12/05 - Add page title 
  --   njuillar    05/11/05 - Change info message to confirmation type 
  --   njuillar    05/03/05 - Add showAll feature for table 
  --   njuillar    03/22/05 - Add Pending Changes field 
  --   njuillar    03/08/05 - Remove extra space at top of page 
  --   njuillar    03/02/05 - Fix bug 4151772 
  --   njuillar    02/10/05 - Show out-of-box templates tip only if there is 
  --                          at least one such template 
  --   aholser     12/15/04 - 
  --   kchiasso    11/10/04 - fix search layout
  --%>
<%@ include file="/sdk/oemTop.jspf"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.metrics.template.TemplateConstants"%>
<jsp:useBean id="defaultBean" 
             scope="request" 
             type="oracle.sysman.eml.metrics.template.TemplatesSetupData"/>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>

 <uix:bundle name="templBundle"
             class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
 <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
 <uix:bundle name="mntrResourceBundle"
             class="oracle.sysman.resources.MntrResourceBundle"/>

  <uix:document>
    <%@ include file="/enablePPR.jspf"%>
    <%@ include file="/oemTitle.jspf"%>
    <%@ include file="/oemNoscript.jspf" %>
    
    <uix:form name="templatesSetupForm" method="POST" destination="/console/metrics/template/templatesSetup">
      <uix:body>
        <uix:pageLayout titleBinding="pageHeader@servletRequest">
          <%@ include file="/oemGlobal.jspf"%>  
          <%@ include file="../../health/header.jsp"%>
          
          <uix:messages>
           <uix:flowLayout>
            <uix:messageBox renderedBinding="showInformationalMessage@defaultBean@servletRequest"
                            messageBinding="informationalMessage@defaultBean@servletRequest" 
                            messageType="confirmation" 
                            shortDescBinding="CONFIRMATION@commonResourceBundle" 
                            textBinding="CONFIRMATION@commonResourceBundle"/>
                          
            <uix:messageBox renderedBinding="showWarningMessage@defaultBean@servletRequest"
                            messageBinding="warningMessage@defaultBean@servletRequest" 
                            messageType="warning" 
                            shortDescBinding="WARNING@mntrResourceBundle" 
                            textBinding="WARNING@mntrResourceBundle"/>  
                          
            <uix:messageBox renderedBinding="showErrorMessage@defaultBean@servletRequest"
                            messageBinding="errorMessage@defaultBean@servletRequest" 
                            messageType="error" 
                            shortDescBinding="ERROR@commonResourceBundle" 
                            textBinding="ERROR@commonResourceBundle"/> 
           </uix:flowLayout>
          </uix:messages>

          <uix:start>
          <%@ include file="adminSideNav.jspf"%>
          </uix:start>
          
          <uix:contents>
          
          <uix:tableLayout>
          
          <uix:cellFormat hAlign="right">
          
          <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
           <uix:case name="<%=Constants.OK_NODE_VALUE%>">
               
             <uix:stackLayout>
              <uix:contents>
               
               <uix:tableLayout width="100%">
                <uix:contents>                     
                 <uix:cellFormat vAlign="top">
                  <uix:rowLayout hAlign="right">
                   <uix:cellFormat wrappingDisabled="true">
                    <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED@mntrResourceBundle"/>
                   </uix:cellFormat>
                   <uix:spacer width="7"/>
                   <uix:cellFormat wrappingDisabled="true">
                    <uix:styledText styleClass="OraTipLabel" textBinding="timestamp@defaultBean@servletRequest"/>
                   </uix:cellFormat>
                   <uix:spacer width="5"/>
                   <uix:cellFormat wrappingDisabled="true">
                    <uix:submitButton textBinding="REFRESH@commonResourceBundle" name="event" value="<%=Constants.REFRESH_EVENT%>"/>
                   </uix:cellFormat>
                  </uix:rowLayout>
                 </uix:cellFormat>
                </uix:contents>
               </uix:tableLayout>
                    
               <uix:spacer height="5"/>      
               
                    <uix:tableLayout width="100%">
                      <uix:contents>
                      
                      <uix:rowLayout>
                <uix:styledText textBinding="descriptiveText@defaultBean@servletRequest" styleClass="OraInstructionText"/>
                </uix:rowLayout>

                       <uix:rowLayout>
                          <uix:spacer height="20"/>
                       </uix:rowLayout>

                        <uix:rowLayout >
                          <uix:include nodeBinding="eml_ecm_sc_uiNode@servletRequest"/>
                        </uix:rowLayout>
                        
                        <uix:rowLayout>
                         <uix:spacer height="10"/>
                        </uix:rowLayout>
                        
                        <uix:switcher childNameBinding="pendingChangesNodeValue@defaultBean@servletRequest">
                         <uix:case name="<%=Constants.OK_NODE_VALUE%>">
                          <uix:rowLayout width="100%">
                           <uix:cellFormat wrappingDisabled="true" hAlign="left">
                            <uix:styledText textBinding="PENDING_CHANGES_HEADER@templBundle"
                                            styleClass="OraInstructionText"/>
                            <uix:spacer width="8"/>         
                            <uix:switcher childNameBinding="hasAllPendingChanges@defaultBean@servletRequest">
                             <uix:case name="true">
                              <uix:styledText textBinding="allPendingChangesValue@defaultBean@servletRequest"
                                              destinationBinding="allPendingChangesDestination@defaultBean@servletRequest"
                                              styleClass="OraInstructionText"/>
                             </uix:case>
                             <uix:case name="false">
                              <uix:styledText textBinding="allPendingChangesValue@defaultBean@servletRequest"
                                              styleClass="OraInstructionText"/>
                             </uix:case>
                            </uix:switcher> 
                           </uix:cellFormat>
                          </uix:rowLayout>
                         </uix:case>
                         <uix:case name="<%=Constants.ERR_NODE_VALUE%>"> 
                          <uix:messageBox messageBinding="pendingChangesErrorMessage@defaultBean@servletRequest" 
                                          messageType="error" 
                                          shortDescBinding="ERR_OCCUR@mntrResourceBundle" 
                                          textBinding="ERR_OCCUR@mntrResourceBundle"/>
                         </uix:case>
                        </uix:switcher>
                        
                        <uix:rowLayout>
                         <uix:spacer height="10"/>
                        </uix:rowLayout>
                        
                         <uix:rowLayout>
                         <uix:table name="templatesTable" 
                                    id="templatesTable" 
                                    summaryBinding="SETUP_HEADER@templBundle"
                                    partialRenderMode="self" 
                                    alternateTextBinding="NO_DATA_STR@mntrResourceBundle" 
                                    width="100%" 
                                    formSubmitted="true" 
                                    blockSize="25" 
                                    showAll="yes"
                                    valueBinding="tableValue@defaultBean@servletRequest" 
                                    minValueBinding="minValue@defaultBean@servletRequest" 
                                    maxValueBinding="maxValue@defaultBean@servletRequest" 
                                    tableDataBinding="tableDataKey@tableData@defaultBean@servletRequest" 
                                    columnFormatsBinding="tableColumnFormats@defaultBean@servletRequest" 
                                    columnHeaderDataBinding="tableColumnHeaders@defaultBean@servletRequest">
                                   
                          <uix:tableFormat tableBanding="rowBanding"/>
                          <uix:columnHeaderStamp>
                            <uix:sortableHeader textBinding="text" sortableBinding="sortable"/>
                          </uix:columnHeaderStamp>
                          <uix:tableSelection>
                            <uix:singleSelection selectedIndex="0" shortDescBinding="SELECT@commonResourceBundle">
                                                
                              <uix:submitButton textBinding="APPLY@commonResourceBundle" 
                                                name="event" 
                                                value="<%=Constants.APPLY_TEMPLATE_EVENT%>"/>
                              <uix:spacer width="2"/>
                              <uix:submitButton textBinding="VIEW@commonResourceBundle" 
                                                name="event" 
                                                value="<%=Constants.VIEW_EVENT%>"/>
                              <uix:spacer width="2"/>
                              <uix:submitButton textBinding="EDIT@commonResourceBundle" 
                                                name="event" 
                                                value="<%=Constants.EDIT_EVENT%>"/>
                              <uix:spacer width="2"/>
                              <uix:submitButton textBinding="CREATE_LIKE@commonResourceBundle" 
                                                name="event" 
                                                value="<%=Constants.CREATE_TEMPLATE_LIKE_EVENT%>"/>
                              <uix:spacer width="2"/>
                              <uix:submitButton textBinding="DELETE@commonResourceBundle" 
                                                name="event" 
                                                value="<%=Constants.CONFIRM_DELETE_EVENT%>"/>
                              <uix:spacer width="2"/>
                              <uix:submitButton textBinding="COMPARE_SETTINGS@commonResourceBundle" 
                                                name="event" 
                                                value="<%=Constants.COMPARE_SETTINGS%>"/>
                            </uix:singleSelection>
                          </uix:tableSelection>
                          
                          <uix:tableActions>    
                           <uix:submitButton textBinding="CREATE@commonResourceBundle" 
                                             name="event" 
                                             value="<%=Constants.CREATE_EVENT%>"/>
                          </uix:tableActions> 
                          
                          <uix:contents>
                            <uix:link textBinding="<%=Constants.TEMPLATE_NAME_KEY%>"
                                      onClickBinding="<%=TemplateConstants.TEMPLATE_NAME_CLICK_BINDING%>"/>
                            <uix:styledText textBinding="<%=Constants.TEMPLATE_TARGET_TYPE_LOCALIZED_KEY%>"/>
                            <uix:styledText textBinding="pendingChanges"
                                            destinationBinding="pendingChangesDestination"/>
                            <uix:styledText textBinding="<%=Constants.TEMPLATE_OWNER_KEY%>"/>
                            <uix:styledText textBinding="<%=Constants.TEMPLATE_LAST_MODIFIED_BY_KEY%>"/>
                            <uix:styledText textBinding="<%=Constants.TEMPLATE_LAST_MODIFIED_ON_KEY%>"/>
                            <uix:formValue valueBinding="<%=Constants.TEMPLATE_NAME_KEY%>" 
                                           name="<%=Constants.TEMPLATE_NAME_KEY%>"/> 
                            <uix:formValue valueBinding="<%=Constants.TEMPLATE_TARGET_TYPE_KEY%>" 
                                           name="<%=Constants.TEMPLATE_TARGET_TYPE_KEY%>"/> 
                            <uix:formValue valueBinding="<%=Constants.TEMPLATE_IS_PUBLIC_KEY%>" 
                                           name="<%=Constants.TEMPLATE_IS_PUBLIC_KEY%>"/>
                          </uix:contents>
                        </uix:table>
                        </uix:rowLayout>
 
                        <uix:rowLayout>
                         <uix:cellFormat>
                          <uix:spacer height="10"/>
                         </uix:cellFormat> 
                        </uix:rowLayout>
                        <uix:rowLayout hAlign="left">
                         <uix:tip renderedBinding="hasOutOfBoxTemplate@defaultBean@servletRequest">
                          <uix:contents>
                           <uix:styledText textBinding="SETUP_TIP@templBundle"/>
                          </uix:contents>
                         </uix:tip>
                        </uix:rowLayout> 
                      </uix:contents>
                    </uix:tableLayout>
                  </uix:contents>
                </uix:stackLayout>
              </uix:case>
              <uix:case name="<%=Constants.ERR_NODE_VALUE%>">
            <uix:messageBox messageBinding="tableErrorMessage@defaultBean@servletRequest" 
                            messageType="error" 
                            shortDescBinding="ERR_OCCUR@mntrResourceBundle" 
                            textBinding="ERR_OCCUR@mntrResourceBundle"/>
          </uix:case>
            </uix:switcher>
            
            </uix:cellFormat>
            </uix:tableLayout>
          </uix:contents>
          
         <oem:relatedLinks/>
          
        </uix:pageLayout>
      </uix:body>
    </uix:form>
  </uix:document>
</uix:renderingContext>
