<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ include file="/sdk/oemTop.jspf" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="templBundle"
              class="oracle.sysman.eml.metrics.template.TemplateMsg"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
              class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="sdkBundle"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:document>
    <%@ include file="/enablePPR.jspf" %>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>

    <uix:body>
     <uix:form name="warnConflictForm" method="POST">
      
      <uix:pageLayout titleBinding="CONFIRMATION@sdkUIBundle" messageType="confirmation">
       <%@ include file="/oemGlobal.jspf" %>
       <%@ include file="../../health/header.jsp"%>
       
        <uix:messages>
         <uix:messageBox rendered="false"
                         renderedBinding="renderErrorMessageBox@viewBean@servletRequest"
                         messageBinding="errorMessage@viewBean@servletRequest"
                         messageType="error">
         </uix:messageBox>
        </uix:messages>
       
        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:tableLayout>
           <uix:rowLayout>
            <uix:submitButton name="event"
                              textBinding="CANCEL@commonResourceBundle"
                              value="<%=Constants.CANCEL_EVENT%>"/>
            <uix:spacer width="4"/>
            <uix:submitButton name="event"
                              textBinding="CONTINUE@commonResourceBundle"
                              value="<%=Constants.CONTINUE_EVENT%>"/>
           </uix:rowLayout>
          </uix:tableLayout>
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:contents>
          <uix:tableLayout hAlign="end">
           <uix:rowLayout>
            <uix:submitButton name="event"
                              textBinding="CANCEL@commonResourceBundle"
                              value="<%=Constants.CANCEL_EVENT%>"/>
            <uix:spacer width="4"/>
            <uix:submitButton name="event"
                              textBinding="CONTINUE@commonResourceBundle"
                              value="<%=Constants.CONTINUE_EVENT%>"/>
           </uix:rowLayout>
          </uix:tableLayout>

          <uix:spacer height="20"/>
          <uix:styledText textBinding="METRIC_ALREADY_EXIST@templBundle" styleClass="OraInstructionTextStrong"/>
          <uix:spacer height="10"/>
          <uix:styledText textBinding="comment2@servletRequest" styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:styledText textBinding="METRIC_ALREADY_EXIST_COMMENT2@templBundle" styleClass="OraInstructionText"/>
          <uix:spacer height="10"/>
          <uix:tableLayout width="50%">
            <uix:rowLayout width="50%">
              <uix:include nodeBinding="tableNode@servletRequest"/>
            </uix:rowLayout>
          </uix:tableLayout>
          <uix:spacer height="10"/>

        </uix:contents>

      </uix:pageLayout>
     </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
