<%--

/* $Header: URLtransaction.jsp 31-jul-2005.16:17:30 andyao Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */
    
/*  
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>
  
   MODIFIED    (MM/DD/YY)
    andyao        07/31/05 - add style 
    andyao        06/14/05 - fix OAC issues 
    dbrown        05/28/03 - Set charset to utf-8.
    rmarripa      02/21/03 - cleanup
    rmarripa      02/20/03 - cleanup resources
    rmarripa      09/25/02 - fix bug-2592024, set the MODE
    asawant       06/24/02 - Fixing the comment header
    asawant       06/10/02 - history section added
 */
    
/**
 *  @version $Header: URLtransaction.jsp 31-jul-2005.16:17:30 andyao Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem"%>
<%@ page import="oracle.sysman.eml.beacon.BeaconConstants"%>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.beacon.data.TransactionDefinition"/>

<head>
  <oem:styleSheet/>
  <oem:title textProp="headerAndTitle"/>
</head>
<oem:body>
  <oem:contents>
    <oem:form name="URLTransactionForm"
              destinationProp="formDestination"
              method="POST">
      <oem:contents>
        <oem:pageLayout quickLinksShown="true">
          <%@ include file="/oemPageGlobal.jspf" %>

          <oem:contentFooter>
           <oem:flowLayout>
            <oem:contents>
             <oem:submitButton name="event" 
                               value="<%=BeaconConstants.BCN_PING_HTTP_EVENT%>" 
                               textProp="testResponseButtonLabel"/>

             <oem:spacer width="5"/>

             <oem:button textProp="cancelButtonLabel"
                         destinationProp="cancelButtonDestination"/>

             <oem:spacer width="5"/>

             <oem:submitButton name="event" 
                               valueProp="revertEvent" 
                               textProp="revertButtonLabel"/>

             <oem:spacer width="5"/>

             <oem:submitButton name="event"
                               valueProp="applyEvent" 
                               textProp="applyButtonLabel"/>
            </oem:contents>
           </oem:flowLayout>
          </oem:contentFooter>

          <oem:contents>

           <oem:formValue name="<%=BeaconConstants.TARGET_PAGE_PROPERTY%>" 
                          valueProp="targetName"/>

           <oem:formValue name="<%=BeaconConstants.TARGET_TYPE_PAGE_PROPERTY%>" 
                          valueProp="targetType"/>

           <oem:formValue name="<%=BeaconConstants.MODE%>" 
                          valueProp="mode"/>

           <oem:formValue name="<%=BeaconConstants.TRANSACTION_TYPE_PAGE_PROPERTY%>" 
                          valueProp="transactionType"/>

           <oem:switcher childNameProp="mode">
            <oem:case name="<%=BeaconConstants.EDIT_MODE%>">
             <oem:formValue name="<%=BeaconConstants.TRANSACTION_NAME_PAGE_PROPERTY%>" 
                            valueProp="transactionName"/>
            </oem:case>
           </oem:switcher>

           <oem:switcher childNameProp="mode">
            <oem:case name="<%=BeaconConstants.EDIT_MODE%>">
             <oem:formValue name="<%=BeaconConstants.TRANSACTION_GUID_PAGE_PROPERTY%>" 
                            valueProp="transactionGUID"/>
            </oem:case>
           </oem:switcher>

          </oem:contents>

          <oem:tableLayout width="100%">
           <oem:contents>
            <oem:rowLayout>
             <oem:contents>
              <oem:cellFormat>
               <oem:contents>
                <oem:spacer height="10"/>
                <oem:messageBox rendered="<%=defaultBean.getError()%>"
                                messageType="<%=BeaconConstants.MESSAGE_TYPE_ERROR%>"
                                msgBundleKey="<%=BeaconConstants.BEACON_BUNDLE%>"
                                errorTableKey="<%=BeaconConstants.BCN_ERR_TABLE%>"
                                titleTextKey="<%=BeaconConstants.BCN_ERR_TITLE%>"
                                mainTextKey="<%=BeaconConstants.BCN_ERR_MSG%>"/>
                <oem:spacer height="10"/>
               </oem:contents>
              </oem:cellFormat>
             </oem:contents>
            </oem:rowLayout>
           </oem:contents>                    
          </oem:tableLayout>

          <oem:contents>
           <oem:header textProp="headerAndTitle">

            <oem:stackLayout>
             <oem:contents>
    
              <oem:spacer width="5"/>

              <oem:header textProp="generalHeader">
               <oem:contents>

                <oem:spacer height="10"/>

                <oem:labeledFieldLayout fieldWidth="100%" labelWidth="12%">

                 <oem:switcher childNameProp="<%=BeaconConstants.MODE%>">
                  <oem:case name="<%=BeaconConstants.CREATE_MODE%>">
                    <oem:messagePrompt msgBundleKey="defaultMsgBundle" 
                      labeledNodeId="transactionName"
                      textNLS="NAME"
                      required="yes"/>
                  </oem:case>
                  <oem:case name="<%=BeaconConstants.EDIT_MODE%>">
                    <oem:messagePrompt msgBundleKey="defaultMsgBundle" 
                      textNLS="NAME"
                      required="yes"/>
                 </oem:case>
                 </oem:switcher>

                 <oem:switcher childNameProp="<%=BeaconConstants.MODE%>">
                  <oem:case name="<%=BeaconConstants.CREATE_MODE%>">
                   <oem:textInput name="transactionName" 
                                  id="transactionName"
                                  columns="30"
                                  textProp="transactionName"/>
                  </oem:case>
                  <oem:case name="<%=BeaconConstants.EDIT_MODE%>">
                   <oem:styledText styleClass="OraDataText"
                                   textProp="transactionName" />
                  </oem:case>
                 </oem:switcher>

                 <oem:messagePrompt msgBundleKey="defaultMsgBundle" 
                                    textNLS="URL"
                                    labeledNodeId="url"
                                    required="yes"/>
                 <oem:textInput name="url" 
                                id="url"
                                columns="60"
                                textProp="URL"/>

                 <oem:messagePrompt msgBundleKey="defaultMsgBundle" 
                                    labeledNodeId="interval"
                                    textNLS="INTERVAL"
                                    required="yes"/>
                 <oem:textInput name="interval" 
                                id="interval"
                                styleClass="OraFieldNumber"
                                columns="3"
                                textProp="interval"/>

                </oem:labeledFieldLayout>

               </oem:contents>
              </oem:header> 

              <oem:header textProp="thresholdsHeader">
               <oem:contents>

                <oem:spacer height="10"/>

                <oem:table width="50%" 
                           name="URLThresholdsTable"
                           dataSourceProp="URLThresholdsTable" 
                           summary="<%=defaultBean.getThresholdsHeader()%>"
                           alternateText="<%=defaultBean.getNoDataText()%>">
                </oem:table>

               </oem:contents>
              </oem:header> 

             </oem:contents>
            </oem:stackLayout>

           </oem:header>
          </oem:contents>

        </oem:pageLayout>
      </oem:contents>
    </oem:form>
  </oem:contents>
</oem:body>
