<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ page import="oracle.sysman.eml.beacon.BeaconConstants" %>

<uix:buildTree nodeID="pagePlugin">

<jsp:useBean
    id="beaconMetricTables"
    scope="request"
    type="oracle.sysman.eml.beacon.data.BeaconMetricTables"/>

  <uix:stackLayout>
                <uix:borderLayout>
                   <uix:header 
                       textBinding="pingDataTable@beaconMetricTables@servletRequest">

                     <uix:rowLayout hAlign="right">
                       <uix:cellFormat hAlign="right">
                         <uix:button textBinding="addBtnStr@beaconMetricTables@servletRequest"
                             destinationBinding="addIPButtonDestination@beaconMetricTables@servletRequest"/>
                       </uix:cellFormat>
                     </uix:rowLayout>

                     <uix:spacer height="25"/>

                    <uix:form name="IPTransactionsForm" method="POST"
                              destinationBinding="IPTableFormDestination@beaconMetricTables@servletRequest">

                      <uix:formValue
                          name="<%=BeaconConstants.TARGET_PAGE_PROPERTY%>" 
                          valueBinding="targetName@beaconMetricTables@servletRequest"/>
                      <uix:formValue
                          name="<%=BeaconConstants.TARGET_TYPE_PAGE_PROPERTY%>" 
                          valueBinding="targetType@beaconMetricTables@servletRequest"/>

                     <oem:table width="100%" name="BeaconPingTable" beanKey="beaconMetricTables"
                         dataSourceProp="tgtBcnPingTbl" 
                         alternateText="<%=beaconMetricTables.getNoTransactionsText()%>">
                     <uix:tableSelection>
                      <uix:singleSelection selectedIndex="0">
                        <uix:submitButton 
                            textBinding="deleteBtnStr@beaconMetricTables@servletRequest" 
                            name="event"
                            value="<%=BeaconConstants.DELETE_CONFIRMATION%>"/>
                        <uix:submitButton 
                            textBinding="editBtnStr@beaconMetricTables@servletRequest" 
                            name="event"
                            value="<%=BeaconConstants.EDIT_IP%>"/>
                        <%--<uix:submitButton 
                            textBinding="collectBtnStr@beaconMetricTables@servletRequest" 
                            name="<%=BeaconConstants.EVENT%>"
                            value="<%=BeaconConstants.BCN_INTER_PING_EVENT%>"/>
                        <uix:submitButton 
                            textBinding="collectTrcBtnStr@beaconMetricTables@servletRequest" 
                            name="<%=BeaconConstants.EVENT%>"
                            value="<%=BeaconConstants.BCN_INTER_TRACEROUTE_EVENT%>"/>--%>
                      </uix:singleSelection>
                     </uix:tableSelection>
                    </oem:table>
                  </uix:form>
                   </uix:header>
                  <uix:spacer height="20"/>

                 <uix:bottom>

                   <uix:header 
                       textBinding="httpResponseDataTable@beaconMetricTables@servletRequest">

                    <uix:rowLayout hAlign="right">
                      <uix:cellFormat hAlign="right">
                        <uix:button  
                            textBinding="addBtnStr@beaconMetricTables@servletRequest"
                            destinationBinding="addURLButtonDestination@beaconMetricTables@servletRequest"/>
                      </uix:cellFormat>
                    </uix:rowLayout>

                    <uix:spacer height="25"/> 

                    <uix:form name="URLTransactionsForm" method="post"
                              destinationBinding="URLTableFormDestination@beaconMetricTables@servletRequest">

                      <uix:formValue
                          name="<%=BeaconConstants.TARGET_PAGE_PROPERTY%>" 
                          valueBinding="targetName@beaconMetricTables@servletRequest"/>
                      <uix:formValue
                          name="<%=BeaconConstants.TARGET_TYPE_PAGE_PROPERTY%>" 
                          valueBinding="targetType@beaconMetricTables@servletRequest"/>

                    <oem:table width="100%" name="BeaconHTTPTable" beanKey="beaconMetricTables"
                        dataSourceProp="tgtBcnHTTPRspTbl" 
                        alternateText="<%=beaconMetricTables.getNoTransactionsText()%>">
                     <uix:tableSelection>
                      <uix:singleSelection selectedIndex="0">
                        <uix:submitButton 
                            textBinding="deleteBtnStr@beaconMetricTables@servletRequest" 
                            name="event"
                            value="<%=BeaconConstants.DELETE_CONFIRMATION%>"/>
                        <uix:submitButton 
                            textBinding="editBtnStr@beaconMetricTables@servletRequest"
                            name="event"
                            value="<%=BeaconConstants.EDIT_URL%>"/>
                        <%--<uix:submitButton 
                            textBinding="collectBtnStr@beaconMetricTables@servletRequest"
                            name="<%=BeaconConstants.EVENT%>"
                            value="<%=BeaconConstants.BCN_INTER_PING_HTTP_EVENT%>"/>--%>
                      </uix:singleSelection>
                     </uix:tableSelection>
                    </oem:table>
                  </uix:form>
                   </uix:header>
                  </uix:bottom>
                </uix:borderLayout>
  </uix:stackLayout>

</uix:buildTree>

<%@include  file="/sdk/pageTemplate.jspf" %>
