<%--

/* $Header: beaconInteractive.jsp 14-jun-2005.11:29:05 andyao Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao        06/14/05 - fix OAC issues 
    andyao        01/07/05 - remove html comment 
    dbrown        05/28/03 - Set charset to utf-8.
    rmarripa      03/13/03 - add broken content section
    rmarripa      02/20/03 - cleanup resources
    jriel         11/21/02 - fix help button
    asawant       07/25/02 - Adding headers to http tables
    njuillar      07/11/02 - Move chart legend to the South
    asawant       06/25/02 - Changing chart components order
    njuillar      06/10/02 - Cutting over to POST.
    lyang         06/11/02 - Use EMURLEncoder
    asawant       05/16/02 - Cutting over to content metric (for http ping).
    asawant       05/15/02 - Adding redirect time to split bar chart.
    asawant       05/13/02 - cut over to UIX JSP and split bar chart added
    asawant       05/13/02 - history section added
 */

/**
 *  @version $Header: beaconInteractive.jsp 14-jun-2005.11:29:05 andyao Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.beacon.BeaconConstants"%>
<%@ page import="oracle.sysman.resources.beacon.BeaconResourceBundleID"%>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.beacon.data.BeaconInteractive"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
      <uix:form name="InteractiveForm" method="POST"
          destinationBinding="formDestination@defaultBean@servletRequest">

      <uix:pageLayout>
      
      <%@ include file="/oemGlobal.jspf" %>

      <uix:header textBinding="header@defaultBean@servletRequest">
        <uix:formValue name="<%=BeaconConstants.BCN_OBJID%>" 
            valueBinding="objectID@defaultBean@servletRequest"/>
        <uix:formValue name="<%=BeaconConstants.MODE%>" 
            valueBinding="mode@defaultBean@servletRequest"/>
        <uix:formValue name="<%=BeaconConstants.TARGET_PAGE_PROPERTY%>" 
            valueBinding="targetName@defaultBean@servletRequest"/>
        <uix:formValue name="<%=BeaconConstants.TARGET_TYPE_PAGE_PROPERTY%>" 
            valueBinding="targetType@defaultBean@servletRequest"/>
        <uix:formValue
            name="<%=BeaconConstants.TRANSACTION_TYPE_PAGE_PROPERTY%>" 
            valueBinding="transactionType@defaultBean@servletRequest"/>
        <uix:switcher childNameBinding="mode@defaultBean@servletRequest">
          <uix:case name="<%=BeaconConstants.EDIT_MODE%>">
            <uix:formValue
               name="<%=BeaconConstants.TRANSACTION_GUID_PAGE_PROPERTY%>" 
               valueBinding="transactionGUID@defaultBean@servletRequest"/>
          </uix:case>
        </uix:switcher>

        <oem:messageBox messageType="error"
            errorTableBinding="errTable@servletRequest"
            msgBundleBinding="defaultMsgBundle@servletRequest"
            titleTextKey="errTitle"
            mainTextKey="errMsg"/>

        <uix:switcher
            childNameBinding="tblVisible@defaultBean@servletRequest">
          <uix:case name="yes">
            <uix:stackLayout>
              <uix:header
                  textBinding="resultHeader@defaultBean@servletRequest">
                <uix:switcher
                    childNameBinding="event@defaultBean@servletRequest">
                  <uix:case name="<%=BeaconConstants.BCN_PING_HTTP_EVENT%>">
                    <oem:chart
                        chartType="barChart" orientation="horizontal"
                        width="800"
                        height="100" seriesColorsAutomatic="true"
                        stacked="true"
                        legendPosition="south">
                      <uix:contents>
                        <oem:boundChartDataSource
                            dataMethod="getInteractiveHttpPingBarChartData"
                            dataClass="oracle.sysman.eml.beacon.controller.BeaconController"/>
                        <oem:chartColumn sourceIndex="0" isKey="true"/>
                        <oem:chartColumn sourceIndex="1"
                            displayLabel="<%=defaultBean.getString(
                                BeaconResourceBundleID.CONNECTTIME)%>"/>
                        <oem:chartColumn sourceIndex="2"
                            displayLabel="<%=defaultBean.getString(
                                BeaconResourceBundleID.REDIRECT_TIME)%>"/>
                        <oem:chartColumn sourceIndex="3"
                            displayLabel="<%=defaultBean.getString(
                                BeaconResourceBundleID.FIRST_BYTE_TIME)%>"/>
                        <oem:chartColumn sourceIndex="4"
                            displayLabel="<%=defaultBean.getString(
                                BeaconResourceBundleID.BASE_PAGE_TIME)%>"/>
                        <oem:chartColumn sourceIndex="5"
                            displayLabel="<%=defaultBean.getString(
                                BeaconResourceBundleID.IMAGE_TIME)%>"/>
                      </uix:contents>
                    </oem:chart>
                  </uix:case>
                </uix:switcher>
                <uix:spacer height="10"/>
                <uix:switcher
                    childNameBinding="pingType@defaultBean@servletRequest">
                  <uix:case name="<%=BeaconConstants.BCN_PING_HTTP_EVENT%>">
                    <uix:stackLayout>
                      <uix:header
                          text="<%=defaultBean.getString(
                            BeaconResourceBundleID.HTTP_METRIC_TBL_HEADER)%>">
                            <oem:table width="100%" name="ResultTable"
                              summary="<%=defaultBean.getString(BeaconResourceBundleID.HTTP_METRIC_TBL_HEADER)%>"
                              dataSourceProp="resultTbl" alternateText="<%=defaultBean.getNoDataText()%>">
                        </oem:table>
                      </uix:header>
                      <uix:spacer height="10"/>
                      <uix:header
                          text="<%=defaultBean.getString(
                            BeaconResourceBundleID.HTTP_CONTENT_TBL_HEADER)%>">
                        <oem:table width="100%" name="ContentTable"
                          summary="<%=defaultBean.getString(BeaconResourceBundleID.HTTP_CONTENT_TBL_HEADER)%>"
                             dataSourceProp="contentTbl" alternateText="<%=defaultBean.getNoDataText()%>">
                        </oem:table>
                      </uix:header>
                      <uix:switcher childNameBinding="showBrokenContent@defaultBean@servletRequest" defaultCase="<%=BeaconConstants.FALSE%>">
                       <uix:case name="<%=BeaconConstants.TRUE%>">
                        <uix:stackLayout>
                         <uix:spacer height="10"/>
                         <uix:header text="<%=defaultBean.getString(
                             BeaconResourceBundleID.BROKEN_ELEMS_HDR)%>">
                          <oem:table width="70%" name="ContentTable" summary="<%=defaultBean.getString(BeaconResourceBundleID.BROKEN_ELEMS_HDR)%>"
                             dataSourceProp="brokenContentTbl" alternateText="<%=defaultBean.getNoDataText()%>">
                          </oem:table>
                         </uix:header>
                        </uix:stackLayout>
                       </uix:case>
                      </uix:switcher>
                    </uix:stackLayout>
                  </uix:case>
                  <uix:case name="<%=BeaconConstants.BCN_PING_EVENT%>">
                    <oem:table width="100%" name="ResultTable"
                      summary="<%=defaultBean.getResultHeader()%>"
                        dataSourceProp="resultTbl" alternateText="<%=defaultBean.getNoDataText()%>">
                    </oem:table>
                  </uix:case>
                </uix:switcher>
              </uix:header>
              <uix:spacer height="10"/>
              <uix:header
                  textBinding="propertiesHeader@defaultBean@servletRequest">
                <oem:table width="100%" name="Properties"
                              summary="<%=defaultBean.getPropertiesHeader()%>"
                    dataSourceProp="propsTbl" alternateText="<%=defaultBean.getNoPropertiesText()%>">
                </oem:table>
              </uix:header>
            </uix:stackLayout>
          </uix:case>
        </uix:switcher>

      </uix:header>

      <uix:contentFooter>
       <uix:flowLayout>
         <uix:submitButton name="event"
             valueBinding="okEvent@defaultBean@servletRequest" 
             textBinding="okButtonLabel@defaultBean@servletRequest"/>
       </uix:flowLayout>
      </uix:contentFooter>

     </uix:pageLayout>
    </uix:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>

