<%--

/* $Header: beaconPerfPage.jsp 27-feb-2006.15:50:23 hmodawel Exp $ */
/* Copyright (c) 2001, 2006, Oracle. All rights reserved.  */

/*
   DESCRIPTION
     Part of Beacon Performance Home Page Tab

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    hmodawel      02/27/06 - fix ojsp 1013 compilation errors 
    andyao        06/14/05 - add description 
    mfidanbo      01/26/05 - error message handling 
    rmarripa      07/24/03 - change choice tag
    dbrown        06/05/03 - Set charset to utf-8.
    asawant       03/26/03 - History added.
 */

/**
 *  @version $Header: beaconPerfPage.jsp 27-feb-2006.15:50:23 hmodawel Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %> 
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %> 
<%@ page import="oracle.sysman.eml.beacon.BeaconConstants"%>

<uix:buildTree nodeID="pagePlugin">

  <uix:stackLayout>
    <oem:messageBox 
                messageType="<%=BeaconConstants.MESSAGE_TYPE_ERROR%>"
                errorTableBinding="errors@servletRequest"
                titleTextKey="<%=BeaconConstants.BCN_ERR_TITLE%>"
                mainTextKey="<%=BeaconConstants.BCN_ERR_MSG%>"/>
    <%@include file="/monitoring/beacon/beaconPerfMetricTables.jspf"%>
  </uix:stackLayout>
         <uix:spacer height="20"/>

        <uix:header textBinding="INTERACTIVE_TITLE@BeaconMsgBundle@@servletRequest">
         <uix:contents>
          <uix:spacer height="20"/>
          <uix:form name="interTxnForm" method="POST"
                           destinationBinding="beaconHmPgName@defaultBean@servletRequest">
           <uix:formValue name="<%=BeaconConstants.TARGET_PAGE_PROPERTY%>"
                            valueBinding="targetName@defaultBean@servletRequest"/>
           <uix:formValue name="<%=BeaconConstants.TARGET_TYPE_PAGE_PROPERTY%>"
                            valueBinding="targetType@defaultBean@servletRequest"/>

           <uix:messageTextInput 
             promptBinding="hostURLLabel@defaultBean@servletRequest" 
             name="<%=BeaconConstants.USER_IPURL_VALUE%>">
             <uix:end>
               <uix:flowLayout>
                 <uix:choice name="<%=BeaconConstants.INTERACTIVE_CHOICE_VALUES%>" shortDescBinding="TYPE@BeaconMsgBundle@servletRequest">
                   <uix:contents childDataBinding="interactiveChoices@defaultBean@servletRequest">
                     <uix:option textBinding="text"
                       valueBinding="value"
                       renderedBinding="rendered"/>
                   </uix:contents>
                 </uix:choice>
                 <uix:submitButton textBinding="GO@BeaconMsgBundle@servletRequest" name="<%=BeaconConstants.EVENT%>" value="<%=BeaconConstants.INTERACTIVE_EVENT%>"/>
               </uix:flowLayout>
             </uix:end>
           </uix:messageTextInput>
           <uix:spacer width="10"/>
       </uix:form>
       <uix:spacer height="20"/>
     </uix:contents>
   </uix:header>

 </uix:buildTree>

 <%@include file="/sdk/pageTemplate.jspf" %>

