<%--

/* $Header: beaconPingHttp.jsp 23-sep-2005.08:22:40 andyao Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao        09/23/05 - fix auto complete bug
    andyao        06/14/05 - fix OAC issues 
    dbrown        05/28/03 - Set charset to utf-8.
    rmarripa      03/15/03 - add broken content section
    rmarripa      02/20/03 - cleanup resources
    jriel         11/20/02 - hide password
    jriel         11/21/02 - fix help button
    asawant       07/25/02 - Adding headers for the tables
    njuillar      07/11/02 - Move chart legend to the South
    asawant       06/25/02 - Changing split chart order
    njuillar      06/10/02 - Cutting over to POST.
    lyang         06/11/02 - Use EMURLEncoder
    asawant       05/22/02 - Error msg box not showing up (BUG)
    asawant       05/15/02 - Adding redirect time to split bar chart.
    asawant       05/10/02 - cut over to UIX JSP
    asawant       05/07/02 - history section added
 */

/**
 *  @version $Header: beaconPingHttp.jsp 23-sep-2005.08:22:40 andyao Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import='oracle.sysman.eml.beacon.BeaconConstants'%>
<%@ page import='oracle.sysman.resources.beacon.BeaconResourceBundleID'%>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.beacon.data.BeaconPingHttp"/>

<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>

    <%@ include file="/oemTitle.jspf" %>
    
    <uix:body>
    <uix:form name="pingForm" destination="<%=defaultBean.getDestination()%>"
        method="POST">

        <uix:pageLayout>
      
          <%@ include file="/oemGlobal.jspf" %>

            <uix:header text="<%=defaultBean.getPingHttpHdr()%>">
    
              <uix:stackLayout>
                <uix:contents>

                  <oem:messageBox messageType="error"
                      errorTableBinding="errTable@servletRequest"
                      msgBundleBinding="defaultMsgBundle@servletRequest"
                      titleTextKey="errTitle"
                      mainTextKey="errMsg"/>

                  <uix:stackLayout>
                    <uix:contents>

                      <uix:header text="<%=defaultBean.getGeneralMsg()%>">

                        <uix:spacer height="10"/>

                        <uix:rowLayout>

                          <uix:spacer width="40"/>

                          <uix:labeledFieldLayout>
                            <uix:contents>
                              <uix:messageTextInput name="url"
                                  text="<%=defaultBean.getUrl()%>"
                                  prompt="<%=defaultBean.getUrlMsg()%>"
                                  required="yes"/>
                            </uix:contents>
                          </uix:labeledFieldLayout>

                          <uix:spacer width="20"/>

                          <uix:submitButton
                              text="<%=defaultBean.getPingBtnStr()%>"/>
                        </uix:rowLayout>

                      </uix:header>
                    </uix:contents>
                  </uix:stackLayout>

                  <uix:switcher childName="<%=defaultBean.getTblVisible()%>">
                    <uix:case name="yes">
                      <uix:header text="<%=defaultBean.getResultsStr()%>">
                        <uix:stackLayout>
                          <uix:spacer height="10"/>
                          <oem:chart
                              chartType="barChart" orientation="horizontal"
                              width="800"
                              height="100" seriesColorsAutomatic="true"
                              stacked="true"
                              legendPosition="south">
                            <uix:contents>
                              <oem:boundChartDataSource
                                  dataMethod="getPingHttpBarChartData"
                                  dataClass="oracle.sysman.eml.beacon.controller.BeaconController"/>
                              <oem:chartColumn sourceIndex="0" isKey="true"/>
                              <oem:chartColumn sourceIndex="1"
                                  displayLabel="<%=defaultBean.getString(
                                    BeaconResourceBundleID.CONNECTTIME)%>"/>
                              <oem:chartColumn sourceIndex="2"
                                  displayLabel="<%=defaultBean.getString(
                                    BeaconResourceBundleID.REDIRECT_TIME)%>"/>
                              <oem:chartColumn sourceIndex="3"
                                  displayLabel="<%=defaultBean.getString(
                                    BeaconResourceBundleID.FIRST_BYTE_TIME)%>"/>
                              <oem:chartColumn sourceIndex="4"
                                  displayLabel="<%=defaultBean.getString(
                                    BeaconResourceBundleID.BASE_PAGE_TIME)%>"/>
                              <oem:chartColumn sourceIndex="5"
                                  displayLabel="<%=defaultBean.getString(
                                    BeaconResourceBundleID.IMAGE_TIME)%>"/>
                            </uix:contents>
                          </oem:chart>
                          <uix:spacer height="10"/>
                          <uix:header
                              text="<%=defaultBean.getString(
                                BeaconResourceBundleID.HTTP_METRIC_TBL_HEADER)%>">
                                <oem:table width="100%" name="ResultTable"
                                  dataSourceProp="resultTbl"
                                  summary="<%=defaultBean.getString(BeaconResourceBundleID.HTTP_METRIC_TBL_HEADER)%>"
                                  alternateText="<%=defaultBean.getNoDataText()%>">
                            </oem:table>
                          </uix:header>
                          <uix:spacer height="10"/>
                          <uix:header
                              text="<%=defaultBean.getString(
                                BeaconResourceBundleID.HTTP_CONTENT_TBL_HEADER)%>">
                            <oem:table width="100%" name="ContentTable"
                                dataSourceProp="contentTbl"
                                summary="<%=defaultBean.getString(BeaconResourceBundleID.HTTP_CONTENT_TBL_HEADER)%>"
                                alternateText="<%=defaultBean.getNoDataText()%>">
                            </oem:table>
                          </uix:header>
                          <uix:switcher childNameBinding="showBrokenContent@defaultBean@servletRequest" defaultCase="<%=BeaconConstants.FALSE%>">
                           <uix:case name="<%=BeaconConstants.TRUE%>">
                            <uix:stackLayout>
                             <uix:spacer height="10"/>
                             <uix:header text="<%=defaultBean.getString(
                                 BeaconResourceBundleID.BROKEN_ELEMS_HDR)%>">
                              <oem:table width="70%" name="ContentTable"
                                summary="<%=defaultBean.getString(BeaconResourceBundleID.BROKEN_ELEMS_HDR)%>"
                                 dataSourceProp="brokenContentTbl" 
                                 alternateText="<%=defaultBean.getNoDataText()%>">
                              </oem:table>
                             </uix:header>
                            </uix:stackLayout>
                           </uix:case>
                          </uix:switcher>

                        </uix:stackLayout>
                      </uix:header>
                    </uix:case>
                  </uix:switcher>

                  <uix:header text="<%=defaultBean.getAuthConfigMsg()%>">

                    <uix:spacer height="10"/>

                    <uix:rowLayout>

                      <uix:spacer width="40"/>

                      <uix:labeledFieldLayout>
                       <uix:contents>
                         <uix:messageTextInput name="authrealm" columns="15"
                             noAutoComplete="true"
                             prompt="<%=defaultBean.getAuthRealmStr()%>"
                             text="<%=defaultBean.getAuthRealm()%>"/>
                         <uix:messageTextInput name="authuser" columns="15"
                             noAutoComplete="true"
                             prompt="<%=defaultBean.getAuthUserStr()%>"
                             text="<%=defaultBean.getAuthUser()%>"/>
                         <uix:messageTextInput name="authpwd" secret="true"
                             noAutoComplete="true"
                             prompt="<%=defaultBean.getAuthPwdStr()%>"
                             columns="15" text="<%=defaultBean.getAuthPwdSecret()%>"/>
                       </uix:contents>
                      </uix:labeledFieldLayout>
                    </uix:rowLayout>
                  </uix:header>

                </uix:contents>
              </uix:stackLayout>

            </uix:header>
        <uix:formValue name="<%=BeaconConstants.TARGET_PAGE_PROPERTY%>"
            value="<%=defaultBean.getTargetName()%>"/>
        <uix:formValue name="<%=BeaconConstants.TARGET_TYPE_PAGE_PROPERTY%>"
            value="<%=defaultBean.getTargetType()%>"/>
    
    </uix:pageLayout>
    </uix:form>
  </uix:body>
 </uix:document>
</uix:renderingContext>
