<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>

<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.mntr.metrics.MetricDiffCountsData"/>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

   <%@ include file="/enablePPR.jspf" %>
   <%@ include file="/oemTitle.jspf" %>              

    <uix:body>
     <oem:form name="metricDiffCountsForm" method="POST" destination="/console/monitoring/copyMetricThresholdsDiffCounts" copyParams="target,type">
      <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
       <%@ include file="/oemGlobal.jspf" %>

        <uix:contentFooter>
         <uix:pageButtonBar>
          <uix:dataScope>
           <uix:submitButton textBinding="CANCEL@commonResourceBundle@servletRequest" 
                             name="event" 
                             value="<%=Constants.CANCEL_EVENT%>"/>
           <uix:spacer width="3"/>                  
           <uix:submitButton textBinding="BACK@commonResourceBundle@servletRequest" 
                       name="event" 
                       value="<%=Constants.PREV_EVENT%>"/>
           <uix:spacer width="3"/>                  
           <uix:submitButton textBinding="SUBMIT_BUTTON@mntrResourceBundle@servletRequest" 
                             name="event" 
                             value="<%=Constants.SUBMIT_EVENT%>"/>
          </uix:dataScope>                   
         </uix:pageButtonBar>
        </uix:contentFooter>

        <uix:formValue name="<%=MetricThresholdConstants.COPY_MODE_KEY%>" valueBinding="copyMode@defaultBean@servletRequest"/>

        <uix:switcher childNameBinding="copyMode@defaultBean@servletRequest">
         <uix:case name="<%=MetricThresholdConstants.COPY_FROM_MODE%>">
          <uix:formValue name="<%=MetricThresholdConstants.COPY_OPTION%>" valueBinding="copyOption@defaultBean@servletRequest"/>
         </uix:case>
        </uix:switcher> 
         
        <uix:spacer height="5"/>
        
         <uix:contents>

          <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
           <uix:case name="<%=Constants.OK_NODE_VALUE%>">    
           
            <uix:stackLayout>
             <uix:contents>

              <uix:borderLayout>  
               <uix:innerTop>
                <uix:styledText textBinding="summaryText@defaultBean@servletRequest"
                                styleClass="OraInstructionText"/>
               </uix:innerTop>
               <uix:right>
                <uix:rowLayout>
                 <uix:submitButton textBinding="CANCEL@commonResourceBundle@servletRequest" 
                                   name="event" 
                                   value="<%=Constants.CANCEL_EVENT%>"/>
                 <uix:spacer width="3"/>                  
                 <uix:submitButton textBinding="BACK@commonResourceBundle@servletRequest" 
                                   name="event" 
                                   value="<%=Constants.PREV_EVENT%>"/>
                 <uix:spacer width="3"/>                  
                 <uix:submitButton textBinding="SUBMIT_BUTTON@mntrResourceBundle@servletRequest" 
                                   name="event" 
                                   value="<%=Constants.SUBMIT_EVENT%>"/>
                </uix:rowLayout>
               </uix:right>
              </uix:borderLayout>
       
            

            <uix:spacer height="10"/>

              <uix:table
                   name="metricDiffCountsTable"
                   id="metricDiffCountsTable" 
                   partialRenderMode="self"
                   alternateTextBinding="NO_DATA_STR@mntrResourceBundle@servletRequest"
                   width="80%"
                   formSubmitted="true"
                   blockSize="10"
                   valueBinding="value@defaultBean@servletRequest"
                   minValueBinding="minValue@defaultBean@servletRequest"
                   maxValueBinding="maxValue@defaultBean@servletRequest"                   
                   tableDataBinding="tableDataKey@tableData@defaultBean@servletRequest"
                   columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                   columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest">

               <uix:tableFormat tableBanding="rowBanding"/>

               <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text"
                                    sortableBinding="sortable"/>
               </uix:columnHeaderStamp>

               <uix:contents>
                <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"/> 
                <uix:styledText textBinding="copyOption"/>
                <uix:styledText textBinding="additions"/>
                <uix:styledText textBinding="deletions"/>
                <uix:image sourceBinding="viewDetailsIconSource@defaultBean@servletRequest"
                           destinationBinding="viewDetailsIconDestination"/> 
               </uix:contents>

              </uix:table>

           </uix:contents>
          </uix:stackLayout>

         </uix:case>
         <uix:case name="<%=Constants.ERR_NODE_VALUE%>">
          <uix:messageBox messageBinding="errorMessage@defaultBean@servletRequest"
                          messageType="error"
                          shortDescBinding="ERR_OCCUR@mntrResourceBundle@servletRequest"
                          textBinding="ERR_OCCUR@mntrResourceBundle@servletRequest">
          </uix:messageBox>
         </uix:case>
        </uix:switcher>
         </uix:contents>

       </uix:pageLayout>
      </oem:form>
    </uix:body>

   </uix:document>
</uix:renderingContext>
