<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>


<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.mntr.metrics.MetricDiffDetailsData"/>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

   <%@ include file="/oemTitle.jspf" %>              

    <uix:body>
     <uix:form name="metricDiffDetailsForm" method="POST" destination="/console/monitoring/copyMetricThresholdsDiffDetails">
      <uix:pageLayout titleBinding="header@defaultBean@servletRequest">
       <%@ include file="/oemGlobal.jspf" %>

        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:switcher childNameBinding="isSingleTargetCopy@defaultBean@servletRequest">
           <uix:case name="false">
            <uix:button textBinding="OK@commonResourceBundle@servletRequest" 
                        destinationBinding="OKButtonDestination@defaultBean@servletRequest"/>
           </uix:case>
           <uix:case name ="true">
           <uix:dataScope>
            <uix:submitButton textBinding="CANCEL@commonResourceBundle@servletRequest" 
                              name="event" 
                              value="<%=Constants.CANCEL_EVENT%>"/>
            <uix:spacer width="3"/>                  
            <uix:button textBinding="BACK@commonResourceBundle@servletRequest" 
                        destinationBinding="backButtonDestination@defaultBean@servletRequest"/>
            <uix:spacer width="3"/>                  
            <uix:submitButton textBinding="SUBMIT_BUTTON@mntrResourceBundle@servletRequest" 
                              name="event" 
                              value="<%=Constants.SUBMIT_EVENT%>"/>  
            </uix:dataScope>                  
           </uix:case>
          </uix:switcher> 
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:formValue name="<%=Constants.TARGET_PAGE_PROPERTY%>" valueBinding="currentTargetName@defaultBean@servletRequest"/>
        <uix:formValue name="<%=Constants.TARGET_TYPE_PAGE_PROPERTY%>" valueBinding="currentTargetType@defaultBean@servletRequest"/>
        <uix:formValue name="<%=MetricThresholdConstants.COPY_MODE_KEY%>" valueBinding="copyMode@defaultBean@servletRequest"/>
        <uix:formValue name="<%=MetricThresholdConstants.SINGLE_TARGET_COPY%>" valueBinding="isSingleTargetCopy@defaultBean@servletRequest"/>


        <uix:switcher childNameBinding="copyMode@defaultBean@servletRequest">
         <uix:case name="<%=MetricThresholdConstants.COPY_FROM_MODE%>">
          <uix:formValue name="<%=MetricThresholdConstants.COPY_OPTION%>" valueBinding="copyOption@defaultBean@servletRequest"/>
         </uix:case>
        </uix:switcher>
          
        <uix:spacer height="5"/>
        
         <uix:contents>

          <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
           <uix:case name="<%=Constants.OK_NODE_VALUE%>">

          <uix:stackLayout>
           <uix:contents>

            <uix:labeledFieldLayout fieldWidth="85%" labelWidth="15%"> 
             <uix:contents>                        
              <uix:styledText textBinding="SOURCE_TARGET@mntrResourceBundle@servletRequest"/>
              <uix:styledText textBinding="sourceTargetName@defaultBean@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
              <uix:styledText textBinding="DESTINATION_TARGET@mntrResourceBundle@servletRequest"/>                                      
              <uix:styledText textBinding="destinationTargetName@defaultBean@servletRequest"
                              styleClass="OraInstructionTextStrong"/>
             </uix:contents>
            </uix:labeledFieldLayout>                                      
       
            <uix:spacer height="10"/>
          
            <uix:header textBinding="additionsTableHeader@defaultBean@servletRequest"
                        renderedBinding="showAdditionDeletionData@defaultBean@servletRequest">
             <uix:contents>
              <uix:stackLayout>
               <uix:contents> 

                <uix:styledText textBinding="additionsTableText@defaultBean@servletRequest"
                                styleClass="OraInstructionText"/>

                <uix:rowLayout>
                 <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:table id="additionsDetailsTable" 
                           alternateTextBinding="NO_DATA_STR@mntrResourceBundle@servletRequest"
                           summaryBinding="additionsTableHeader@defaultBean@servletRequest"
                           width="50%"
                           tableDataBinding="tableDataKey@additionsDetailsTableData@defaultBean@servletRequest"
                           columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest">

                 <uix:tableFormat tableBanding="rowBanding"/>

                 <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text"/>
                 </uix:columnHeaderStamp>

                 <uix:contents>
                  <uix:styledText textBinding="metricLabel" shortDescBinding="METRIC@mntrResourceBundle@servletRequest" /> 
                 </uix:contents>
                </uix:table>

               </uix:contents>
              </uix:stackLayout>
             </uix:contents> 
            </uix:header>

            <uix:spacer height="10"/>

            <uix:header textBinding="deletionsTableHeader@defaultBean@servletRequest"
                        renderedBinding="showAdditionDeletionData@defaultBean@servletRequest">
             <uix:contents>
              <uix:stackLayout>
               <uix:contents>

                <uix:styledText textBinding="deletionsTableText@defaultBean@servletRequest"
                                styleClass="OraInstructionText"/>

                <uix:rowLayout>
                 <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:table id="deletionsDetailsTable" 
                           alternateTextBinding="NO_DATA_STR@mntrResourceBundle@servletRequest"
                           summaryBinding="deletionsTableHeader@defaultBean@servletRequest"
                           width="50%"
                           tableDataBinding="tableDataKey@deletionsDetailsTableData@defaultBean@servletRequest"
                           columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest">

                 <uix:tableFormat tableBanding="rowBanding"/>

                 <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text"/>
                 </uix:columnHeaderStamp>

                 <uix:contents>
                  <uix:styledText textBinding="metricLabel" shortDescBinding="METRIC@mntrResourceBundle@servletRequest" /> 
                 </uix:contents>

                </uix:table>

               </uix:contents>
              </uix:stackLayout>
             </uix:contents>
            </uix:header>

            <uix:spacer height="10"/>

<%--
            </uix:case>
            </uix:switcher>
--%>

            <uix:header textBinding="commonTableHeader@defaultBean@servletRequest">
             <uix:contents>
              <uix:stackLayout>
               <uix:contents>
                <uix:styledText textBinding="commonTableText@defaultBean@servletRequest"
                                styleClass="OraInstructionText"/>

                <uix:rowLayout>
                 <uix:spacer height="20"/>
                </uix:rowLayout>

                <uix:table id="commonDetailsTable" 
                           alternateTextBinding="NO_DATA_STR@mntrResourceBundle@servletRequest"
                           summaryBinding="commonTableHeader@defaultBean@servletRequest"
                           width="50%"
                           tableDataBinding="tableDataKey@commonDetailsTableData@defaultBean@servletRequest"
                           columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                           columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest">

                 <uix:tableFormat tableBanding="rowBanding"/>

                 <uix:columnHeaderStamp>
                  <uix:sortableHeader textBinding="text"/>
                 </uix:columnHeaderStamp>

                 <uix:contents>
                  <uix:styledText textBinding="metricLabel" shortDescBinding="METRIC@mntrResourceBundle@servletRequest" /> 
                 </uix:contents>

                </uix:table>

               </uix:contents>
              </uix:stackLayout>
             </uix:contents>
            </uix:header>

           </uix:contents>
          </uix:stackLayout>

            </uix:case>
            <uix:case name="<%=Constants.ERR_NODE_VALUE%>">
             <uix:messageBox messageBinding="errorMessage@defaultBean@servletRequest"
                             messageType="error"
                             shortDescBinding="ERR_OCCUR@mntrResourceBundle@servletRequest"
                             textBinding="ERR_OCCUR@mntrResourceBundle@servletRequest">
             </uix:messageBox>
            </uix:case>
           </uix:switcher>

        </uix:contents>
       </uix:pageLayout>

      </uix:form>
    </uix:body>

   </uix:document>
</uix:renderingContext>
