<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.mntr.metrics.MetricThresholdsPastChangesData"/>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

   <%@ include file="/enablePPR.jspf" %>
   <%@ include file="/oemTitle.jspf" %>              

    
     <oem:form name="metricThresholdsPastChangesForm" method="POST" destination="/console/monitoring/metricThresholdsPastChanges" copyParams="target,type">
               
      <uix:body>    
      <uix:pageLayout>
       <%@ include file="/oemGlobal.jspf" %>

        <uix:contentFooter>
         <uix:pageButtonBar>                    
          <uix:contents>
           <uix:tableLayout>
            <uix:contents>
             <uix:rowLayout>
              <uix:contents>
               <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
                <uix:case name="<%=Constants.OK_NODE_VALUE%>">
                 <uix:cellFormat wrappingDisabled="true">
                  <uix:submitButton textBinding="REFRESH@commonResourceBundle@servletRequest" 
                                    name="event"
                                    value="<%=Constants.REFRESH_EVENT%>"/> 
                  <uix:spacer width="3"/> 
                 </uix:cellFormat>
                </uix:case>
               </uix:switcher>
               <uix:cellFormat wrappingDisabled="true">
                <uix:submitButton textBinding="OK@commonResourceBundle@servletRequest" 
                                  name="event"
                                  value="<%=Constants.PREV_EVENT%>"/>                
               </uix:cellFormat>             
              </uix:contents>
             </uix:rowLayout>
            </uix:contents>
           </uix:tableLayout>
          </uix:contents>
         </uix:pageButtonBar>
        </uix:contentFooter>

        <uix:spacer height="5"/>
        
         <uix:contents>
          
         <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
          <uix:case name="<%=Constants.OK_NODE_VALUE%>">

          <uix:header textBinding="METRIC_THRESHOLDS_PAST_CHANGES_HEADER@mntrResourceBundle@servletRequest">

          <uix:stackLayout>
           <uix:contents>

           <uix:tableLayout hAlign="right">
            <uix:contents>
             <uix:rowLayout>
              <uix:contents>
               <uix:cellFormat wrappingDisabled="true">
                <uix:styledText styleClass="OraTipText"
                                textBinding="PAGE_REFRESHED@mntrResourceBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="7"/> 
               <uix:cellFormat wrappingDisabled="true">
                <uix:styledText styleClass="OraTipLabel"
                                textBinding="timestamp@defaultBean@servletRequest"/>
               </uix:cellFormat>               
               <uix:spacer width="5"/> 
               <uix:cellFormat wrappingDisabled="true">
                <uix:submitButton textBinding="REFRESH@commonResourceBundle@servletRequest" 
                                  name="event"
                                  value="<%=Constants.REFRESH_EVENT%>"/> 
               </uix:cellFormat>                    
               <uix:spacer width="3"/> 
               <uix:cellFormat wrappingDisabled="true">
                <uix:submitButton textBinding="OK@commonResourceBundle@servletRequest" 
                                  name="event"
                                  value="<%=Constants.PREV_EVENT%>"/>
               </uix:cellFormat>             
              </uix:contents>
             </uix:rowLayout>
            </uix:contents>
           </uix:tableLayout>
           
             <uix:styledText textBinding="pastChangesTableText@defaultBean@servletRequest"
                             styleClass="OraInstructionText"/>

             <uix:rowLayout>
              <uix:spacer height="20"/>
             </uix:rowLayout>

               <uix:table name="pastChangesTable"
                          id="pastChangesTable"
                          partialRenderMode="self"
                          alternateTextBinding="NO_DATA_STR@mntrResourceBundle@servletRequest"
                          width="100%"
                          formSubmitted="true"
                          blockSize="10"
                          valueBinding="pastChangesTableValue@defaultBean@servletRequest"
                          minValueBinding="minValue@defaultBean@servletRequest"
                          maxValueBinding="pastChangesTableMaxValue@defaultBean@servletRequest"                          
                          tableDataBinding="tableDataKey@pastChangesTableData@defaultBean@servletRequest"
                          columnFormatsBinding="pastChangesTableColumnFormats@defaultBean@servletRequest"
                          columnHeaderDataBinding="pastChangesTableColumnHeaders@defaultBean@servletRequest">

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                 <uix:sortableHeader textBinding="text"
                                     sortableBinding="sortable"/>
                </uix:columnHeaderStamp>

                <uix:tableSelection>
                 <uix:multipleSelection selectionBinding="selection@defaultBean@servletRequest"
                                        selectedBinding="<%=Constants.SELECTED_KEY%>">
                   <uix:submitButton textBinding="DELETE@commonResourceBundle@servletRequest"
                                     name="event"
                                     value="<%=Constants.DELETE_EVENT%>"/>
                 </uix:multipleSelection> 
                </uix:tableSelection>
                 
                                       
                <uix:contents>
                 <uix:styledText textBinding="jobOwner"/>
                 <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"/>
                 <uix:styledText textBinding="agent"/>
                 <uix:styledText textBinding="<%=Constants.TIMESTAMP_DATE_KEY%>"/>
                 <uix:image sourceBinding="viewDetailsIconSource@defaultBean@servletRequest"
                            destinationBinding="viewDetailsIconDestination"/>
                </uix:contents>
               </uix:table>

           </uix:contents>
          </uix:stackLayout>
        </uix:header>

          </uix:case>
          <uix:case name="<%=Constants.ERR_NODE_VALUE%>">
           <uix:messageBox messageBinding="errorMessage@defaultBean@servletRequest"
                           messageType="error"
                           shortDescBinding="ERR_OCCUR@mntrResourceBundle@servletRequest"
                           textBinding="ERR_OCCUR@mntrResourceBundle@servletRequest">
           </uix:messageBox>


          </uix:case>
         </uix:switcher>

        </uix:contents>
       </uix:pageLayout>
      </uix:body>
      </oem:form>
    
   </uix:document>
</uix:renderingContext>
