<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>

<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.mntr.metrics.MetricThresholdsPendingChangesData"/>

<uix:renderingContext id="renderingContext">
 <oem:setURLEncoder id="renderingContext"/>
  <uix:document>

   <%@ include file="/enablePPR.jspf" %>
   <%@ include file="/oemTitle.jspf" %>              

    
     <oem:form name="metricThresholdsPendingChangesForm" method="POST" destination="/console/monitoring/metricThresholdsPendingChanges" copyParams="target,type">
               
      <uix:body>    
      <uix:pageLayout>
       <%@ include file="/oemGlobal.jspf" %>

        <uix:contentFooter>
         <uix:pageButtonBar>                    
          <uix:contents>
           <uix:tableLayout>
            <uix:contents>
             <uix:rowLayout>
              <uix:contents>
               <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
                <uix:case name="<%=Constants.OK_NODE_VALUE%>">
                 <uix:cellFormat wrappingDisabled="true">
                  <uix:submitButton textBinding="REFRESH@commonResourceBundle@servletRequest" 
                                    name="event"
                                    value="<%=Constants.REFRESH_EVENT%>"/> 
                  <uix:spacer width="3"/> 
                 </uix:cellFormat>
                </uix:case>
               </uix:switcher>
               <uix:cellFormat wrappingDisabled="true">
                <uix:submitButton textBinding="OK@commonResourceBundle@servletRequest" 
                                  name="event"
                                  value="<%=Constants.PREV_EVENT%>"/>
               </uix:cellFormat>             
              </uix:contents>
             </uix:rowLayout>
            </uix:contents>
           </uix:tableLayout>
          </uix:contents>
         </uix:pageButtonBar>
        </uix:contentFooter>

         <uix:contents>
          
          <uix:formValue name="mode" valueBinding="mode@defaultBean@servletRequest"/>
         <uix:switcher childNameBinding="nodeValue@defaultBean@servletRequest">
          <uix:case name="<%=Constants.OK_NODE_VALUE%>">

          <uix:stackLayout>
           <uix:contents>
           
          <uix:header textBinding="METRIC_THRESHOLDS_PENDING_CHANGES_HEADER@mntrResourceBundle@servletRequest">

           <uix:tableLayout hAlign="right">
            <uix:contents>
             <uix:rowLayout>
              <uix:contents>
               <uix:cellFormat wrappingDisabled="true">
                <uix:styledText styleClass="OraTipText"
                                textBinding="PAGE_REFRESHED@mntrResourceBundle@servletRequest"/>
               </uix:cellFormat>
               <uix:spacer width="7"/> 
               <uix:cellFormat wrappingDisabled="true">
                <uix:styledText styleClass="OraTipLabel"
                                textBinding="timestamp@defaultBean@servletRequest"/>
               </uix:cellFormat>               
               <uix:spacer width="5"/> 
               <uix:cellFormat wrappingDisabled="true">
                <uix:submitButton textBinding="REFRESH@commonResourceBundle@servletRequest" 
                                  name="event"
                                  value="<%=Constants.REFRESH_EVENT%>"/> 
               </uix:cellFormat>                    
               <uix:spacer width="3"/> 
               <uix:cellFormat wrappingDisabled="true">
                <uix:button textBinding="OK@commonResourceBundle@servletRequest" 
                            destinationBinding="OKButtonDestination@defaultBean@servletRequest"/>
               </uix:cellFormat>             
              </uix:contents>
             </uix:rowLayout>
            </uix:contents>
           </uix:tableLayout>

            <uix:spacer height="15"/>
           
            <uix:header textBinding="pendingJobsToTargetTableHeader@defaultBean@servletRequest">

             <uix:styledText textBinding="pendingJobsToTargetTableText@defaultBean@servletRequest"
                             styleClass="OraInstructionText"/>

             <uix:rowLayout>
              <uix:spacer height="20"/>
             </uix:rowLayout>

               <uix:table name="pendingJobsToTargetTable"
                          id="pendingJobsToTargetTable"
                          partialRenderMode="self"
                          alternateTextBinding="NO_DATA_STR@mntrResourceBundle@servletRequest"
                          width="100%"
                          formSubmitted="true"
                          blockSize="10"
                          valueBinding="toTargetTableValue@defaultBean@servletRequest"
                          minValueBinding="minValue@defaultBean@servletRequest"
                          maxValueBinding="toTargetTableMaxValue@defaultBean@servletRequest"                          
                          tableDataBinding="tableDataKey@pendingJobsToTargetTableData@defaultBean@servletRequest"
                          columnFormatsBinding="pendingJobsToTargetTableColumnFormats@defaultBean@servletRequest"
                          columnHeaderDataBinding="pendingJobsToTargetTableColumnHeaders@defaultBean@servletRequest">

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:columnHeaderStamp>
                 <uix:sortableHeader textBinding="text"
                                     sortableBinding="sortable"/>
                </uix:columnHeaderStamp>

                <uix:contents>
                 <uix:styledText textBinding="jobOwner"/>
                 <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"/>
                 <uix:styledText textBinding="agent"/>
                 <uix:styledText textBinding="<%=Constants.TIMESTAMP_DATE_KEY%>"/>
                 <uix:styledText textBinding="runStatus"/>
                 <uix:image sourceBinding="viewDetailsIconSource@defaultBean@servletRequest"
                            destinationBinding="viewDetailsIconDestination"/>
                </uix:contents>
               </uix:table>

            </uix:header>

            <uix:spacer height="10"/>

            <uix:header textBinding="pendingJobsFromTargetTableHeader@defaultBean@servletRequest">

             <uix:styledText textBinding="pendingJobsFromTargetTableText@defaultBean@servletRequest"
                             styleClass="OraInstructionText"/>

             <uix:rowLayout>
              <uix:spacer height="20"/>
             </uix:rowLayout>

             <uix:table name="pendingJobsFromTargetTable"
                        id="pendingJobsFromTargetTable" 
                        partialRenderMode="self"
                        alternateTextBinding="NO_DATA_STR@mntrResourceBundle@servletRequest"
                        width="100%"
                        formSubmitted="true"
                        blockSize="10"
                        showAll="yes"
                        valueBinding="fromTargetTableValue@defaultBean@servletRequest"
                        minValueBinding="minValue@defaultBean@servletRequest"
                        maxValueBinding="fromTargetTableMaxValue@defaultBean@servletRequest"                         
                        tableDataBinding="tableDataKey@pendingJobsFromTargetTableData@defaultBean@servletRequest"
                        columnFormatsBinding="pendingJobsFromTargetTableColumnFormats@defaultBean@servletRequest"
                        columnHeaderDataBinding="pendingJobsFromTargetTableColumnHeaders@defaultBean@servletRequest">


              <uix:tableFormat tableBanding="rowBanding"/>

              <uix:columnHeaderStamp>
               <uix:sortableHeader textBinding="text"
                                   sortableBinding="sortable"/>
              </uix:columnHeaderStamp>

              <uix:contents>
                 <uix:styledText textBinding="jobOwner"/>
                 <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"/>
                 <uix:styledText textBinding="agent"/>
                 <uix:styledText textBinding="<%=Constants.TIMESTAMP_DATE_KEY%>"/>
                 <uix:styledText textBinding="runStatus"/>
                 <uix:image sourceBinding="viewDetailsIconSource@defaultBean@servletRequest"
                            destinationBinding="viewDetailsIconDestination"/>
              </uix:contents>

             </uix:table>

            </uix:header>

           </uix:header>

           </uix:contents>
          </uix:stackLayout>

          </uix:case>
          <uix:case name="<%=Constants.ERR_NODE_VALUE%>">
           <uix:messageBox messageBinding="errorMessage@defaultBean@servletRequest"
                           messageType="error"
                           shortDescBinding="ERR_OCCUR@mntrResourceBundle@servletRequest"
                           textBinding="ERR_OCCUR@mntrResourceBundle@servletRequest">
           </uix:messageBox>


          </uix:case>
         </uix:switcher>

        </uix:contents>
       </uix:pageLayout>
      </uix:body>
      </oem:form>
    

   </uix:document>
</uix:renderingContext>
