<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="java.util.Iterator"%>
<%@ page import="java.util.Map"%>
<%@ page import="java.lang.reflect.Method"%>
<%@ page import="oracle.sysman.eml.chronos.data.SoapBean"%>
<%@ page import="oracle.cabo.ui.UIConstants" %>


<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
      class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
      class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="websiteResourceBundle"
      class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
  <uix:bundle name="soap" class="oracle.sysman.eml.test.ocs.SoapResourceBundle" />    
  <uix:document>
    <%@ include file="/oemTitle.jspf" %> 

    <uix:body>
      <uix:form name="createSOAP" method="POST"
        destination="" >
        <uix:contents>

         <% String header = "Build SOAP Request"; %>
        <uix:pageLayout >
        <%@ include file="/oemGlobal.jspf" %>
        <uix:dataScope currentDataBinding="@servletRequest">
              <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf" %>
          </uix:dataScope>

<uix:tableLayout width="100%">
			<uix:rowLayout hAlign="right" width="100%">
			<uix:include nodeBinding="myMessageBean@servletRequest"/>
      </uix:rowLayout>
      </uix:tableLayout>

           <uix:contentFooter>
              <uix:pageButtonBar>
                 <uix:contents>
                <uix:submitButton textBinding="CANCEL@soap"
                    name="<%=UIConstants.EVENT_PARAM%>"
                    value="SOAP_CANCEL"
                    unvalidated="true"
                    />

                <uix:submitButton  textBinding="OK@soap"
                    name="<%=UIConstants.EVENT_PARAM%>"
                    value="SOAP_OK"
                    unvalidated="true"/>
              </uix:contents>
                </uix:pageButtonBar>
            </uix:contentFooter>


          <uix:header text="<%=header%>">

            <uix:rowLayout hAlign="right">
                <uix:pageButtonBar>
                 <uix:contents>
                <uix:submitButton textBinding="CANCEL@soap"
                    name="<%=UIConstants.EVENT_PARAM%>"
                    value="SOAP_CANCEL"
                    unvalidated="true"/>

                <uix:submitButton  textBinding="OK@soap"
                    name="<%=UIConstants.EVENT_PARAM%>"
                    value="SOAP_OK"
                    unvalidated="true"/>
              </uix:contents>
                </uix:pageButtonBar>
            </uix:rowLayout>


		<uix:styledText styleClass="OraInstructionText" textBinding="OPERATIONS_INSTRUCTION@soap"/>
		<uix:spacer height="8" />
  		<uix:stackLayout >
			<uix:rowLayout width="75%" hAlign="center">
				<uix:contents>
				<uix:radioGroup onChange="submitForm('createSOAP', false, {event:'SOAP_OP_CONTINUE'});"  childDataBinding="operationsDataSet@mySoapBean@servletRequest"
					textBinding="text" valueBinding="value" name="operation" selectedValueBinding="operationName@mySoapBean@servletRequest" disabledBinding="disabled"/>
				</uix:contents>
			</uix:rowLayout>
		</uix:stackLayout>

		<uix:spacer height="10" />
		<uix:header text="Input Parameters" >
			<uix:stackLayout >
				<uix:styledText styleClass="OraInstructionText" textBinding="PARAMS_INSTRUCTION@soap" renderedBinding="nonVoidMethod@mySoapBean@servletRequest"/>
				<uix:styledText styleClass="OraInstructionText" textBinding="NO_PARAMS_INSTRUCTION@soap" renderedBinding="voidMethod@mySoapBean@servletRequest"/>
				<uix:spacer height="8" />
				<uix:labeledFieldLayout width="75%" >
					<uix:contents childDataBinding="paramsDataSet@mySoapBean@servletRequest">
						<uix:messageTextInput nameBinding="name" promptBinding="prompt" columns="15" textBinding="text" required="yes"/>
					</uix:contents>
				</uix:labeledFieldLayout>
			</uix:stackLayout>
		</uix:header>


		<uix:spacer height="10" />
              <uix:header textBinding="AUTHENTICATION_TITLE@soap" >
                <uix:stackLayout>
		<uix:styledText styleClass="OraInstructionText" textBinding="AUTHENTICATION_INSTRUCTION@soap"/>
		<uix:spacer height="8" />
                   <uix:labeledFieldLayout width="75%">
                     <uix:messageTextInput name="realm" promptBinding="SOAP_AUTH_REALM@soap" columns="8" textBinding="realm@servletRequest" />
                     <uix:messageTextInput name="username" promptBinding="SOAP_AUTH_USERNAME@soap" columns="8" textBinding="username@servletRequest"/>
                     <uix:messageTextInput name="password" promptBinding="SOAP_AUTH_PASSWORD@soap" columns="8" textBinding="password@servletRequest" secret="true" />
                   </uix:labeledFieldLayout>
                </uix:stackLayout>
               </uix:header>

	  </uix:header>
        </uix:pageLayout>
        </uix:contents>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

