<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.mntr.metrics.MetricThresholdConstants"%>



<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.mntr.target.TargetSelectionData"/>


<uix:renderingContext id="renderingContext">
<oem:setURLEncoder id="renderingContext"/>

  <uix:document>

   <%@ include file="/enablePPR.jspf" %>
   <%@ include file="/oemTitle.jspf" %>              

    <uix:body>
     <oem:form name="targetSelectionForm" method="POST" destination="/console/monitoring/targetSelection" copyParams="target,type">
      <uix:pageLayout titleBinding="SELECT_TARGETS_HEADER@mntrResourceBundle@servletRequest">
       <%@ include file="/oemGlobal.jspf" %>

        <uix:pageButtons>
         <uix:pageButtonBar>
          <uix:rowLayout>
          <uix:submitButton textBinding="CANCEL@commonResourceBundle@servletRequest" 
                            name="event" 
                            value="<%=Constants.CANCEL_EVENT%>"/>
          <uix:spacer height="3"/>                  
          <uix:submitButton textBinding="SELECT@commonResourceBundle@servletRequest" 
                            name="event" 
                            value="<%=Constants.ADD_EVENT%>"/>
          </uix:rowLayout>                 
         </uix:pageButtonBar>
        </uix:pageButtons>

        <uix:formValue name="<%=MetricThresholdConstants.COPY_MODE_KEY%>" valueBinding="copyMode@defaultBean@servletRequest"/>

        <uix:switcher childNameBinding="copyMode@defaultBean@servletRequest">
         <uix:case name="<%=MetricThresholdConstants.COPY_FROM_MODE%>">
          <uix:formValue name="<%=MetricThresholdConstants.COPY_OPTION%>" valueBinding="copyOption@defaultBean@servletRequest"/>
         </uix:case>
        </uix:switcher>   

        <uix:spacer height="5"/>
        
         <uix:contents>
          <uix:stackLayout>
            <uix:contents>

            <uix:header textBinding="SEARCH_TARGETS_HEADER@mntrResourceBundle@servletRequest" >

             <uix:contents>
 
              <uix:spacer height="5"/>

              <uix:rowLayout>
               <uix:contents>
               
                <uix:messagePrompt promptBinding="SEARCH_FOR_TARGETS_HEADER@mntrResourceBundle@servletRequest"/> 
                <uix:spacer width="4"/>
                <uix:textInput name="searchTargets" 
                               id="searchTargets" 
                               textBinding="searchString@defaultBean@servletRequest" 
                               columns="20"/>
                <uix:spacer width="4"/>
                <uix:submitButton textBinding="GO@commonResourceBundle@servletRequest"
                                  name="event"
                                  value="search"/>
               </uix:contents>
              </uix:rowLayout>
             </uix:contents>
            </uix:header>

            <uix:spacer height="5"/>

            <uix:header textBinding="AVAILABLE_TARGETS_HEADER@mntrResourceBundle@servletRequest" >
             <uix:contents>

              <uix:table name="availableTargetsTable" 
                         id="availableTargetsTable"
                         partialRenderMode="self"
                         summaryBinding="AVAILABLE_TARGETS_HEADER@mntrResourceBundle@servletRequest"
                         alternateTextBinding="SEARCH_NAME_NOT_FOUND@mntrResourceBundle@servletRequest"
                         width="50%"
                         blockSize="10"
                         valueBinding="value@defaultBean@servletRequest"
                         minValueBinding="minValue@defaultBean@servletRequest"
                         maxValueBinding="maxValue@defaultBean@servletRequest"
                         formSubmitted="true"
                         tableDataBinding="tableDataKey@tableData@defaultBean@servletRequest"
                         columnFormatsBinding="columnFormats@defaultBean@servletRequest"
                         columnHeaderDataBinding="columnHeaderData@defaultBean@servletRequest">

               <uix:tableFormat tableBanding="rowBanding"/>

               <uix:columnHeaderStamp>
                <uix:sortableHeader textBinding="text"
                                    sortableBinding="sortable"/>
               </uix:columnHeaderStamp>

		       <uix:tableSelection>
                <uix:switcher childNameBinding="copyMode@defaultBean@servletRequest">
                 <uix:case name="<%=MetricThresholdConstants.COPY_TO_MODE%>">
		          <uix:multipleSelection selectionBinding="selection@defaultBean@servletRequest"
                                     shortDescBinding="SELECT@commonResourceBundle@servletRequest" 
                                     selectedBinding="<%=MetricThresholdConstants.SELECTED_KEY%>"/> 
                 </uix:case>
                 <uix:case name="<%=MetricThresholdConstants.COPY_FROM_MODE%>">
		          <uix:singleSelection selectedIndex="0"
                                   shortDescBinding="SELECT@commonResourceBundle@servletRequest"/> 
                 </uix:case>
                </uix:switcher>
		       </uix:tableSelection>

               <uix:contents>
                <uix:styledText textBinding="<%=Constants.TARGET_NAME_KEY%>"
                                shortDescBinding="NAME@commonResourceBundle@servletRequest"/> 
                <uix:formValue name="<%=Constants.TARGET_NAME_KEY%>" valueBinding="<%=Constants.TARGET_NAME_KEY%>"/> 
               </uix:contents>

              </uix:table>

             </uix:contents>
            </uix:header>

           </uix:contents>
          </uix:stackLayout>

        </uix:contents>

       </uix:pageLayout>
      </oem:form>
    </uix:body>

   </uix:document>
</uix:renderingContext>
