/**
 * A UIX interface for managing the flow of recording/playing back a transaction.
 * This class supports both DHTML and VB playback.
 * @ctor TxnPlayController 
 */
function TxnPlayController()
{
  this.init();
}

TxnPlayController.prototype = new UIController();

TxnPlayController.prototype.init = function()
{
  this.setConsole(new UIXConsole());
  this.onChangeState(Constants.INIT);

  var method = document.getElementById('method');
  if (method && method.value == Constants.METHOD_DHTML) {
    this.m_method = Constants.METHOD_DHTML;
  } else {
    this.m_method = Constants.METHOD_HTTP;
  }
  this.checkDebugMode();
}

TxnPlayController.prototype.play = function()
{
  var getURLElem = document.getElementById("getURL");
  if (getURLElem) {
    this.m_inputStream = new InputStreamHTTP(getURLElem.value);
    this.m_inputStream.setCallbackFunc(TxnPlayController.prototype.receivedCallbackFunc, this);
    this.m_inputStream.open();
  } else {
    stderr.log('document.getElementById("getURL") not found');
  }
}

TxnPlayController.prototype.receivedCallbackFunc = function()
{
  if (this.m_method == Constants.METHOD_HTTP) {
    this.onChangeState(Constants.PLAYING);
    this.playHTTP(this.m_inputStream.read());
  } else if (this.m_method == Constants.METHOD_DHTML) {
    // get the data myself.
    UIController.prototype.play.call(this);
  }
}

/**
 * Called when DHTML playback starts.
 * @tparam Player player
 * @protected
 */
TxnPlayController.prototype.onStartPlay = function (player)
{
  UIController.prototype.onStartPlay.call(this, player);
  if (player) {

    // set trace mode.
    var traceModeElem = document.getElementById("traceMode");
    if (traceModeElem) {
      player.setTraceMode(traceModeElem.value == "true");
    }
    var search = window.location.search;
    if (search.indexOf("showResults=true") != -1) {
      player.setUseAPPMode(true);
    } else {
      player.setUseAPPMode(false);
    }

    player.setInputStream(this.m_inputStream);
    player.setRunMode("Walk");
    player.setDebugMode(this.m_debug);

    var that = this;
    player.addOnStopCallback(function() { that.stop(); });
    player.addOnPauseCallback(function() { that.pause(); });
  }
}

/**
 * Called when DHTML playback stops.
 * @tparam Player player
 * @protected
 */
TxnPlayController.prototype.onStopPlay = function (player)
{
  if (player) {
    this.postResult(player.getE2ETrace(), 
                    new PBReport().process(player.getXMLDocument()));
  }
  UIController.prototype.onStopPlay.call(this, player);
}

TxnPlayController.prototype.abort = function()
{
  if (this.m_method == Constants.METHOD_HTTP) {
    if (this.m_vbTimeoutId) {
      window.clearTimeout(this.m_vbTimeoutId);
      this.m_vbTimeoutId = null;
    }
    if (this.m_e2eTrace != null) {
      this.m_e2eTrace.Stop();
    }
    this.m_e2eTrace = null;
  } else if (this.m_method == Constants.METHOD_DHTML) {
    UIController.prototype.abort.call(this);
  }
}

/**
 * Plays web transaction using VB.
 */
TxnPlayController.prototype.playHTTP = function (pbdata)
{
  if (pbdata == null)
  {
    alert("Unexpected pbdata");
    return;
  }
  var recorderCtl = document.getElementById('recorderCtl');

  if (recorderCtl.dataready == 1) {
    alert("Unexpected recorderCtl.dataready == 1");
    return;
  }

  this.m_timer = new ActiveXObject("OraBcnTxnUtil2.Timer");
  this.m_timer.Start();

  var search = window.location.search;
  if (search.indexOf("showResults=true") != -1) {
    this.m_e2eTrace = new ActiveXObject("OraE2EUtil.OraE2ETrace");
    this.m_e2eTrace.Timer = this.m_timer;
    this.m_e2eTrace.Logging = true; 
    var traceModeElem = document.getElementById("traceMode");
    if (traceModeElem) {
      this.m_e2eTrace.Trace = (traceModeElem.value == "true"); 
    }
    this.m_e2eTrace.Start();
  }

  recorderCtl.startAppTick = this.m_timer.StartTime;
 /*           
  // getURL="/em/console/..../txnPlay.jsp?paramsToGetTxn"
  var getURL = document.getElementById('getURL').value;

  // href="http://....../em/console/.../txnPlay.jsp?paramsForCurrentPage"
  var href = window.location.href;

  // search="?paramsForCurrentPage"
  var search = window.location.search;

  var url = null;

  // we want everything in href before ? and 
  // everything in getURL after and including ?
  var fileIndex = href.indexOf(search);
  var quesIndex = getURL.indexOf("?");

  if (quesIndex != -1 && fileIndex != -1) {
    url = href.substr(0, fileIndex) + getURL.substr(quesIndex);
*/
    recorderCtl.trccomp= "NONE";
    recorderCtl.pbdata = pbdata;
    recorderCtl.intfvers="1";
    recorderCtl.command="PB";
    this.checkVBDataReady();
/*  } else if (quesIndex == -1) {
    alert("received an invalid getURL value:" + getURL);
  } else if (fileIndex == -1) {
    alert("received an invalid href value:" + href);
  } */
}

/**
 * Checks if data is ready during VB playback using a 1 second polling mechanism. 
 */
TxnPlayController.prototype.checkVBDataReady = function() 
{
  var recorderCtl = document.getElementById('recorderCtl');
  try 
  {
    if (recorderCtl.dataready == 1) {

      this.m_vbTimeoutId = null;
      if (this.m_e2eTrace) {
        this.m_e2eTrace.Stop();
      }

      this.onChangeState(Constants.STOPPED);

      var e2eTrace = this.m_e2eTrace;
      this.m_e2eTrace = null;
      this.postResult(e2eTrace, recorderCtl.databuffer);
    } else {
      this.m_vbTimeoutId = window.setTimeout("window.txn.checkVBDataReady()", 1000);
    }
  } catch (ex) {
    // retry in 10 seconds.
    this.m_vbTimeoutId = window.setTimeout("window.txn.checkVBDataReady()", 10000);
  }
}

/**
 * Posts playback data.
 */
TxnPlayController.prototype.postResult = function(e2eTrace, pbdata)
{
  var form = document.forms[0];
  if (form) {
    form.dmsData.value = this._getDMSData(e2eTrace);
    form.requestData.value = this._getRequestData(e2eTrace);
    if (!pbdata || pbdata == "") {
      pbdata = "vbsteps=0";
    }
    form.pbPostData.value = pbdata;
    form.submit();
  }
}

/**
 * Gets DMS data
 * @private
 */
TxnPlayController.prototype._getDMSData = function(e2eTrace)
{ 
  var traceModeElem = document.getElementById("traceMode");
  if (!traceModeElem || traceModeElem.value != "true") {
    return ""; 
  }
  if (!e2eTrace) {
    return "";
  }

  var s1 = new StringBuffer();
  s1.append("src=trc"); 

  //Add ecid 
  var ecid = e2eTrace.ECID;
  s1.append("&ecid=", escape(ecid));

  var headers = e2eTrace.HTTPHeaders;
  var numReq = headers.Count;

  var curHeader = null;

  for (i = 0; i < numReq; i++) {
    curHeader = headers.Item(i);

    //DMS related
    var traceContext = curHeader.TraceContext;      
    var fakeJsessionId = curHeader.fakeJsessionId;

    s1.append("&apptrcctx", i,"=", traceContext); 
    if ( fakeJsessionId != "") {
      s1.append("&appfakejsid", i, "=", escape(fakeJsessionId));
    }                                                 
  }

  return s1.toString();
}

/**
 * Gets Request Data
 * @private
 */
TxnPlayController.prototype._getRequestData = function(e2eTrace) 
{
  if (!e2eTrace) {
    return "&appurls=0";
  }

  try 
  {
    var headers = e2eTrace.HTTPHeaders;
    var numReq = headers.Count;

    //Initialize s1 with number of requests
    var s1 = new StringBuffer();

    s1.append("&appurls=", numReq);

    var curHeader = null;

    for (i = 0; i < numReq; i++) {
      curHeader = headers.Item(i);

      //The url(s)
      var url = curHeader.URL;
      var redirectedUrl = curHeader.RedirectedURL;

      //HTTP response
      var contentType = curHeader.ContentType;
      var contentLength = curHeader.ContentLength;
      var statusCode = curHeader.StatusCode;

      //Timing
      var startTime = curHeader.StartTime;
      var endTime = curHeader.EndTime;

      s1.append("&appurl",  i, "=", escape(url));
      s1.append("&appredir",i, "=", escape(redirectedUrl));

      s1.append("&appconttype",i, "=", contentType);
      s1.append("&appcontlen", i, "=", contentLength);

      if (statusCode < 400) {
        s1.append("&appstatus",i, "=0");
      } else {
        s1.append("&appstatus",i, "=1"); 
      }

      s1.append("&apphttpcode",i, "=", statusCode); 
      s1.append("&appstart",   i, "=", startTime);
      s1.append("&append",     i, "=", endTime);
    }
    return s1.toString();
  } 
  catch (ex)
  {
    return "&appurls=0";
  }

}


// alert(resultsNotAvailMsg);

