/**
 * @class TxnRecordController.
 * A UIX interface for managing the flow of recording/playing back a transaction.
 */
function TxnRecordController()
{
  this.onChangeState(Constants.INIT);
  this.setConsole(new UIXConsole());
  this.checkDebugMode();
}

TxnRecordController.prototype = new UIController();

TxnRecordController.prototype.onStartRecord = function (recorder)
{
  UIController.prototype.onStartRecord.call(this, recorder);
  if (recorder) {
    // set the starting URL.
    var txnStartingUrl = document.getElementById("txnStartingUrl");
    if (txnStartingUrl) {
      recorder.setStartingUrl(txnStartingUrl.value);
    } 

    // set the transaction name.
    var txnName = document.getElementById("txnName").value;
    recorder.setTxnName(txnName);

    // set the trace mode
    var traceModeElem = document.getElementById("traceMode");
    if (traceModeElem) {
      recorder.setTraceMode(traceModeElem.value);
    }
    recorder.setDebugMode(this.m_debug);

    recorder.setMaskPasswordMode(false);

    this.getConsole().clear();
  }
}

TxnRecordController.prototype.onStopRecord = function(recorder)
{
  if (recorder) {
    this.m_xmlRequests = 0;

    var postURL = document.getElementById("postURL").value;
    var outputStream = new OutputStreamHTTP(postURL);
    if (outputStream) {
      outputStream.setCallbackFunc(this._handleHTTPResponse, this);
      outputStream.printNode(recorder.getRecordingTemplate());
    }
  }
  UIController.prototype.onStopRecord.call(this, recorder);
}

TxnRecordController.prototype.onChangeState = function (state)
{
  var recordButton   = document.getElementById("txnRecord");
  var recordAgain    = document.getElementById("txnRecordAgain");
  var logging        = document.getElementById("logging");

  var continueButton   = document.getElementById("txnStop");
  var continueDisabled = document.getElementById("txnStopDisabled");

  if (state == Constants.INIT) {
    show(recordButton);
    hide(recordAgain);

    hide(continueButton);
    show(continueDisabled);

    show(logging);

    hide(document.getElementById("downloadMsg"));
    show(document.getElementById("instruction"));
    show(document.getElementById("tip"));

  } else if (state == Constants.STOPPED) {
    // does not apply here.
  } else if (state == Constants.PAUSED) {
    // doe snot apply here.
  } else if (state == Constants.RECORDING) {

    hide(recordButton);
    show(recordAgain);

    show(continueButton);
    hide(continueDisabled);

    show(logging);
  }
}

/**
 * Handles the HTTP response.
 * @private
 */
TxnRecordController.prototype._handleHTTPResponse = function(xmlHttpReq)
{
  if (xmlHttpReq.status == 200) {
    // multiple callbacks will increment this,
    // but they will do it syncrhnously in the same thread.
    var responseText = xmlHttpReq.responseText;
    if (responseText) {
      responseText = Util.trim(responseText);
      if (responseText == "OK") {
        this.m_xmlRequests++;
      } else {
        alert(responseText);
      }
    }
  } else {
    stderr.log("Status " + xmlHttpReq.status);
  }

  if (this.m_xmlRequests == 1) {
    // redirect to the main page by form submit
    var form = document.forms[0];
    if (form) {
      form.submit();
    }
  }
}
