<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns:fn="http://www.w3.org/2005/02/xpath-functions"
  version="1.0">

  <xsl:output method="text" />
  <xsl:template match="transaction">
<xsl:apply-templates select="action"/>
<xsl:apply-templates select="props"/>
</xsl:template>

<xsl:template match="props">
</xsl:template>

<xsl:template match="action[@type='wait' and @for='traffic']">
// Wait
player.waitFor('traffic', 0);
</xsl:template>

<xsl:template match="action[@type='wait' and @for]">
// Wait
player.waitFor("<xsl:value-of select="@for"/>", <xsl:call-template name="getWindow"/>);
</xsl:template>

<xsl:template match="action[@type='waitForPageToLoad']">
// Wait
player.waitFor('load', <xsl:call-template name="getWindow"/>, '<xsl:value-of select="@frame"/>');
</xsl:template>

<xsl:template match="action[@type='waitForPopup']">
// Wait
player.waitFor('open', <xsl:call-template name="getWindow"/>);
</xsl:template>

<xsl:template match="action[@type='waitForPopupClose']">
// Wait
player.waitFor('close', <xsl:call-template name="getWindow"/>);
</xsl:template>

<xsl:template match="action[@type='sleep']">
// Sleep
<xsl:call-template name="getPrint"/>
player.sleep(<xsl:value-of select="@timeout"/>);
</xsl:template>

<xsl:template match="action[@type='script']">
// Action
<xsl:call-template name="getPrint"/>
{ 
  <xsl:call-template name="getBrowser"/>
  <xsl:value-of select="."/> 
}
</xsl:template>

<xsl:template match="action[@type='step']">
// Action
pf.markStep("<xsl:value-of select="@name"/>", "<xsl:value-of select="@stepId"/>"); 
</xsl:template>

<xsl:template match="action[@type='add' and @for='success']">
// Action
pf.addSuccessString("<xsl:value-of select="@value"/>", "<xsl:value-of select="@mode"/>", "<xsl:value-of select="@level"/>"); 
</xsl:template>

<xsl:template match="action[@type='add' and @for='failure']">
// Action
pf.addFailureString("<xsl:value-of select="@value"/>", "<xsl:value-of select="@mode"/>", "<xsl:value-of select="@level"/>"); 
</xsl:template>

<xsl:template match="action[@type='addStep']">
// Action
pf.addStep2Group("<xsl:value-of select="@name"/>", "<xsl:value-of select="@group"/>");
</xsl:template>

<xsl:template match="action[@type='goto' or @type='open']">
// Action
<xsl:call-template name="getPrint"/>
<xsl:call-template name="getBrowser"/>pf.navigate2(br,"<xsl:value-of select="@newValue"/>");
</xsl:template>

<xsl:template match="action[@type='select' or @type='keyPress' or @type='type']">
// Action
<xsl:call-template name="getPrint"/>
<xsl:call-template name="getBrowser"/><xsl:call-template name="getElement"/>pf.<xsl:value-of select="@type"/>(elem, "<xsl:value-of select="@newValue"/>");
</xsl:template>

<xsl:template match="action[@type='click' or @type='check' or @type='submit' or @type='hover' or @type='mouseDown' or @type='mouseUp']">
// Action
<xsl:call-template name="getPrint"/>
<xsl:call-template name="getAction1"/>
</xsl:template>

<xsl:template match="action[@type='verify' and @for='SuccessString']">
// Action
<xsl:call-template name="getPrint"/>
<xsl:call-template name="getBrowser"/>
pf.verifySuccessString(br.document, "<xsl:value-of select="@text"/>");
<!--    pf.verifySuccessString(br.document, "<xsl:call-template name="do-replace"><xsl:with-param name="t" select="@text" /><xsl:with-param name="replace" select="'&quot;'" /><xsl:with-param name="by" select="'\&quot;'" /></xsl:call-template>"); -->
</xsl:template>

<xsl:template match="action[@type='verify' and @for='ErrorString']">
// Action
<xsl:call-template name="getPrint"/>
<xsl:call-template name="getBrowser"/>
pf.verifyErrorString(br.document, "<xsl:value-of select="@text"/>");
<!--pf.verifyErrorString(br.document, "<xsl:call-template name="do-replace"><xsl:with-param name="t" select="@text" /><xsl:with-param name="replace" select="'&quot;'" /><xsl:with-param name="by" select="'\&quot;'" /></xsl:call-template>"); -->
</xsl:template>

<!-- template functions -->
<xsl:template name="getAction1"><xsl:call-template name="getBrowser"/><xsl:call-template name="getElement"/>pf.<xsl:value-of select="@type"/>(elem);
</xsl:template>

<xsl:template name="getBrowser">
var br = player.getBrowserAt(<xsl:call-template name="getWindow"/>);
if (!br) { player.tryContinue(); return; }
</xsl:template>

<xsl:template name="getElement">var elem = <xsl:call-template name="getElementFunc"/>;
if (!elem) { player.tryContinue(); return; }
</xsl:template>

  <xsl:template name="getElementFunc">
    <xsl:choose>
      <xsl:when test="(@text) and (@tagName)">pf.getElementByTextAndTag(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@text"/>", 
        "<xsl:value-of select="@tagName"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="@text">pf.getElementByText(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@text"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="(@title) and (@tagName)">pf.getElementByTitleAndTag( 
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@title"/>", 
        "<xsl:value-of select="@tagName"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="(@alt) and (@tagName)">pf.getElementByAltAndTag(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@alt"/>", 
        "<xsl:value-of select="@tagName"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="@id">pf.getElementById(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@id"/>")</xsl:when>

      <xsl:when test="@onclick">pf.getElementByOnclickAndTag(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@onclick"/>", 
        "<xsl:value-of select="@tagName"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="(@value) and (@tagName='input')">pf.getButtonByValue(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@value"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="@name">pf.getElementByName(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@name"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="@src">pf.getImageBySrc(
        <xsl:call-template name="getFrame"/>, 
        "<xsl:value-of select="@src"/>", 
        <xsl:call-template name="getIndex"/>,
        <xsl:call-template name="getRegExp"/>)</xsl:when>

      <xsl:when test="@html">pf.getElementByInnerHTML(
        <xsl:call-template name="getFrame"/>,
        "<xsl:value-of select="@tagName"/>", 
        "<xsl:value-of select="@html"/>",
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="@index">pf.getElementByIndex(
        <xsl:call-template name="getFrame"/>, 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:when test="@xpath">pf.getElementByXPath(
        br, 
        "<xsl:value-of select="@xpath"/>", 
        <xsl:call-template name="getIndex"/>)</xsl:when>

      <xsl:otherwise>null</xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="getFrame">
    <xsl:choose><xsl:when test="@frame">pf.getFrame(br, '<xsl:value-of select="@frame"/>')</xsl:when><xsl:otherwise>br.document</xsl:otherwise></xsl:choose></xsl:template>

  <xsl:template name="getFrame1"><xsl:choose><xsl:when test="@frame">br.document<xsl:value-of select="@frame"/></xsl:when><xsl:otherwise>br.document</xsl:otherwise></xsl:choose></xsl:template>

  <xsl:template name="getIndex"><xsl:choose><xsl:when test="@index"><xsl:value-of select="@index"/></xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:template>

  <xsl:template name="getWindow"><xsl:choose><xsl:when test="@windowIndex"><xsl:value-of select="@windowIndex"/></xsl:when><xsl:otherwise>0</xsl:otherwise></xsl:choose></xsl:template>

  <xsl:template name="getRegExp"><xsl:choose><xsl:when test="@regexp"><xsl:value-of select="@regexp"/></xsl:when><xsl:otherwise>false</xsl:otherwise></xsl:choose></xsl:template>

  <xsl:template name="do-replace">
    <xsl:param name="t" />
    <xsl:param name="replace" />
    <xsl:param name="by" />
    <xsl:variable name="tt" select="$t" />
    <xsl:variable name="first" select="substring-before($tt, $replace)" />
    <xsl:variable name="rest" select="substring-after($tt, $replace)" />
    <xsl:value-of select="concat($first, $by)" />
    <xsl:choose>
      <xsl:when test="(substring-before($rest, $replace)) or (substring-after($rest, $replace))">
        <xsl:call-template name="do-replace">
          <xsl:with-param name="t" select="$rest" />
          <xsl:with-param name="replace" select="$replace" />
          <xsl:with-param name="by" select="$by" />
        </xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
        <xsl:value-of select="$rest" />
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template> 

  <xsl:template name="getPrint">
    var tag = "<xsl:value-of select="name()"/>";
    var attrs = {
    <xsl:for-each select="@*">
      <xsl:choose>
        <xsl:when test="name()='nodeId' or name()='time'"/>
        <xsl:otherwise>"<xsl:value-of select="name()"/>":"<xsl:value-of select="."/>",</xsl:otherwise>
      </xsl:choose>
    </xsl:for-each>time:pf.getTime()
    }; 
    pf.onRecordNode(tag, attrs, true);
  </xsl:template>

</xsl:stylesheet> 
