<%--

/* $Header: playbackresults.jsp 30-jan-2007.19:55:04 mvajapey Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    mvajapey      06/13/05 - ada bug 4427288. 
    mvajapey      01/24/05 - Modify url table to use an hGrid. 
    dbrown        05/28/03 - Set charset to utf-8.
    rmarripa      05/19/03 - fix help link
    rmarripa      03/04/03 - change header
    rmarripa      02/07/03 - show data when the data is available
    rmarripa      01/16/03 - fix total response time
    rmarripa      01/15/03 - rewrite to look more like the trace results
    jriel         10/21/02 - fix pie chart
    asawant       07/19/02 - history section added
 */

/**
 *  @version $Header: playbackresults.jsp 30-jan-2007.19:55:04 mvajapey Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp"%>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.emSDK.eml.jsp.tag.UIConstants"%>
<%@ page import="oracle.sysman.eml.beacon.BeaconConstants"%>
<%@ page import="oracle.sysman.resources.website.WebsiteResourceBundleID"%>
<%@ page import="oracle.sysman.resources.beacon.BeaconResourceBundleID"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.TraceConstants"%>
<%@ include file="/oemNoscript.jspf"%>


<uix:renderingContext id="renderingContext">
  <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:document>
    <head>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest"/>
      <uix:styleSheet/>
    </head>
    <uix:body>
      <uix:pageLayout>
        <%@ include file="/oemGlobal.jspf"%>
        <uix:stackLayout>
          <uix:contents>
            <uix:spacer height="5"/>
            <uix:header textBinding="header@browserDataBean@e2ePlaybackData@servletRequest">
              <uix:switcher childNameBinding="nodeValue@browserDataBean@e2ePlaybackData@servletRequest" defaultCase="okNode">
                <uix:case name="errNode">
                  <uix:messageBox messageType="error" messageBinding="errorMessage@browserDataBean@e2ePlaybackData@servletRequest"/>
                </uix:case>
              </uix:switcher>
              <uix:stackLayout>
                <uix:switcher childNameBinding="isInfoMsg@browserDataBean@e2ePlaybackData@servletRequest" defaultCase="none">
                  <uix:case name="infoType">
                    <uix:messageBox messageType="info" messageBinding="infoMessage@browserDataBean@e2ePlaybackData@servletRequest"/>
                  </uix:case>
                </uix:switcher>
              
                <uix:header textBinding="TRACE_SUMMARY_HEADER@WebappMsgBundle@servletRequest">
                  <uix:spacer height="5"/>
                  <uix:switcher childNameBinding="isChartVisible@browserDataBean@e2ePlaybackData@servletRequest">
                    <uix:case name="<%=BeaconConstants.YES%>">
                      <uix:labeledFieldLayout labelWidth="50%" columns="1" width="65%">
                        <uix:styledText textBinding="TRANSACTION_STATUS@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                        <uix:styledText textBinding="txnStatus@browserDataBean@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                        <uix:styledText textBinding="TOTAL_RESPONSE_HDR@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                        <uix:styledText textBinding="totalRespTime@browserDataBean@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                        <uix:styledText textBinding="AVG_RESPONSE_HDR@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                        <uix:styledText textBinding="avgRespTime@browserDataBean@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                        <uix:styledText textBinding="MAX_RESPONSE_HDR@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                        <uix:styledText textBinding="maxRespTime@browserDataBean@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                      </uix:labeledFieldLayout>
                    </uix:case>
                    <uix:case name="<%=BeaconConstants.NO%>">
                      <uix:tableLayout>
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="left">
                            <uix:styledText textBinding="TOTAL_RESPONSE_HDR@WebappMsgBundle@servletRequest" styleClass="OraInstructionText"/>
                          </uix:cellFormat>
                          <uix:spacer width="8"/>
                          <uix:styledText textBinding="totalRespTime@browserDataBean@e2ePlaybackData@servletRequest" styleClass="OraInstructionTextStrong"/>
                        </uix:rowLayout>
                      </uix:tableLayout>
                    </uix:case>
                  </uix:switcher>
                </uix:header>
                <uix:header textBinding="DETAILS_HDR@WebappMsgBundle@servletRequest">
                 <uix:stackLayout> 
                  <uix:spacer height="5"/>
                  <uix:switcher childNameBinding="isChartVisible@browserDataBean@e2ePlaybackData@servletRequest">
                    <uix:case name="<%=BeaconConstants.YES%>">
                      <oemjsp:chart chartType="barChart" orientation="horizontal" title="n/a" titleVisible="false" width="800" heightBinding="urlChartHeight@browserDataBean@e2ePlaybackData@servletRequest" shadowEffect="3d" stacked="true" legendVisible="false">
                        <uix:contents>
                          <oemjsp:boundChartDataSource chartDataSourceBinding="chartDataSource@browserDataBean@e2ePlaybackData@servletRequest"/>
                          <oemjsp:chartColumn displayLabelBinding="chartUrlColLabel@browserDataBean@e2ePlaybackData@servletRequest" sourceIndex="0" isKey="true"/>
                          <oemjsp:chartColumn displayLabelBinding="chartRTColLabel@browserDataBean@e2ePlaybackData@servletRequest" sourceIndex="1"/>
                        </uix:contents>
                      </oemjsp:chart>
                    </uix:case>
                  </uix:switcher>
                  <uix:spacer height="20"/>
                  <%@ include file="/webapp/e2e/trace/browsertree.jspf" %>
                  
                  <uix:spacer height="10"/>
                 </uix:stackLayout> 
                </uix:header>
                <uix:spacer height="10"/>
              </uix:stackLayout>
            </uix:header>
          </uix:contents>
        </uix:stackLayout>
        <uix:contentFooter>
          <uix:pageButtonBar/>
        </uix:contentFooter>
      </uix:pageLayout>
    </uix:body>
  </uix:document>
</uix:renderingContext>
