<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.gensvc.view.data.ui.SvcCompAvailUIBean"%>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants"%>
<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="sdkMsg" class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="GenSvcRB" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
  <uix:bundle name="MntrRB" class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="WebsiteRB" class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
  <uix:dataScope currentDataBinding="UI_BEAN@servletRequest">
    <uix:document>
      <%@ include file="/enablePPR.jspf"%>
      <%@ include file="/oemTitle.jspf"%>
      <uix:body>
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf"%>
          <uix:header textBinding="headerPage">
            <uix:dataScope currentDataBinding="@servletRequest">
              <%@ include file="/gensvc/message.jspf"%>
            </uix:dataScope>
            <uix:tableLayout width="100%">
              <uix:rowLayout hAlign="right">
                <uix:cellFormat vAlign="top" hAlign="right">
                  <uix:rowLayout>
                    <uix:styledText styleClass="OraTipText" textBinding="PAGE_REFRESHED_TIME@sdkMsg"/>
                    <uix:spacer width="4"/>
                    <uix:styledText styleClass="OraTipLabel" textBinding="lastUpdateTime"/>
                    <uix:spacer width="4"/>
                    <uix:image sourceBinding="refreshImage" destinationBinding="refreshLink"/>
                  </uix:rowLayout>
                </uix:cellFormat>
                <uix:cellFormat vAlign="top" width="200" hAlign="right">
                  <uix:form name="OneBigForm" method="POST">
                    <uix:styledText textBinding="VIEWDATA_TEXT@sdkMsg" styleClass="OraPromptText"/>
                    <uix:choice name="<%= EmlConstants.PAGE_TYPE_PAGE_PROPERTY %>" id="PeriodChange" onChange="submitForm('OneBigForm',0,{'event':'CHANGE_PERIOD'}); return false;">
                      <uix:contents>
                        <uix:option textBinding="LAST_DAY@MntrRB" value="<%= EmlConstants.LAST_24_HRS %>" selectedBinding="viewByDay"/>
                        <uix:option textBinding="LAST_WEEK@MntrRB" value="<%= EmlConstants.LAST_7_DAYS %>" selectedBinding="viewByWeek"/>
                        <uix:option textBinding="LAST_MONTH@MntrRB" value="<%= EmlConstants.LAST_31_DAYS %>" selectedBinding="viewByMonth"/>
                      </uix:contents>
                    </uix:choice>
                  </uix:form>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>
            <uix:header textBinding="AVAIL_HIST_HEADER@GenSvcRB">
              <uix:stackLayout>
                <uix:tableLayout width="960">
                  <uix:contents>
                    <uix:dataScope currentDataBinding="availOverview">
                       <uix:rowLayout>
                        <uix:cellFormat width="50%" vAlign="top">
                          <uix:tableLayout width="100%" borderWidth="0">
                            <uix:rowLayout>
                              <uix:cellFormat width="50%" hAlign="right">
                                <uix:styledText styleClass="OraPromptText" textBinding="CURRENT_STATUS@MntrRB"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.CURRENT_STATUS_KEY %>"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText" textBinding="SINCE@MntrRB"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.SINCE_KEY %>"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText" textBinding="AVAILABILITY_PERCENT@MntrRB"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.AVAIL_KEY %>"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_DOWN_TIME@MntrRB"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.TOTAL_DOWNTIME_KEY %>"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_BLACKOUT_TIME@MntrRB"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.SCH_DOWNTIME_KEY %>"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_AGENT_DOWN_TIME@MntrRB"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.TOTAL_UNMONTIME_KEY %>"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                            <uix:rowLayout>
                              <uix:cellFormat hAlign="right">
                                <uix:styledText styleClass="OraPromptText" textBinding="TOTAL_METRIC_ERROR_TIME@MntrRB"/>
                              </uix:cellFormat>
                              <uix:spacer width="5"/>
                              <uix:cellFormat hAlign="left">
                                <uix:styledText styleClass="OraDataText" textBinding="<%= SvcCompAvailUIBean.TOTAL_ERROR_KEY %>"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                          </uix:tableLayout>
                        </uix:cellFormat>
                        <uix:cellFormat hAlign="left" vAlign="top">
                          <oem:chart chartType="pieChart" width="480" legendPosition="east" height="175" pieValuesInLegend="percent" showSlicePercentLabels="false" pieSliceColorsBinding="<%= SvcCompAvailUIBean.PIE_SLICE_COLORS_KEY %>" hideZeroSlices="true">
                            <uix:contents>
                              <oem:boundChartDataSource chartDataSourceBinding="<%= SvcCompAvailUIBean.CHART_DATA_SOURCE_KEY %>"/>
                              <oem:chartColumn sourceIndex="0" isKey="true"/>
                              <oem:chartColumn sourceIndex="1" displayLabel=""/>
                            </uix:contents>
                          </oem:chart>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:dataScope>
                    <uix:rowLayout>
                      <uix:cellFormat hAlign="right" vAlign="bottom" columnSpan="2">
                        <uix:rowLayout>
                          <uix:cellFormat hAlign="right" widthBinding="<%= SvcCompAvailUIBean.IMAGE_WIDTH %>">
                            <uix:stackLayout>
                              <uix:include nodeBinding="selfAvailLine"/>
                              <uix:include nodeBinding="timeLine"/>
                            </uix:stackLayout>
                          </uix:cellFormat>
                        </uix:rowLayout>
                      </uix:cellFormat>
                    </uix:rowLayout>
                  </uix:contents>
                </uix:tableLayout>
              </uix:stackLayout>
            </uix:header>
            <uix:stackLayout>
              <uix:ref refID="monitoring/website/txn/txnBcnAvailSegment"/>
              <uix:rowLayout width="978">
                <uix:cellFormat hAlign="right">
                  <uix:include nodeBinding="timeLine"/>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:stackLayout>
            <uix:header textBinding="AVAILABILITY_TRANSITIONS@GenSvcRB">
              <uix:include nodeBinding="tableBean"/>
            </uix:header>
            <uix:spacer height="10"/>
          </uix:header>
        </uix:pageLayout>
      </uix:body>
    </uix:document>
  </uix:dataScope>
</uix:renderingContext>
