<%--

/* $Header: txnGenProps.jsp 19-feb-2007.17:02:58 andyao Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    The Create/Edit/View Web Transaction JSP.
    Displays the main transaction editing page.

   NOTES
    None

   MODIFIED    (MM/DD/YY)
    rgraham       03/26/07 - add transaction page segment for recording
    andyao        11/08/06 - refactor UI
    yxie          07/18/06 - Backport yxie_bug-5344920 from main
    yxie          06/27/06 - Fix security bug 5344920
    andyao        08/30/05 - fix no auto complete 
    andyao        07/25/05 - show template apply train
    andyao        07/24/05 - add fire partial action 
    andyao        06/16/05 - use display value 
    andyao        06/13/05 - add table summary 
    andyao        05/27/05 - show description in view 
    andyao        04/07/05 - fix layout
    mfidanbo      03/29/05 - add verify test
    andyao        03/23/05 - ui layout fixes
    andyao        03/10/05 - make password read only 
    andyao        03/01/05 - add template support for passwords 
    andyao        02/11/05 - add default interval 
    andyao        01/27/05 - fix layout 
    andyao        01/17/05 - add edit button 
    andyao        01/07/05 - fix layout 
    andyao        12/23/04 - fix alignment 
    andyao        11/24/04 - 
    andyao        11/10/04 - remove redundant hr 
    andyao        10/31/04 - add wizard 
    vjraghav      10/12/04 - Changing the property dropdowns 
    vjraghav      09/20/04 - Cutting over to the new and official metadata 
                             implementation 
    pmadyalk      09/17/04 - bug fixing 
    pmadyalk      09/13/04 - Txn R2 Changes 
    pmadyalk      08/26/04 - 
    dbrown        05/28/03 - Set charset to utf-8.
    asawant       06/24/02 - moving from jsp to jspf
    njuillar      05/17/02 - Added form values for target name/type
    asawant       04/30/02 - history section added
 */

/**
 *  @version $Header: txnGenProps.jsp 19-feb-2007.17:02:58 andyao Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants"%>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcPageSegmentTypes"%>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <uix:form method="POST" name="mainForm">

        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:dataScope currentDataBinding="@servletRequest">
            <uix:bundle name="gensvc"
              class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
            <uix:bundle name="websiteResourceBundle"
              class="oracle.sysman.resources.website.WebsiteResourceBundle"/>

            <%@ include file="/gensvc/message.jspf" %>
            <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf" %>
            <%@ include file="/webapp/tmpl/applyTemplateTrain.jspf" %>

            <uix:header textBinding="pageHeader">

              <uix:tableLayout width="100%" borderWidth="0">
                <uix:rowLayout hAlign="right"><%@ include file="/gensvc/admin/gensvcTestNavBar.jspf" %></uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout width="100%" borderWidth="0">
                <uix:rowLayout><uix:ref refID="<%=GenSvcPageSegmentTypes.GENSVC_TEST_GENERAL%>"/></uix:rowLayout>
              </uix:tableLayout>

              <uix:script text="function show(id) { var elem = document.getElementById(id); if (elem && elem.style) { elem.style.display = 'inline'; } } function hide(id) { var elem = document.getElementById(id); if (elem && elem.style) { elem.style.display = 'none'; } }"/>

              <uix:header textBinding="TRANSACTION@websiteResourceBundle">
                <uix:tableLayout width="100%" borderWidth="0">
                  <uix:rowLayout><uix:spacer height="5"/></uix:rowLayout>
                  <uix:rowLayout>
                    <uix:cellFormat vAlign="top">
                      <uix:ref refID="<%=GenSvcPageSegmentTypes.GENSVC_TEST_TXN_SEGMENT%>"/>
                    </uix:cellFormat>
                  </uix:rowLayout>
                </uix:tableLayout>
                <uix:tableLayout width="100%" borderWidth="0">
                  <uix:rowLayout><uix:spacer height="10"/></uix:rowLayout>
                  <uix:rowLayout>
                      <uix:stackLayout>
                        <%@ include file="/monitoring/website/txn/txnGenSubTabs.jsp"%>
                        <uix:stackLayout id="stepsC">
                          <uix:stackLayout id="steps">

                            <%@ include file="/monitoring/website/txn/txnUserActionList.jsp"%>
                            <uix:tip renderedBinding="isTxnNotViewMode@txnWizTableData@servletRequest">
                              <uix:contents>
                                <uix:stackLayout>
                                <uix:text textBinding="TXN_STEP_SECTION_TIP_TEXT_1@websiteResourceBundle"/>
                                <uix:switcher childNameBinding="testType@txnWizTableData@servletRequest">
                                <uix:case name="HTTP">
                                <uix:text textBinding="URL_REGEX_VAR_TEXT@websiteResourceBundle"/>
                                </uix:case>
                                </uix:switcher>
                              </uix:stackLayout>
                              </uix:contents>
                            </uix:tip>

                          </uix:stackLayout>
                        </uix:stackLayout>
                        <uix:stackLayout id="groupsC">
                          <uix:flowLayout id="groups">
                            <%@ include file="/monitoring/website/txn/txnUserActionGroupList.jsp"%>
                          </uix:flowLayout>
                        </uix:stackLayout>
                        <uix:stackLayout id="propsC">
                          <uix:flowLayout id="props">
                            <uix:ref refID="<%=GenSvcPageSegmentTypes.GENSVC_TEST_PROPS%>"/>
                          </uix:flowLayout>
                        </uix:stackLayout>
                        <uix:switcher
                          childNameBinding="selectedSubTab">
                          <uix:case name="0">
                            <uix:script text="show('stepsC');hide('groupsC');hide('propsC')"/>
                          </uix:case>
                          <uix:case name="1">
                            <uix:script text="hide('stepsC');show('groupsC');hide('propsC')"/>
                          </uix:case>
                          <uix:case name="2">
                            <uix:script text="hide('stepsC');hide('groupsC');show('propsC')"/>
                          </uix:case>
                        </uix:switcher>
                        <%@ include file="/monitoring/website/txn/txnGenSubTabs1.jsp"%>

                      </uix:stackLayout>
                  </uix:rowLayout>
                </uix:tableLayout>
            </uix:header>

            <uix:tableLayout width="100%" borderWidth="0" id="testMetrics">
              <uix:rowLayout><uix:ref refID="<%=GenSvcPageSegmentTypes.GENSVC_TEST_METRICS%>"/></uix:rowLayout>
            </uix:tableLayout>

          </uix:header>

          <uix:formValue 
            name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
            valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
            />
          </uix:dataScope>

          <uix:contentFooter>
            <%@ include file="/gensvc/admin/gensvcTestNavBar.jspf" %>
          </uix:contentFooter>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
