<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.chronos.data.TxnPerfUIBean"%>
<uix:buildTree nodeID="pagePlugin">
  <uix:switcher childNameBinding="hasErrors@servletRequest">
    <uix:case name="false">
      <uix:flowLayout>
        <uix:dataScope currentDataBinding="_DATA_SOURCE@servletRequest">
          <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
          <uix:bundle name="GenSvcRB" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
          <uix:bundle name="MntrRB" class="oracle.sysman.resources.MntrResourceBundle"/>
          <uix:bundle name="WebsiteRB" class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
          <uix:form name="OneBigForm" method="POST">
            <uix:formValue nameBinding="ITEM_ID" valueBinding="itemId"/>
            <uix:formValue nameBinding="REFRESH_UIBEAN" valueBinding="NO_REFRESH"/>
            <uix:stackLayout>
              <uix:contents>
                <uix:spacer height="10"/>
                <uix:rowLayout width="100%">
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="VIEWDATA_TEXT@sdkMsg" styleClass="OraPromptText"/>
                    </uix:cellFormat>
                    <uix:cellFormat vAlign="top" hAlign="right" width="5"/>
                    <uix:cellFormat vAlign="top" hAlign="right" width="50">
                      <uix:choice nameBinding="CHANGE_PERIOD_EVENT" id="PeriodChange" onChange="submitForm('OneBigForm',0,{'event':'ChangePeriod'}); return false;">
                        <uix:contents>
                          <uix:option textBinding="REAL_TIME@MntrRB" valueBinding="PCURRENT" selectedBinding="viewByCurrent"/>
                          <uix:option textBinding="LAST_HOUR@MntrRB" valueBinding="P1H" selectedBinding="viewByHour"/>
                          <uix:option textBinding="LAST_DAY@MntrRB" valueBinding="P24H" selectedBinding="viewByDay"/>
                          <uix:option textBinding="LAST_WEEK@MntrRB" valueBinding="P7D" selectedBinding="viewByWeek"/>
                          <uix:option textBinding="LAST_MONTH@MntrRB" valueBinding="P31D" selectedBinding="viewByMonth"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                <uix:header textBinding="UI_STRING_CHART_HEADER" renderedBinding="showHistoricChart">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraPromptText" textBinding="HISTORIC_CHART_BODY@GenSvcRB"/>
                      <uix:spacer height="40"/>
                    </uix:rowLayout>
                    <uix:tableLayout borderWidth="0" cellSpacing="5">
                      <uix:rowLayout>
                        <uix:cellFormat rowSpan="2">
                          <uix:styledText textBinding="multSelectionMsg" styleClass="OraPromptText"/>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top" rowSpan="2">
                          <uix:list nameBinding="multSelectionName" multiple="true" size="3">
                            <uix:contents childDataBinding="multipleSTable">
                              <uix:option textBinding="TEXT" valueBinding="VALUE" selectedBinding="SELECTED"/>
                            </uix:contents>
                          </uix:list>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:cellFormat>
                          <uix:styledText textBinding="singSelectionMsg2" styleClass="OraPromptText"/>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top">
                          <uix:choice nameBinding="singSelectionName2" id="SingSelectListTwo">
                            <uix:contents childDataBinding="singleSTableTwo">
                              <uix:option textBinding="TEXT" valueBinding="VALUE" selectedBinding="SELECTED"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top">
                          <uix:submitButton textBinding="GO@WebsiteRB" id="GraphSelectSubmit" valueBinding="CHART_PARAMS_EVENT" name="event"/>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top" hAlign="right" renderedBinding="showComponents">
                          <uix:styledText styleClass="OraInstructionText" textBinding="SHOW_MULTIPLE@GenSvcRB"/>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top" hAlign="center" renderedBinding="showComponents">
                          <uix:contents childDataBinding="rotationLinks">
                            <uix:link textBinding="TEXT" destinationBinding="DEST"/>
                            <uix:spacer width="15" height="0"/>
                          </uix:contents>
                        </uix:cellFormat>
                      </uix:rowLayout>
                      <uix:rowLayout>
                        <uix:spacer width="10"/>
                        <uix:cellFormat renderedBinding="showComponents">
                          <uix:styledText textBinding="singSelectionMsg1" styleClass="OraPromptText"/>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top" renderedBinding="showComponents">
                          <uix:choice nameBinding="singSelectionName1" id="SingSelectListOne" >
                            <uix:contents childDataBinding="singleSTableOne">
                              <uix:option textBinding="TEXT" valueBinding="VALUE" selectedBinding="SELECTED"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>                   
                    <uix:rowLayout renderedBinding="renderMultipleSelectionError">
                      <uix:messageText messageType="error" messageBinding="NO_MULT_SELECTION_ALLOWED@GenSvcRB"/>
                    </uix:rowLayout>
                    <uix:ref refID="monitoring/website/genericChart"/>
                  </uix:contents>
                </uix:header>
                <uix:hideShowHeader partialRenderMode="self" textBinding="UI_STRING_GRP_HDR" disclosedBinding="showHdr1" id="<%= TxnPerfUIBean.TRANSACTION_HIDESHOW %>" formSubmitted="true">
                  <uix:contents>
                    <uix:header textBinding="ALL_METRICS@WebsiteRB">
                      <uix:contents>
                        <uix:rowLayout widthBinding="pageWidth">
                          <uix:ref refID="monitoring/website/genericTable_AllMetrics"/>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:header>
                    <uix:header textBinding="CUMULATIVE_TIME@GenSvcRB">
                      <uix:contents>
                        <uix:rowLayout widthBinding="pageWidth">
                          <uix:ref refID="monitoring/website/genericTable_Cumulative"/>
                        </uix:rowLayout>
                        <uix:rowLayout width="80%">
                          <uix:cellFormat hAlign="right">
                            <uix:include nodeBinding="tableLegend"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout widthBinding="pageWidth">
                          <uix:spacer height="20" width="0"/>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:header>
                  </uix:contents>
                </uix:hideShowHeader>
                <uix:hideShowHeader partialRenderMode="self" textBinding="UI_STRING_USER_ACTIONS_HDR" disclosedBinding="showHdr2" id="<%= TxnPerfUIBean.UAGRPS_HIDESHOW %>" renderedBinding="showGrpsActions" formSubmitted="true">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:spacer width="0" height="20"/>
                    </uix:rowLayout>
                    <uix:rowLayout>
                      <uix:cellFormat>
                        <uix:styledText styleClass="OraPromptText" textBinding="ORDER_BY@webappMsg"/>
                      </uix:cellFormat>
                      <uix:spacer width="5"/>
                      <uix:cellFormat vAlign="top">
                          <uix:choice nameBinding="GroupActionVsBcnPivotMsg" id="GroupActionVsBcnPivot" onChange="submitForm('OneBigForm',0,{'event':'ChangePivot'}); return false;">
                            <uix:contents>
                              <uix:option textBinding="UI_STRING_BEACONS" value="Beacons" selectedBinding="viewByBeacons"/>
                              <uix:option textBinding="UI_STRING_USER_ACTIONS" value="Components" selectedBinding="viewByComponents"/>
                            </uix:contents>
                          </uix:choice>
                      </uix:cellFormat>
                    </uix:rowLayout>
                    <uix:header textBinding="ALL_METRICS@WebsiteRB">
                      <uix:contents>
                        <uix:hGrid partialRenderMode="self" widthBinding="pageWidth" treeDataBinding="allMetricsTreeData" columnHeaderDataBinding="allMetricsHGridHdr" proxied="true" proxyBinding="allMetricsProxy" id="<%= TxnPerfUIBean.HGRID_AllMetrics %>" columnFormatsBinding="columnFormatsForAllMetricsHGrid" formSubmitted="true">
                          <uix:nodeStamp>
                            <uix:column>
                              <uix:columnHeader>
                                <uix:styledText textBinding="NAME_LABEL@MntrRB"/>
                              </uix:columnHeader>
                              <uix:styledText shortDescBinding="url" textBinding="text" styleClassBinding="keyStyle" destinationBinding="dest"/>
                            </uix:column>
                          </uix:nodeStamp>
                          <uix:columnHeaderStamp>
                            <uix:text textBinding="AllMetricsHGridHdrKey"/>
                          </uix:columnHeaderStamp>
                          <uix:styledText textBinding="EntityType"/>
                          <uix:styledText textBinding="Col1"/>
                          <uix:styledText textBinding="Col2"/>
                          <uix:styledText textBinding="Col3"/>
                        </uix:hGrid>
                      </uix:contents>
                    </uix:header>
                    <uix:header textBinding="CUMULATIVE_TIME@GenSvcRB">
                      <uix:contents>
                        <uix:tableLayout widthBinding="pageWidth">
                          <uix:contents>
                            <uix:rowLayout>
                              <uix:hGrid partialRenderMode="self" width="100%" treeDataBinding="cumulativeTreeData" columnHeaderDataBinding="cumulativeHGridHdr" proxied="true" proxyBinding="cumulativeProxy" id="<%= TxnPerfUIBean.HGRID_Cumulative %>" columnFormatsBinding="columnFormatsForCumulativeHGrid" formSubmitted="true">
                                <uix:nodeStamp>
                                  <uix:column>
                                    <uix:columnHeader>
                                      <uix:styledText textBinding="NAME_LABEL@MntrRB"/>
                                    </uix:columnHeader>
                                    <uix:styledText shortDescBinding="url" textBinding="text" styleClassBinding="keyStyle" destinationBinding="dest"/>
                                  </uix:column>
                                </uix:nodeStamp>
                                <uix:columnHeaderStamp>
                                  <uix:text textBinding="CumulativeHGridHdrKey"/>
                                </uix:columnHeaderStamp>
                                <uix:contents>
                                  <uix:styledText textBinding="EntityType"/>
                                  <uix:styledText textBinding="CumulativeTime"/>
                                  <uix:include nodeBinding="CumulativeChart"/>
                                </uix:contents>
                              </uix:hGrid>
                            </uix:rowLayout>
                            <uix:rowLayout hAlign="right">
                              <uix:cellFormat hAlign="right">
                                <uix:include nodeBinding="tableLegend"/>
                              </uix:cellFormat>
                            </uix:rowLayout>
                          </uix:contents>
                        </uix:tableLayout>
                      </uix:contents>
                    </uix:header>
                  </uix:contents>
                </uix:hideShowHeader>
              </uix:contents>
            </uix:stackLayout>
          </uix:form>
        </uix:dataScope>
      </uix:flowLayout>
    </uix:case>
  </uix:switcher>
</uix:buildTree>
<%@ include file="/monitoring/website/txn/txnGrpStepPerfTemplate.jspf"%>
