<%--

/* $Header: txnHomepage.jsp 27-mar-2007.10:13:30 andyao Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   The Service Test Home Page

   NOTES
    None 

   MODIFIED      (MM/DD/YY)
    andyao        12/21/06 - Added copyright information
 */

/**
 *  @version $Header: txnHomepage.jsp 27-mar-2007.10:13:30 andyao Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcPageSegmentTypes"%>
<%@ page import="oracle.sysman.eml.PageSegmentTypes"%>

<uix:buildTree nodeID="pagePlugin">
  <uix:renderingContext id="renderingContext">
    <uix:dataScope currentDataBinding="viewModel@servletRequest">
      <uix:bundle name="gensvc" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
      <uix:bundle name="common" class="oracle.sysman.resources.CommonResourceBundle"/>

      <uix:tableLayout width="100%" borderWidth="0">
        <uix:rowLayout hAlign="right" vAlign="top" >
          <uix:cellFormat columnSpan="2">
            <uix:spacer width="5"/>
            <uix:button textBinding="verifyTestButtonLabel" destinationBinding="verifyTestButtonDestination"/>
            <uix:switcher childNameBinding="disableRecorder">
              <uix:case name="false">      
                <uix:flowLayout>
                <uix:spacer width="5"/>
                <uix:button textBinding="playButtonLabel" destinationBinding="playButtonDestination"/>
                <uix:spacer width="5" renderedBinding="playWithTraceButtonVisibility"/>
                <uix:button textBinding="playWithTraceButtonLabel" renderedBinding="playWithTraceButtonVisibility" destinationBinding="playWithTraceButtonDestination"/>
                <uix:spacer width="5" renderedBinding="playWithTraceButtonVisibility"/>
              </uix:flowLayout>
              </uix:case>
            </uix:switcher>
	   <uix:switcher childNameBinding="disableSiebelplayback">
                <uix:case name="false">
                <uix:flowLayout>
                <uix:spacer width="5"/>
                        <uix:button textBinding="playButtonLabel" destinationBinding="siebelButtonDestination"/>
              </uix:flowLayout>
              </uix:case>
            </uix:switcher>

          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout width="80%">
          <uix:cellFormat vAlign="top">
            <uix:header textBinding="GENERAL@sdkMsg">
              <uix:tableLayout>
                <uix:rowLayout>
                  <uix:image sourceBinding="txnStatusImage@servletRequest" shortDescBinding="txnStatusImageDesc@servletRequest" /> 

                  <uix:labeledFieldLayout labelWidth="30%" fieldWidth="70%">
                    <%
                    java.util.List metricsList = (java.util.List)request.getAttribute("generalMetrics");
                    if (metricsList != null) 
                    {
                    for (java.util.Iterator i=metricsList.iterator(); i.hasNext();  )
                    {
                    java.util.Map map = (Map)i.next();
                    String name = (String)map.get("_name");
                    String value = (String)map.get("_value");
                    String link = (String)map.get("_link");
                    String style = (String)map.get("_style");
                    if (name == null) continue;

                    if (link == null) 
                    {
                    %>
                    <uix:messageStyledText prompt="<%=name%>" text="<%=value%>" styleClass="<%=style%>"/>
                    <%
                    } 
                    else 
                    {
                    %>
                    <uix:messageStyledText prompt="<%=name%>" text="<%=value%>" destination="<%=link%>" styleClass="<%=style%>"/>
                    <%
                    }
                    }
                    }
                    %>
                    <uix:switcher childNameBinding="isKeyTest@servletRequest">
                      <uix:case name="true">
                        <uix:messageStyledText promptBinding="IS_KEY_TEST@gensvc" textBinding="YES@common" styleClass="OraDataText"/>
                      </uix:case>
                      <uix:case name="false">
                        <uix:messageStyledText promptBinding="IS_KEY_TEST@gensvc" textBinding="NO@common" styleClass="OraDataText"/>
                      </uix:case>
                    </uix:switcher>
                  </uix:labeledFieldLayout>
                </uix:rowLayout>
              </uix:tableLayout>
            </uix:header>
          </uix:cellFormat>

          <uix:cellFormat rowSpan="2" vAlign="top" width="50%">
            <uix:header textBinding="PERFORMANCE@gensvc">
              <uix:ref refID="monitoring/website/genericChart"/>
            </uix:header>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout>
          <uix:cellFormat vAlign="top" width="50%">
            <uix:form method="POST">
              <uix:header textBinding="TEST_STATUS@gensvc">
                <uix:ref refID="<%=GenSvcPageSegmentTypes.GENSVC_TEST_BEACONS%>"/>
              </uix:header>
            </uix:form>
          </uix:cellFormat>
        </uix:rowLayout>

        <uix:rowLayout hAlign="left" width="100%">
          <uix:cellFormat width="100%" columnSpan="2">
            <uix:ref refID="<%=PageSegmentTypes.TXN_ALERTS_SEGMENT%>"/>
          </uix:cellFormat>
        </uix:rowLayout>

      </uix:tableLayout>
    </uix:dataScope>
  </uix:renderingContext>
</uix:buildTree>
<%@ include file="/monitoring/website/txn/txnHomePageTemplate.jspf"%>
