<%--

/* $Header: txnPlay.jsp 10-jul-2007.10:40:44 rgraham Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   The new DHTML Web Transaction playback (10.2.0.4)

   NOTES

   MODIFIED      (MM/DD/YY)
    rgraham       07/10/07 - 
    andyao        12/21/06 - new DHTML Web Transaction Recorder
    andyao        03/25/05 - hide warning when no step 
    mvajapey      03/07/05 - 
    andyao        01/07/05 - remove html comment 
    andyao        12/23/04 - fix page header 
    andyao        11/24/04 - fix ctx type 
    andyao        11/10/04 - add service wizard train 
    pmadyalk      09/14/04 - Txn R2 Changes 
    pmadyalk      08/26/04 - 
    dbrown        05/28/03 - Set charset to utf-8.
    snakai        02/03/03 - hide control
    rmarripa      12/18/02 - change recorder size
    asawant       06/24/02 - Moving ref from jsp to jspf
    rmarripa      05/28/02 - add script to close the playback controller.
    njuillar      05/17/02 - Added form values for target name/type
    rmarripa      05/03/02 - change text.
    asawant       04/30/02 - history section added
 */

/**
 *  @version $Header: txnPlay.jsp 10-jul-2007.10:40:44 rgraham Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import='oracle.sysman.eml.webapp.e2e.data.TraceConstants'%>
<%@ page import='oracle.cabo.ui.UIConstants'%>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:bundle name="website"
    class="oracle.sysman.eml.webapp.WebappMsg"/>

  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest">
        <uix:rawText> 
          <meta http-equiv="Cache-Control" content="max-age=0"></meta>
        </uix:rawText> 
        <uix:script source="js/recorder_all.js"></uix:script>
        <uix:script source="js/TxnPlayController.js"></uix:script>
      <script>
      </script>

      </uix:head>
    </uix:metaContainer>
    <uix:body onLoad="if (window.txn) { window.txn.play(); }" onUnload="if (window.txn) { window.txn.abort(); }">

      <uix:form name="mainForm" method="POST">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:dataScope currentDataBinding="@servletRequest">

            <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf" %>

            <%@ include file="/gensvc/message.jspf" %>

            <uix:header textBinding="pageHeader">

              <uix:formValue name="dmsData" value="" />
              <uix:formValue name="requestData" value="" />
              <uix:formValue name="<%=TraceConstants.PB_RESULTS_DATA_PARAM%>" value=""/>
              <uix:formValue name="<%=TraceConstants.TXN_ID_PARAM%>" valueBinding="txnID"/>          

              <uix:formValue name="traceMode" id="traceMode" valueBinding="traceMode"/>
              <uix:formValue name="postURL" id="postURL" valueBinding="postURL"/>
              <uix:formValue name="getURL" id="getURL" valueBinding="getURL"/>
              <uix:formValue name="method" id="method" valueBinding="method"/>
              <uix:formValue name="errorURL" valueBinding="errorURL"/>
              <uix:formValue name="warnURL"  valueBinding="warnURL"/>
              <uix:formValue name="debugURL" valueBinding="debugURL"/>

 
              <uix:formValue
                name="<%=UIConstants.EVENT_PARAM%>"
                valueBinding="<%=UIConstants.EVENT_PARAM%>"/>
 
              <uix:formValue 
                name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                />

              <uix:tableLayout id="downloadMsg" width="100%">
                <uix:rowLayout hAlign="center">
                  <uix:image sourceBinding="WAIT_ICON" shortDescBinding="TXN_RECORDER_PREINSTALL_WAIT@websiteResourceBundle" textBinding="TXN_RECORDER_PREINSTALL_WAIT@websiteResourceBundle"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="TXN_RECORDER_PREINSTALL_WAIT@websiteResourceBundle"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:rawText>
                <%@ include file="lib/OraDHTMLRec.htm" %>
              </uix:rawText>

              <uix:rawText>
                <%@ include file="lib/OraBcnTxnRec.htm" %>
              </uix:rawText>

              <uix:script text="window.txn=new TxnPlayController(); hide(document.getElementById('downloadMsg'));"/>

            </uix:header>
          </uix:dataScope>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

