<%--

/* $Header: txnRecord.jsp 05-feb-2007.14:04:38 andyao Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
   The Web Transaction recording page.

   NOTES

   MODIFIED    (MM/DD/YY)
    andyao        11/13/06 - refactor recording UI
    andyao        03/25/05 - hide warning when no step 
    mvajapey      03/07/05 - 
    andyao        01/07/05 - remove html comment 
    andyao        12/23/04 - fix page header 
    andyao        11/24/04 - fix ctx type 
    andyao        11/10/04 - add service wizard train 
    pmadyalk      09/14/04 - Txn R2 Changes 
    pmadyalk      08/26/04 - 
    dbrown        05/28/03 - Set charset to utf-8.
    snakai        02/03/03 - hide control
    rmarripa      12/18/02 - change recorder size
    asawant       06/24/02 - Moving ref from jsp to jspf
    rmarripa      05/28/02 - add script to close the playback controller.
    njuillar      05/17/02 - Added form values for target name/type
    rmarripa      05/03/02 - change text.
    asawant       04/30/02 - history section added
 */

/**
 *  @version $Header: txnRecord.jsp 05-feb-2007.14:04:38 andyao Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

 --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.chronos.WebsiteConstants"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:bundle name="common"
    class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
    class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="websiteResourceBundle"
    class="oracle.sysman.resources.website.WebsiteResourceBundle"/>

  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest">
        <uix:rawText> 
          <meta http-equiv="Cache-Control" content="max-age=0"></meta>
        </uix:rawText> 
        <uix:script source="js/recorder_all.js"></uix:script>
        <uix:script source="js/TxnRecordController.js"></uix:script>

      </uix:head>
    </uix:metaContainer>
    <uix:body onUnload="if (window.txn) { window.txn.abort();}">
      <uix:form name="mainForm" method="POST">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:dataScope currentDataBinding="@servletRequest">
            <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf" %>

            <uix:messageBox rendered="false"
              messageType="warning" messageBinding="TXN_REC_OVERWRITE_MGS@websiteResourceBundle">
            </uix:messageBox>

            <%@ include file="/gensvc/message.jspf" %>
            <uix:header textBinding="pageHeader">

              <uix:formValue name="txnName" valueBinding="txnName"/> 
              <uix:formValue name="postURL" valueBinding="postURL"/>
              <uix:formValue name="errorURL" valueBinding="errorURL"/>
              <uix:formValue name="warnURL"  valueBinding="warnURL"/>
              <uix:formValue name="debugURL" valueBinding="debugURL"/>

              <uix:formValue
                name="<%=Constants.EVENT%>"
                value="<%=WebsiteConstants.USER_ACTION_RECORD_CONTINUE_EVENT%>"/>

              <uix:formValue 
                name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                />


              <%-- debugging --%>
              <uix:tableLayout borderWidth="3" width="100%" rendered="false">
                <uix:rowLayout>
                  <uix:cellFormat vAlign="top">
                    <uix:stackLayout>
                      <uix:textInput id="txnStartingUrl"/>
                      <uix:flowLayout>

                        <uix:button text="Expand All" accessKey="x" id="debugExpand"   onClick="deb.toggleExpandAll()"/>
                        <uix:button text="Collapse All"             id="debugCollapse" onClick="deb.toggleExpandAll()"/>
                        <uix:flowLayout id="debugLocks"/>

                        <uix:checkBox id="debugWriteToFileCheckBox" text="Write to File" onClick="deb.toggleWriteToFile()"/>
                        <uix:textInput id="debugFileName" name="debugFileName"/> 

                        <uix:button id="debugClearBtn" onClick="deb.clear()" text="Clear"/>
                      </uix:flowLayout>

                      <uix:flowLayout>
                        <uix:checkBox onClick="debug.toggleEnableDisable()"    text="Debug" checked="false"/>
                        <uix:checkBox onClick="stdout.toggleEnableDisable()"   text="Stdout" checked="true"/>
                        <uix:checkBox onClick="stderr.toggleEnableDisable()"   text="Stderr" checked="true"/>
                      </uix:flowLayout>
                      <uix:flowLayout id="data"/>
                    </uix:stackLayout>

                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>
              <%-- debugging --%>

              <uix:tableLayout id="downloadMsg" width="100%">
                <uix:rowLayout hAlign="center">
                  <uix:image sourceBinding="WAIT_ICON" shortDescBinding="TXN_RECORDER_PREINSTALL_WAIT@websiteResourceBundle" textBinding="TXN_RECORDER_PREINSTALL_WAIT@websiteResourceBundle"/>
                </uix:rowLayout>

                <uix:rowLayout hAlign="center">
                  <uix:styledText styleClass="OraInstructionText"
                    textBinding="TXN_RECORDER_PREINSTALL_WAIT@websiteResourceBundle"/>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:contentContainer width="100%" id="instruction">
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="TXN_REC_INST_INTRO@websiteResourceBundle" />
                <uix:spacer height="5"/>
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="TXN_REC_INST_STEP_1@websiteResourceBundle" />
                <uix:spacer height="5"/>
                <uix:styledText styleClass="OraInstructionText"
                  textBinding="TXN_REC_INST_STEP_2@websiteResourceBundle" />
              </uix:contentContainer>
              <uix:script text="hide(document.getElementById('instruction'));"/>

              <uix:spacer height="10"/>
              <uix:tip id="tip">
                <uix:stackLayout>
                  <uix:text textBinding="TXN_RECORDER_ADDRESS_BAR@websiteResourceBundle"/>
                  <uix:text textBinding="TXN_RECORDER_BACK_BUTTON@websiteResourceBundle"/>
                  <uix:text textBinding="TXN_RECORDER_LOG_OUT@websiteResourceBundle"/>
                </uix:stackLayout>
              </uix:tip>
              <uix:script text="hide(document.getElementById('tip'));"/>

            </uix:header>

            <uix:header textBinding="TXN_RECORDER_LOGGING@websiteResourceBundle" id="logging">
              <uix:tip>
                <uix:text textBinding="TXN_RECORDER_LOGGING_TEXT@websiteResourceBundle"/> 
              </uix:tip>
              <uix:flowLayout id="debugData" styleClass="OraInstructionText"/>
            </uix:header>
              <uix:script text="hide(document.getElementById('logging'));"/>


            <uix:rawText>
              <%@ include file="lib/OraDHTMLRec.htm" %>
            </uix:rawText>

 
          </uix:dataScope>

          <uix:contentFooter>
            <uix:dataScope currentDataBinding="@servletRequest">
              <uix:flowLayout>
                <uix:contents>

                  <uix:submitButton 
                    textBinding="CANCEL@common"
                    name="<%=Constants.EVENT%>"
                    value="<%=WebsiteConstants.CANCEL_RECORDING_EVENT%>" />

                  <uix:spacer width="10"/>

                  <uix:button textBinding="RECORD@websiteResourceBundle" accessKey="r" id="txnRecord" onClick="txn.start()"/>
                  <uix:button textBinding="RECORD_AGAIN@websiteResourceBundle" accessKey="r" id="txnRecordAgain" onClick="txn.abort();txn.start()"/>

                  <uix:spacer width="10"/>

                  <uix:button textBinding="CONTINUE@common"   
                    accessKey="s" 
                    id="txnStop" 
                    onClick="txn.stop()" 
                    shortDescBinding="CONTINUE@common"
                    />

                  <uix:button textBinding="CONTINUE@common"   
                    id="txnStopDisabled" 
                    disabled="true"  
                    shortDesc="CONTINUE@common"
                    />

                </uix:contents>
                <uix:script text="window.txn=new TxnRecordController();"/>
             </uix:flowLayout>
            </uix:dataScope>

          </uix:contentFooter>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

