<%--

/* $Header: txnRecordSucString.jsp 18-jul-2007.13:48:17 rgraham Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    rgraham       07/18/07 - increase success string text field size
    andyao        11/13/06 - refactor recording UI
    andyao        03/25/05 - hide warning when no step 
    mvajapey      03/07/05 - 
    andyao        01/07/05 - remove html comment 
    andyao        12/23/04 - fix page header 
    andyao        11/24/04 - fix ctx type 
    andyao        11/10/04 - add service wizard train 
    pmadyalk      09/14/04 - Txn R2 Changes 
    pmadyalk      08/26/04 - 
    dbrown        05/28/03 - Set charset to utf-8.
    snakai        02/03/03 - hide control
    rmarripa      12/18/02 - change recorder size
    asawant       06/24/02 - Moving ref from jsp to jspf
    rmarripa      05/28/02 - add script to close the playback controller.
    njuillar      05/17/02 - Added form values for target name/type
    rmarripa      05/03/02 - change text.
    asawant       04/30/02 - history section added
 */

/**
 *  @version $Header: txnRecordSucString.jsp 18-jul-2007.13:48:17 rgraham Exp $
 *  @author  rmarripa
 *  @since   release specific (what release of product did this appear in)
 */

 --%>
<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oemjsp" %>
<%@ taglib uri="http://xmlns.oracle.com/oem" prefix="oem" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.chronos.WebsiteConstants"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.emSDK.eml.EmlConstants"%>
<%@ include file="/oemNoscript.jspf" %>

<uix:renderingContext id="renderingContext">
  <oemjsp:setURLEncoder id="renderingContext"/>
  <uix:bundle name="common"
    class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
    class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="websiteResourceBundle"
    class="oracle.sysman.resources.website.WebsiteResourceBundle"/>

  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="_emSDK_PageTitle@servletRequest">
        <uix:rawText> 
          <meta http-equiv="Cache-Control" content="max-age=0"></meta>
        </uix:rawText> 
        <uix:script source="js/recorder_all.js"></uix:script>
        <uix:script source="js/TxnRecordController.js"></uix:script>

      </uix:head>
    </uix:metaContainer>
    <uix:body>
      <uix:form name="mainForm" method="POST">
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:dataScope currentDataBinding="@servletRequest">
            <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf" %>

            <uix:header textBinding="pageHeader">

              <uix:tableLayout width="100%" borderWidth="0">
                <uix:rowLayout>
                  <uix:cellFormat>
                    <uix:styledText styleClass="OraInstructionText"
                      textBinding="TXN_RECORDER_SUCCESS_STRINGS_SUGGESTION_MSG@websiteResourceBundle" />
                  </uix:cellFormat>
                  <uix:cellFormat hAlign="right" vAlign="top">
                  <uix:submitButton 
                    textBinding="CONTINUE@common"   
                    name="<%=Constants.EVENT%>"
                    value="<%=WebsiteConstants.USER_ACTION_RECORD_CONTINUE_EVENT%>"
                    /> 
                </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>


              <uix:formValue
                name="<%=Constants.EVENT%>"
                value="<%=WebsiteConstants.USER_ACTION_RECORD_CONTINUE_EVENT%>"/>

              <uix:formValue 
                name="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                valueBinding="<%=EmlConstants.RETURN_URL_PAGE_PROPERTY%>"
                />

              <uix:stackLayout>
                <uix:formValue
                  name="suggestionShown"
                  value="true"/>

                <uix:spacer height="10"/>
                <uix:table
                  columnHeaderDataBinding="columnHeaderData"
                  tableDataBinding="sucStringsTable"
                  name="sucStringsTable"
                  width="80%"
                  unvalidated="true"
                  summaryBinding="TXN_RECORDER_SUCCESS_STRINGS_SUGGESTION@websiteResourceBundle"
                  >
                  <uix:tableFormat tableBanding="rowBanding"/>
                  <uix:tableSelection>
                    <uix:multipleSelection 
                      selected="false"
                      textBinding="value"
                      shortDescBinding="value">
                    </uix:multipleSelection>
                  </uix:tableSelection>

                  <uix:columnHeaderStamp>
                    <uix:sortableHeader
                      textBinding="text"
                      />
                  </uix:columnHeaderStamp>

                  <uix:contents>
                    <uix:text textBinding="name"/>
                    <uix:textInput textBinding="value" name="value" columns="50"/>
                    <uix:formValue name="name" valueBinding="name"/>
                  </uix:contents>
                </uix:table>
              </uix:stackLayout>

            </uix:header>
          </uix:dataScope>

          <uix:contentFooter>
            <uix:flowLayout>
              <uix:contents>

                <uix:submitButton 
                  textBinding="CONTINUE@common"   
                  name="<%=Constants.EVENT%>"
                  value="<%=WebsiteConstants.USER_ACTION_RECORD_CONTINUE_EVENT%>"
                  /> 

              </uix:contents>
            </uix:flowLayout>
          </uix:contentFooter>

        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>

