<%@ page contentType="text/html; charset=UTF-8"%>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<uix:buildTree nodeID="pagePlugin">
  <uix:switcher childNameBinding="hasErrors@servletRequest">
    <uix:case name="false">
      <uix:flowLayout>
        <uix:dataScope currentDataBinding="_DATA_SOURCE@servletRequest">
          <uix:bundle name="webappMsg" class="oracle.sysman.eml.webapp.WebappMsg"/>
          <uix:bundle name="GenSvcRB" class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>
          <uix:bundle name="MntrRB" class="oracle.sysman.resources.MntrResourceBundle"/>
          <uix:bundle name="WebsiteRB" class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
          <uix:form name="OneBigForm" method="POST">
            <uix:formValue nameBinding="ITEM_ID" valueBinding="itemId"/>
            <uix:formValue nameBinding="REFRESH_UIBEAN" valueBinding="NO_REFRESH"/>
            <uix:stackLayout>
              <uix:contents>
                <uix:spacer height="10"/>
                <uix:rowLayout width="100%">
                  <uix:contents>
                    <uix:cellFormat hAlign="right">
                      <uix:styledText textBinding="VIEWDATA_TEXT@sdkMsg" styleClass="OraPromptText"/>
                    </uix:cellFormat>
                    <uix:cellFormat vAlign="top" hAlign="right" width="5"/>
                    <uix:cellFormat vAlign="top" hAlign="right" width="50">
                      <uix:choice nameBinding="CHANGE_PERIOD_EVENT" id="PeriodChange" onChange="submitForm('OneBigForm',0,{'event':'ChangePeriod'}); return false;">
                        <uix:contents>
                          <uix:option textBinding="REAL_TIME@MntrRB" valueBinding="PCURRENT" selectedBinding="viewByCurrent"/>
                          <uix:option textBinding="LAST_HOUR@MntrRB" valueBinding="P1H" selectedBinding="viewByHour"/>
                          <uix:option textBinding="LAST_DAY@MntrRB" valueBinding="P24H" selectedBinding="viewByDay"/>
                          <uix:option textBinding="LAST_WEEK@MntrRB" valueBinding="P7D" selectedBinding="viewByWeek"/>
                          <uix:option textBinding="LAST_MONTH@MntrRB" valueBinding="P31D" selectedBinding="viewByMonth"/>
                        </uix:contents>
                      </uix:choice>
                    </uix:cellFormat>
                  </uix:contents>
                </uix:rowLayout>
                <uix:header textBinding="USER_ACTION_INFO@GenSvcRB">
                  <uix:contents>
                    <uix:stackLayout>
                      <uix:spacer height="8"/>
                      <uix:rowLayout>
                        <uix:styledText textBinding="USER_ACTION_URL@GenSvcRB" styleClass="OraPromptText"/>
                        <uix:spacer width="5"/>
                        <uix:styledText textBinding="stepURL" styleClass="OraInstructionTextStrong"/>
                      </uix:rowLayout>
                    </uix:stackLayout>
                  </uix:contents>
                </uix:header>
                <uix:header textBinding="UI_STRING_CHART_HEADER" renderedBinding="showHistoricChart">
                  <uix:contents>
                    <uix:rowLayout>
                      <uix:styledText styleClass="OraPromptText" textBinding="HISTORIC_CHART_BODY@GenSvcRB"/>
                      <uix:spacer height="40"/>
                    </uix:rowLayout>
                    <uix:tableLayout borderWidth="0" cellSpacing="5">
                      <uix:rowLayout>
                        <uix:cellFormat>
                          <uix:styledText textBinding="multSelectionMsg" styleClass="OraPromptText"/>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top">
                          <uix:list nameBinding="multSelectionName" multiple="true" size="3">
                            <uix:contents childDataBinding="multipleSTable">
                              <uix:option textBinding="TEXT" valueBinding="VALUE" selectedBinding="SELECTED"/>
                            </uix:contents>
                          </uix:list>
                        </uix:cellFormat>
                        <uix:spacer width="10"/>
                        <uix:cellFormat vAlign="top">
                          <uix:styledText textBinding="singSelectionMsg2" styleClass="OraPromptText"/>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top">
                          <uix:choice nameBinding="singSelectionName2" id="SingSelectListTwo">
                            <uix:contents childDataBinding="singleSTableTwo">
                              <uix:option textBinding="TEXT" valueBinding="VALUE" selectedBinding="SELECTED"/>
                            </uix:contents>
                          </uix:choice>
                        </uix:cellFormat>
                        <uix:cellFormat vAlign="top">
                          <uix:submitButton textBinding="GO@WebsiteRB" id="GraphSelectSubmit" valueBinding="CHART_PARAMS_EVENT" name="event"/>
                        </uix:cellFormat>
                      </uix:rowLayout>
                    </uix:tableLayout>
                    <uix:rowLayout renderedBinding="renderMultipleSelectionError">
                      <uix:messageText messageType="error" messageBinding="NO_MULT_SELECTION_ALLOWED@GenSvcRB"/>
                    </uix:rowLayout>
                    <uix:ref refID="monitoring/website/genericChart"/>
                  </uix:contents>
                </uix:header>
                <uix:hideShowHeader partialRenderMode="self" textBinding="UI_STRING_STEP_HDR" disclosedBinding="showHdr1" id="TXN" formSubmitted="true">
                  <uix:contents>
                    <uix:header textBinding="ALL_METRICS@WebsiteRB">
                      <uix:contents>
                        <uix:rowLayout widthBinding="pageWidth">
                          <uix:ref refID="monitoring/website/genericTable_AllMetrics"/>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:header>
                    <uix:header textBinding="CUMULATIVE_TIME@GenSvcRB">
                      <uix:contents>
                        <uix:rowLayout widthBinding="pageWidth">
                          <uix:ref refID="monitoring/website/genericTable_Cumulative"/>
                        </uix:rowLayout>
                        <uix:rowLayout width="80%">
                          <uix:cellFormat hAlign="right">
                            <uix:include nodeBinding="tableLegend"/>
                          </uix:cellFormat>
                        </uix:rowLayout>
                        <uix:rowLayout widthBinding="pageWidth">
                          <uix:spacer height="20" width="0"/>
                        </uix:rowLayout>
                      </uix:contents>
                    </uix:header>
                  </uix:contents>
                </uix:hideShowHeader>
              </uix:contents>
            </uix:stackLayout>
          </uix:form>
        </uix:dataScope>
      </uix:flowLayout>
    </uix:case>
  </uix:switcher>
</uix:buildTree>
<%@ include file="/monitoring/website/txn/txnGrpStepPerfTemplate.jspf"%>
