<%--

/* $Header: txnUserActionGroupDetails.jsp 05-jan-2007.13:54:19 rgraham Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */
    
/*
   DESCRIPTION
  
   NOTES
    <other useful comments, qualifications, etc.>
  
   MODIFIED    (MM/DD/YY)
    rgraham        01/05/07 - change cancel event to GenSvcUIConstants.CANCEL_DETAILS_EVENT
    andyao         06/13/05 - add short description
    andyao         01/31/05 - add page level text 
    andyao         01/07/05 - UI feedback 
    andyao         12/23/04 - fix header 
    andyao         11/24/04 - add support for template mode 
    andyao         11/01/04 - add wizard train 
    vjraghav       10/14/04 - Turning off Javascript validation 
    pmadyalk       09/15/04 - pmadyalk_txn_r2_1
    pmadyalk       09/14/04 - Txn R2 Changes 
    pmadyalk       09/13/04 - Txn R2 Changes 
    pmadyalk       19/08/04 - created.
 */

/**
 *  @version $Header: txnUserActionGroupDetails.jsp 05-jan-2007.13:54:19 rgraham Exp $ 
 *  @author  pmadyalk
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import="oracle.sysman.eml.chronos.data.TransactionData"%>
<%@ page import="oracle.sysman.eml.chronos.WebsiteConstants"%>
<%@ page import="oracle.sysman.eml.gensvc.GenSvcUIConstants"%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.webapp.e2e.data.TraceConstants"%>
<%@ page import="java.util.Hashtable"%>
<%@ page import="java.util.ArrayList"%>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="webappMsg" 
    class="oracle.sysman.eml.webapp.WebappMsg" />
  <uix:bundle  name="commonResourceBundle"
    class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle  name="mntrResourceBundle"
    class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="websiteResourceBundle"
    class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/enablePPR.jspf" %>
    <uix:body>
      <uix:form name="mainForm" method="POST"> 
        <uix:pageLayout>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:dataScope currentDataBinding="@servletRequest">
            <%@ include file="/gensvc/message.jspf" %>
            <%@ include file="/gensvc/admin/createServiceDetailsTrain.jspf" %>

            <% 
            TransactionData.Stepgroup stepGroup = 
            (TransactionData.Stepgroup)request.getAttribute("stepGroup");
            String stepGroupIdExist = "false";
            String stepGroupId = null;
            if(stepGroup != null)
            stepGroupId = stepGroup.getId();
            if(stepGroupId != null && stepGroupId.trim().length() > 0)
            stepGroupIdExist = "true";
            %>
            <uix:formValue name="<%=WebsiteConstants.USER_ACTION_GROUP_ID%>" value="<%=stepGroupId%>"/>

            <uix:header textBinding="pageHeader">
              <uix:tableLayout borderWidth="0" width="100%">
                <uix:rowLayout hAlign="right">
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL_BUTTON@commonResourceBundle"
                      name="<%=Constants.EVENT%>"
                      unvalidated="true"
                      value="<%=GenSvcUIConstants.CANCEL_DETAILS_EVENT%>"
                      />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                      name="<%=Constants.EVENT%>"
                      value="<%=WebsiteConstants.CONTINUE_USER_ACTION_GROUP_DETAIL_EVENT%>"
                      />
                  </uix:pageButtonBar>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:tableLayout borderWidth="0" width="100%">
                <uix:rowLayout>
                  <uix:cellFormat width="100" hAlign="left">
                    <uix:switcher childName="<%=stepGroupIdExist%>">
                      <uix:case name="false">
                        <uix:messageTextInput
                          promptBinding="NAME@commonResourceBundle"
                          name="<%=WebsiteConstants.USER_ACTION_GROUP_NAME%>"
                          id="NameID"
                          required="yes" 
                          columns="40"
                          maximumLength="64"
                          textBinding="name@stepGroup@"/> 
                      </uix:case>
                    </uix:switcher>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:spacer height="10"/>   

              <uix:header textBinding="USER_ACTIONS@websiteResourceBundle">
                <uix:styledText 
                  styleClass="OraInstructionText" 
                  textBinding="STEPGROUP_PAGE_TEXT_1@websiteResourceBundle"
                  />
                <uix:spacer height="5"/>
                <uix:contentContainer> 
                  <uix:shuttle name="<%=WebsiteConstants.SELECTED_USER_ACTION_GROUP_LIST%>"
                    leadingHeaderBinding="AVAILABLE@websiteResourceBundle"
                    trailingHeaderBinding="SELECTED@websiteResourceBundle"
                    size="15" reorderable="false" >
                    <uix:leading>
                      <uix:list shortDescBinding="AVAILABLE@websiteResourceBundle">
                        <uix:contents>
                          <%
                          ArrayList availableUserActionsList = 
                          (ArrayList) request.getAttribute("availableUserActionsList");
                          if (availableUserActionsList != null)
                          {
                          for(int i = 0 ; i < availableUserActionsList.size() ; i++)
                          {                                    
                          String name = (String)availableUserActionsList.get(i);
                          if(name == null) continue;
                          %>
                          <uix:option text="<%=name%>" selected="false" value="<%=name%>"/>
                          <%
                          }
                          } 
                          %>
                        </uix:contents>
                      </uix:list>
                    </uix:leading>
                    <uix:trailing>
                      <uix:list shortDescBinding="SELECTED@websiteResourceBundle">
                        <uix:contents>
                          <%
                          ArrayList memberUserActionsList = 
                          (ArrayList) request.getAttribute("memberUserActionsList");
                          if (memberUserActionsList != null)
                          {
                          for(int i = 0 ; i < memberUserActionsList.size() ; i++)
                          {                                    
                          String name = (String)memberUserActionsList.get(i);
                          if(name == null) continue;
                          %>
                          <uix:option text="<%=name%>" selected="false" value="<%=name%>"/>
                          <%
                          }
                          }
                          %>
                        </uix:contents>
                      </uix:list>
                    </uix:trailing>
                  </uix:shuttle>
                </uix:contentContainer>
              </uix:header>
            </uix:header>
          </uix:dataScope>
          <uix:contentFooter>
            <uix:pageButtonBar>
              <uix:submitButton textBinding="CANCEL_BUTTON@commonResourceBundle"
                name="<%=Constants.EVENT%>"
                unvalidated="true"
                value="<%=GenSvcUIConstants.CANCEL_DETAILS_EVENT%>"
                />
              <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                name="<%=Constants.EVENT%>"
                value="<%=WebsiteConstants.CONTINUE_USER_ACTION_GROUP_DETAIL_EVENT%>"
                />
            </uix:pageButtonBar>
          </uix:contentFooter>
        </uix:pageLayout>
      </uix:form>
    </uix:body>
  </uix:document>
</uix:renderingContext>
