<%--

/* $Header: txnUserActionList.jsp 29-jun-2007.00:17:24 andyao Exp $ */
/* Copyright (c) 2001, 2007, Oracle. All rights reserved.  */

/*
   DESCRIPTION
    The JSP segment for displaying a list of steps.

   NOTES
    None

   MODIFIED    (MM/DD/YY)
    andyao         06/29/07 - 
    rgraham        05/16/07 - replace play btn with individual play back mode
                              btns; remove playback mode drop-down
    andyao         05/15/07 - 
    rgraham        03/29/07 - fix rendering/disabling of play btn
    rgraham        03/23/07 - rearrange play/record buttons
    andyao         03/21/07 - fix Recorder button validation
    rgraham        03/08/07 - fix UI layout
    andyao         03/06/07 - 
    rgraham        03/02/07 - add support for user action/request simulation
                              modes
    andyao         11/09/06 - refactor web transaction UI
    andyao         07/27/05 - 
    andyao         07/24/05 - add fire partial action 
    andyao         06/13/05 - add table summary 
    andyao         04/06/05 - ui fixes
    andyao         03/24/05 - implements step tree
    andyao         01/07/05 - use tableActions 
    andyao         12/23/04 - fix alignment 
    andyao         11/24/04 - add support for template mode 
    vjraghav       10/14/04 - 
    pmadyalk       09/15/04 - pmadyalk_txn_r2_1
    pmadyalk       09/13/04 - Txn R2 Changes 
    pmadyalk       09/13/04 - created
 */

/**
 *  @version $Header: txnUserActionList.jsp 29-jun-2007.00:17:24 andyao Exp $
 *  @author  pmadyalk
 *  @since   release specific (what release of product did this appear in)
 */

--%>
<%@ page import="oracle.sysman.eml.mntr.Constants"%>
<%@ page import="oracle.sysman.eml.chronos.WebsiteConstants"%>
<%@ page import="oracle.cabo.ui.UIConstants" %>
<%@ page import="oracle.sysman.eml.chronos.data.TxnWizTableData" %>
<%@ page import="oracle.sysman.eml.gensvc.test.TestTypes" %>
<uix:dataScope>

  <uix:bundle name="commonResourceBundle"
    class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="mntrResourceBundle"
    class="oracle.sysman.resources.MntrResourceBundle"/>
  <uix:bundle name="websiteResourceBundle"
    class="oracle.sysman.resources.website.WebsiteResourceBundle"/>
  <uix:bundle name="gensvcResourceBundle"
    class="oracle.sysman.resources.eml.gensvc.GensvcResourceBundle"/>

    <uix:stackLayout>
      <uix:switcher
        childNameBinding="stepListMode@txnWizTableData@servletRequest">
        <%-- Step table for requests mode --%>
        <uix:case name="<%=WebsiteConstants.STEP_LIST_MODE_REQUESTS_KEY%>">
          <uix:table
            id="<%=WebsiteConstants.TXN_USER_ACTION_TABLE_NAME%>" 
            width="80%"
            alternateTextBinding="NO_STEP_DEFINED@websiteResourceBundle"
            tableDataBinding="tableData@txnWizTableData@servletRequest"
            columnHeaderDataBinding="columnHeaderData@txnWizTableData@servletRequest"
            partialRenderMode="self"
            blockSizeBinding="blockSize@txnWizTableData@servletRequest"
            maxValueBinding="stepTableMax@txnWizTableData@servletRequest"
            valueBinding="stepTableValue@txnWizTableData@servletRequest"
            formSubmitted="true"
            summaryBinding="USER_ACTIONS@websiteResourceBundle"
            >
            <uix:tableFormat tableBanding="rowBanding"/>
           
            <uix:tableActions>
              <uix:flowLayout>
                <uix:submitButton 
                  textBinding="CREATE@commonResourceBundle"
                  name="<%=Constants.EVENT%>" 
                  value="<%=WebsiteConstants.CREATE_USER_ACTION_EVENT%>"
                  renderedBinding="showCreateStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_CREATE_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"
                  />
              </uix:flowLayout>
            </uix:tableActions>
           
            <uix:columnHeaderStamp>
              <uix:sortableHeader
                textBinding="text"/>
            </uix:columnHeaderStamp>

              <uix:contents>
                <uix:switcher
                  childNameBinding="isNameEditable@">
                  <uix:case name="true">
                    <uix:flowLayout>
                      <uix:textInput 
                        columns="40"
                        maximumLength="64"
                        name="useActionName"
                        textBinding="name@" renderedBinding="isTxnNotViewMode@txnWizTableData@servletRequest" />
                      <uix:styledText textBinding="name@" renderedBinding="isTxnViewMode@txnWizTableData@servletRequest"/>
                    </uix:flowLayout>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText textBinding="name@"/>
                  </uix:case>
                </uix:switcher>
                <uix:styledText 
                  textBinding="truncatedUrl@" 
                  shortDescBinding="url@"/>
                <uix:styledText 
                  textBinding="httpMethod@"/>
                <uix:styledText 
                  textBinding="requestMode@"/>
                <uix:formValue name="id" valueBinding="id@"/>
                <uix:formValue name="isNameEditable" valueBinding="isNameEditable@"/>
                <uix:formValue name="nameHidden"  valueBinding="name@"/>
              </uix:contents>

            <uix:tableSelection>
              <uix:singleSelection 
                selectedIndexBinding="selectedStepIndex@txnWizTableData@servletRequest" 
                renderedBinding="isTxnNotViewMode@txnWizTableData@servletRequest"
                shortDescBinding="name"
                >
                <uix:submitButton 
                  textBinding="INSERT_BEFORE@websiteResourceBundle" 
                  name="<%=Constants.EVENT%>" 
                  value="<%=WebsiteConstants.INSERT_BEFORE_USER_ACTION_DETAIL_EVENT%>"
                  renderedBinding="showInsertStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_INSERT_BEFORE_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="INSERT_AFTER@websiteResourceBundle" 
                  name="<%=Constants.EVENT%>" 
                  value="<%=WebsiteConstants.INSERT_AFTER_USER_ACTION_DETAIL_EVENT%>"
                  renderedBinding="showInsertStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_INSERT_AFTER_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="MOVE_UP@websiteResourceBundle" 
                  id="<%=WebsiteConstants.MOVE_UP_USER_ACTIONDETAIL_EVENT%>"
                  renderedBinding="showMoveStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_MOVE_UP_BTN_DESC@websiteResourceBundle"
                  primaryClientActionBinding="MOVE_STEP_UP_ACTION@txnWizTableData@servletRequest"        
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="MOVE_DOWN@websiteResourceBundle" 
                  id="<%=WebsiteConstants.MOVE_DOWN_USER_ACTIONDETAIL_EVENT%>"
                  renderedBinding="showMoveStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_MOVE_DOWN_BTN_DESC@websiteResourceBundle"
                  primaryClientActionBinding="MOVE_STEP_DN_ACTION@txnWizTableData@servletRequest"        
                  unvalidated="true"/> 
                <%-- edit button should always be shown --%>
                <uix:submitButton 
                  textBinding="EDIT@commonResourceBundle" 
                  renderedBinding="showEditStepButton@txnWizTableData@servletRequest"
                  name="<%=Constants.EVENT%>"
                  value="<%=WebsiteConstants.EDIT_USER_ACTION_DETAIL_EVENT%>"
                  shortDescBinding="TXN_STEP_EDIT_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="DELETE@commonResourceBundle" 
                  id="<%=WebsiteConstants.DELETE_USER_ACTION_DETAIL_EVENT%>"
                  renderedBinding="showDeleteStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_DELETE_BTN_DESC@websiteResourceBundle"
                  primaryClientActionBinding="DEL_STEP_ACTION@txnWizTableData@servletRequest"        
                  unvalidated="true"/> 
              </uix:singleSelection>
            </uix:tableSelection>
          </uix:table>
        </uix:case>
          
        <%-- Step table for actions mode --%>
        <uix:case name="<%=WebsiteConstants.STEP_LIST_MODE_ACTIONS_KEY%>">
          <uix:table
            id="<%=WebsiteConstants.TXN_USER_ACTION_TABLE_NAME%>" 
            width="80%"
            alternateTextBinding="NO_STEP_DEFINED@websiteResourceBundle"
            tableDataBinding="tableData@txnWizTableData@servletRequest"
            columnHeaderDataBinding="columnHeaderData@txnWizTableData@servletRequest"
            partialRenderMode="self"
            blockSizeBinding="blockSize@txnWizTableData@servletRequest"
            maxValueBinding="stepTableMax@txnWizTableData@servletRequest"
            valueBinding="stepTableValue@txnWizTableData@servletRequest"
            formSubmitted="true"
            summaryBinding="USER_ACTIONS@websiteResourceBundle"
            >
            <uix:tableFormat tableBanding="rowBanding"/>
            
            <uix:tableActions>
              <uix:flowLayout>
                <uix:submitButton 
                  textBinding="CREATE@commonResourceBundle"
                  name="<%=Constants.EVENT%>" 
                  value="<%=WebsiteConstants.CREATE_USER_ACTION_EVENT%>"
                  renderedBinding="showCreateStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_CREATE_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"
                  />
              </uix:flowLayout>
            </uix:tableActions>
           
            <uix:columnHeaderStamp>
              <uix:sortableHeader
                textBinding="text"/>
            </uix:columnHeaderStamp>

              <uix:contents>
                <uix:switcher
                  childNameBinding="isNameEditable@">
                  <uix:case name="true">
                    <uix:flowLayout>
                      <uix:textInput 
                        columns="40"
                        maximumLength="64"
                        name="useActionName"
                        textBinding="name@" renderedBinding="isTxnNotViewMode@txnWizTableData@servletRequest" />
                      <uix:styledText textBinding="name@" renderedBinding="isTxnViewMode@txnWizTableData@servletRequest"/>
                    </uix:flowLayout>
                  </uix:case>
                  <uix:case name="false">
                    <uix:styledText textBinding="name@"/>
                  </uix:case>
                </uix:switcher>
                <uix:rawText 
                  textBinding="actions@"/> 
                <uix:formValue name="id" valueBinding="id@"/>
                <uix:formValue name="isNameEditable" valueBinding="isNameEditable@"/>
                <uix:formValue name="nameHidden"  valueBinding="name@"/>
              </uix:contents>

            <uix:tableSelection>
              <uix:singleSelection 
                selectedIndexBinding="selectedStepIndex@txnWizTableData@servletRequest" 
                renderedBinding="isTxnNotViewMode@txnWizTableData@servletRequest"
                shortDescBinding="name"
                >
                <uix:submitButton 
                  textBinding="INSERT_BEFORE@websiteResourceBundle" 
                  name="<%=Constants.EVENT%>" 
                  value="<%=WebsiteConstants.INSERT_BEFORE_USER_ACTION_DETAIL_EVENT%>"
                  renderedBinding="showInsertStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_INSERT_BEFORE_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="INSERT_AFTER@websiteResourceBundle" 
                  name="<%=Constants.EVENT%>" 
                  value="<%=WebsiteConstants.INSERT_AFTER_USER_ACTION_DETAIL_EVENT%>"
                  renderedBinding="showInsertStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_INSERT_AFTER_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="MOVE_UP@websiteResourceBundle" 
                  id="<%=WebsiteConstants.MOVE_UP_USER_ACTIONDETAIL_EVENT%>"
                  renderedBinding="showMoveStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_MOVE_UP_BTN_DESC@websiteResourceBundle"
                  primaryClientActionBinding="MOVE_STEP_UP_ACTION@txnWizTableData@servletRequest"        
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="MOVE_DOWN@websiteResourceBundle" 
                  id="<%=WebsiteConstants.MOVE_DOWN_USER_ACTIONDETAIL_EVENT%>"
                  renderedBinding="showMoveStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_MOVE_DOWN_BTN_DESC@websiteResourceBundle"
                  primaryClientActionBinding="MOVE_STEP_DN_ACTION@txnWizTableData@servletRequest"        
                  unvalidated="true"/> 
                <%-- edit button should always be shown --%>
                <uix:submitButton 
                  textBinding="EDIT@commonResourceBundle" 
                  renderedBinding="showEditStepButton@txnWizTableData@servletRequest"
                  name="<%=Constants.EVENT%>"
                  value="<%=WebsiteConstants.EDIT_USER_ACTION_DETAIL_EVENT%>"
                  shortDescBinding="TXN_STEP_EDIT_BTN_DESC@websiteResourceBundle"
                  unvalidated="true"/> 
                <uix:submitButton 
                  textBinding="DELETE@commonResourceBundle" 
                  id="<%=WebsiteConstants.DELETE_USER_ACTION_DETAIL_EVENT%>"
                  renderedBinding="showDeleteStepButton@txnWizTableData@servletRequest"
                  shortDescBinding="TXN_STEP_DELETE_BTN_DESC@websiteResourceBundle"
                  primaryClientActionBinding="DEL_STEP_ACTION@txnWizTableData@servletRequest"        
                  unvalidated="true"/> 
              </uix:singleSelection>
            </uix:tableSelection>
          </uix:table>
        </uix:case>
      </uix:switcher>

    </uix:stackLayout>

</uix:dataScope>
