<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
  xmlns="template"
  version="1.0">

  <xsl:output method="xml" omit-xml-declaration="yes"/>

  <xsl:template match="/transaction">
    <transaction-template>
      <variables/>
      <transactions>
        <mgmt_bcn_transaction>
          <mgmt_bcn_txn_with_props>
            <!-- FIXME change name -->
            <mgmt_bcn_txn is_representative="false" tgt_tz="">
              <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
              <xsl:attribute name="txn_type"><xsl:value-of select="@type"/></xsl:attribute>
            </mgmt_bcn_txn>
            <properties>
              <property name="UserAgent" string_part="0.0" string_value="Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1) OracleEMAgentURLTiming/3.0" prop_type="1" encrypt="false"/>
              <property name="retryInterval" string_part="0.0" num_value="5000.0" prop_type="2" encrypt="false"/>
              <property name="numThreads" string_part="0.0" num_value="4.0" prop_type="2" encrypt="false"/>
              <property name="AcceptLanguage" string_part="0.0" string_value="en" prop_type="1" encrypt="false"/>
              <property name="timeout" string_part="0.0" num_value="300000.0" prop_type="2" encrypt="false"/>
              <property name="connectionTimeout" string_part="0.0" num_value="120000.0" prop_type="2" encrypt="false"/>
              <property name="Collection Interval" string_part="0.0" num_value="5.0" prop_type="2" encrypt="false"/>
              <property name="retries" string_part="0.0" num_value="1.0" prop_type="2" encrypt="false"/>
              <property name="readTimeout" string_part="0.0" num_value="120000.0" prop_type="2" encrypt="false"/>
              <property name="granularity" string_part="0.0" string_value="transaction" prop_type="1" encrypt="false"/>
              <property name="recVersion"  string_part="0.0" string_value="10.2.0.4"    prop_type="1" encrypt="false"/>
              <xsl:choose>
                <xsl:when test="@session_parameters">
                  <property name="session_parameters" string_part="0.0" prop_type="1" encrypt="false">
                    <xsl:attribute name="string_value"><xsl:value-of select="@session_parameters"/></xsl:attribute>
                  </property>
                </xsl:when>
              </xsl:choose>
            </properties>
            <per_bcn_properties/>
          </mgmt_bcn_txn_with_props>
          <steps_defn_with_props>
            <xsl:apply-templates select="BN"/>
          </steps_defn_with_props>
          <txn_thresholds/>
          <step_thresholds/>
          <stepgroup_thresholds/>
        </mgmt_bcn_transaction>
      </transactions>
    </transaction-template>
  </xsl:template>

  <xsl:template match="BN">
    <xsl:call-template name="getStep">
      <xsl:with-param name="type" select="/transaction/@type"/>
    </xsl:call-template>
    <xsl:apply-templates select="BN"/>
  </xsl:template>

  <xsl:template match="url|headers|charset|regex|regmd|ignore_input_hint|hidden_input_hint|actions|SuccessString|sensitive_values|nonsensitive_values|query_param|is_form_submit">
    <property string_part="0.0" prop_type="1" encrypt="false">
      <xsl:attribute name="name"><xsl:call-template name="getPropertyName"><xsl:with-param name="name" select="name()"/></xsl:call-template></xsl:attribute>
      <xsl:attribute name="string_value"><xsl:value-of select="@value"/></xsl:attribute>
    </property>
  </xsl:template>

  <xsl:template match="windowIndex">
    <property string_part="0.0" prop_type="2" encrypt="false">
      <xsl:attribute name="name"><xsl:call-template name="getPropertyName"><xsl:with-param name="name" select="name()"/></xsl:call-template></xsl:attribute>
      <xsl:attribute name="num_value"><xsl:value-of select="@value"/></xsl:attribute>
    </property>
  </xsl:template>

  <xsl:template name="getPropertyName">
    <xsl:param name="name" />
    <xsl:choose>
      <xsl:when test="$name='regex'">variables</xsl:when>
      <xsl:when test="$name='regmd'">variablesModes</xsl:when>
      <xsl:otherwise><xsl:value-of select="$name"/></xsl:otherwise>
    </xsl:choose>
  </xsl:template>

  <!-- 
  prop_type:  
  1 = String 
  2 = Number

  req_mode: 
  1 = HTTP_REQ_USER_ACTION
  2 = HTTP_REQ_302_REDIRECT
  3 = HTTP_REQ_META_EQUIV_REDIRECT
  4 = HTTP_REQ_SCRIPT_REDIRECT
  5 = HTTP_REQ_ONLOAD_SUBMIT
  6 = HTTP_REQ_DEPENDENT_FRAME
  7 = HTTP_REQ_UNKNOWN_MODE
  -->

  <xsl:template name="getStep">
    <xsl:param name="type" />
    <mgmt_bcn_step_with_props>
      <mgmt_bcn_step>
        <xsl:attribute name="name"><xsl:value-of select="@stepName"/></xsl:attribute>
        <xsl:attribute name="step_type"><xsl:value-of select="$type"/></xsl:attribute>
        <xsl:attribute name="step_number"><xsl:value-of select="@stepNumber"/></xsl:attribute>
      </mgmt_bcn_step>
      <properties>
        <xsl:call-template name="getTargetFrameName"/>
        <xsl:call-template name="getWindowIndex"/>
        <xsl:call-template name="getRequestMode"/>
        <xsl:call-template name="getMethod"/>
        <xsl:apply-templates select="url|postdata|headers|charset|regex|regmd|ignore_input_hint|hidden_input_hint|actions|SuccessString|sensitive_values|nonsensitive_values|query_param|is_form_submit"/>
      </properties>
    </mgmt_bcn_step_with_props>
  </xsl:template>

  <xsl:template name="getRequestMode">
    <property name="req_mode" string_part="0.0" prop_type="2" encrypt="false">
      <xsl:choose>
        <xsl:when test="@requestMode='onload_submit'">
          <xsl:attribute name="num_value">5.0</xsl:attribute>
        </xsl:when>
        <xsl:when test="@requestMode='script_redirect'">
          <xsl:attribute name="num_value">4.0</xsl:attribute>
        </xsl:when>
        <xsl:when test="@requestMode='meta_redirect'">
          <xsl:attribute name="num_value">3.0</xsl:attribute>
        </xsl:when>
        <xsl:when test="@requestMode='302_redirect'">
          <xsl:attribute name="num_value">2.0</xsl:attribute>
        </xsl:when>
        <xsl:when test="@requestMode='frame'">
          <xsl:attribute name="num_value">6.0</xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="num_value">1.0</xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
    </property>
  </xsl:template>

  <xsl:template name="getMethod">
    <property name="http_method" string_part="0.0" prop_type="1" encrypt="false">
      <xsl:choose>
        <xsl:when test="postdata[@value != '']">
          <xsl:attribute name="string_value">P</xsl:attribute>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="string_value">G</xsl:attribute>
        </xsl:otherwise>
      </xsl:choose>
    </property>
  </xsl:template>

  <xsl:template match="postdata">
    <!-- FIXME encrypt for postdata? -->
    <property name="post_data" string_part="0.0" prop_type="1" encrypt="true">
      <xsl:attribute name="string_value"><xsl:value-of select="@value"/></xsl:attribute>
    </property>
  </xsl:template>

  <xsl:template name="getTargetFrameName">
    <xsl:choose>
      <xsl:when test="@targetFrameName != ''">
        <property name="target_frame" string_part="0.0" prop_type="1" encrypt="false">
          <xsl:attribute name="string_value"><xsl:value-of select="@targetFrameName"/></xsl:attribute>
        </property>
      </xsl:when>
    </xsl:choose>
  </xsl:template>

  <xsl:template name="getWindowIndex">
    <xsl:choose>
      <xsl:when test="@windowIndex != ''">
        <property name="window_id" string_part="0.0" prop_type="2" encrypt="false">
          <xsl:attribute name="num_value"><xsl:value-of select="@windowIndex"/></xsl:attribute>
        </property>
      </xsl:when>
    </xsl:choose>
  </xsl:template>
</xsl:stylesheet>
