<%--

/* $Header: txnDataDisplay.jsp 14-jun-2005.13:05:05 andyao Exp $ */
/* Copyright (c) 2001, 2005, Oracle. All rights reserved.  */

/*
   DESCRIPTION

   NOTES
    <other useful comments, qualifications, etc.>

   MODIFIED    (MM/DD/YY)
    andyao        06/14/05 - fix OAC issues 
    jriel         08/28/03 - add title to chart 
    dbrown        05/28/03 - Set charset to utf-8.
    asawant       03/11/03 - Fixing bug 2681700 (Netscape 4.7 issue)
    asawant       07/17/02 - Adding the other error conditions to jscript
    njuillar      07/11/02 - Move chart legend to the South
    asawant       06/25/02 - Changing split bar char order
    njuillar      06/10/02 - Cutting over to POST.
    lyang         06/11/02 - Use EMURLEncoder
    asawant       05/28/02 - Bar chart line is too thin for one bar only.
    asawant       05/23/02 - Fixing bar chart length..
    asawant       05/16/02 - Bug: bar chart is missing in UI
    asawant       05/15/02 - Adding redirect time to split bar chart
    asawant       05/14/02 - Reverting to use binding....
    asawant       05/14/02 - Chagning comments to jsp comments..
    asawant       05/08/02 - Moving date filter to the chart bottom.
    asawant       05/07/02 - Removing Current Values repeated label..
    asawant       05/07/02 - Fixing missing end tag..
    asawant       05/01/02 - Adding thresholds..
    asawant       04/30/02 - Adding form destination..
    asawant       04/29/02 - Cutting over to use sqlChartDataSource.
    asawant       04/24/02 - Adding colors to chart..
    asawant       04/22/02 - Continue dev..
    asawant       04/22/02 - history section added
 */

/**
 *  @version $Header: txnDataDisplay.jsp 14-jun-2005.13:05:05 andyao Exp $
 *  @author  asawant
 *  @since   release specific (what release of product did this appear in)
 */

--%>

<%@ page contentType="text/html; charset=UTF-8" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem"%>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix"%>
<%@ page import='oracle.sysman.eml.chronos.WebsiteConstants'%>
<%@ page import='oracle.sysman.resources.beacon.BeaconResourceBundleID'%>
<%@ page import='oracle.sysman.resources.website.WebsiteResourceBundleID'%>
<jsp:useBean
    id="defaultBean"
    scope="request"
    type="oracle.sysman.eml.chronos.data.TxnDataDisplay"/>


<uix:renderingContext id="renderingContext"><oem:setURLEncoder id="renderingContext"/>
  <uix:document>
    <uix:metaContainer>
      <uix:head titleBinding="header@defaultBean@servletRequest"/>
      <uix:styleSheet/>
    </uix:metaContainer>

    <uix:pageLayout quickLinksShown="false">
      <%@ include file="/oemGlobal.jspf" %>

      <uix:contents>

        <uix:header textBinding="header@defaultBean@servletRequest"/>

        <uix:form name="txnDataDisplay" method="POST"
            destinationBinding="formDestination@defaultBean@servletRequest">

          <uix:rowLayout>

            <uix:switcher
                childNameBinding="staticAxis@defaultBean@servletRequest">

              <uix:case name="<%=WebsiteConstants.TXN%>">

                <uix:stackLayout>

                  <uix:messageChoice name="<%=WebsiteConstants.BCN_ID%>" 
                    promptBinding="bcnDropDownMsgStr@defaultBean@servletRequest" 
                    >
                      <uix:contents>
                        <%
                          Object[] bcnTable = defaultBean.getBcnTable();
                          String bcnSelected = defaultBean.getBcnSelectedId();
                          for(int i=0; i < bcnTable.length; i++)
                          {
                            String selected = null;
                            String values[] = (String[])bcnTable[i];
                            if(bcnSelected.equals(values[1]))
                              selected = "true";
                            else
                              selected = "false";
                        %>
                        <uix:option text="<%=values[0]%>" value="<%=values[1]%>"
                            selected="<%=selected%>"/>
                        <%
                          }
                        %>
                      </uix:contents>
                    </uix:messageChoice>

                  <uix:formValue
                      name="<%=WebsiteConstants.TXN_ID%>"
                      valueBinding="txnSelectedId@defaultBean@servletRequest"/>

                </uix:stackLayout>

              </uix:case>

              <uix:case name="<%=WebsiteConstants.BCN%>">

                <uix:stackLayout>

                    <uix:messageChoice name="<%=WebsiteConstants.TXN_ID%>" promptBinding="txnDropDownMsgStr@defaultBean@servletRequest">
                      <uix:contents>
                        <%
                          Object[] txnTable = defaultBean.getTxnTable();
                          String txnSelected = defaultBean.getTxnSelectedId();
                          for(int i=0; i < txnTable.length; i++)
                          {
                            String selected = null;
                            String values[] = (String[])txnTable[i];
                            if(txnSelected.equals(values[1]))
                              selected = "true";
                            else
                              selected = "false";
                        %>
                        <uix:option text="<%=values[0]%>"
                            value="<%=values[1]%>" selected="<%=selected%>"/>
                        <%
                          }
                        %>
                      </uix:contents>
                    </uix:messageChoice>

                  <uix:formValue
                      name="<%=WebsiteConstants.BCN_ID%>"
                      valueBinding="bcnSelectedId@defaultBean@servletRequest"/>

                </uix:stackLayout>

              </uix:case>

            </uix:switcher>

              <uix:spacer width="25"/>

              <uix:messageChoice name="<%=WebsiteConstants.MET_COL%>" promptBinding="metColDropDownMsgStr@defaultBean@servletRequest">
                <uix:contents>
                <%
                  String[][] metricTable = defaultBean.getMetricColTable();
                  String metricSelected = defaultBean.getMetricColSelected();
                  for(int i=0; i < metricTable.length; i++)
                  {
                    String selected = null;
                    if(metricSelected.equals(metricTable[i][1]))
                      selected = "true";
                    else
                      selected = "false";
                %>
                <uix:option text="<%=metricTable[i][0]%>"
                    value="<%=metricTable[i][1]%>" selected="<%=selected%>"/>
                <%
                  }
                %>
                </uix:contents>
              </uix:messageChoice>

              <uix:spacer width="25"/>
              <uix:messageChoice name="<%=WebsiteConstants.PERIOD%>" promptBinding="periodDropDownMsgStr@defaultBean@servletRequest">
                <uix:contents>
                <%
                  String[][] periodTable = defaultBean.getPeriodTable();
                  String periodSelected = defaultBean.getPeriodSelected();
                  for(int i=0; i < periodTable.length; i++)
                  {
                    String selected = null;
                    if(periodSelected.equals(periodTable[i][1]))
                      selected = "true";
                    else
                      selected = "false";
                %>
                <uix:option text="<%=periodTable[i][0]%>"
                    value="<%=periodTable[i][1]%>" selected="<%=selected%>"/>
                <%
                  }
                %>
                </uix:contents>
              </uix:messageChoice>


            <uix:formValue
                name="<%=WebsiteConstants.ST_AXIS%>"
                valueBinding="staticAxis@defaultBean@servletRequest"/>
            <uix:formValue
                name="<%=WebsiteConstants.MET_NM%>"
                valueBinding="metricName@defaultBean@servletRequest"/>
            <uix:formValue
                name="<%=WebsiteConstants.TARGET_PAGE_PROPERTY%>"
                valueBinding="targetName@defaultBean@servletRequest"/>
            <uix:formValue
                name="<%=WebsiteConstants.TARGET_TYPE_PAGE_PROPERTY%>"
                valueBinding="targetType@defaultBean@servletRequest"/>

            <uix:contents>
              <uix:spacer width="25"/>
            </uix:contents>

            <uix:submitButton
                textBinding="goButtonStr@defaultBean@servletRequest"/>

          </uix:rowLayout>

          <uix:spacer height="25"/>

        </uix:form>

        <uix:form name="txnDataDisplay2" method="POST"
            destinationBinding="formDestination@defaultBean@servletRequest">

          <uix:formValue name="<%=WebsiteConstants.TXN_ID%>"
              valueBinding="txnSelectedId@defaultBean@servletRequest"/>
          <uix:formValue name="<%=WebsiteConstants.BCN_ID%>"
              valueBinding="bcnSelectedId@defaultBean@servletRequest"/>
          <uix:formValue name="<%=WebsiteConstants.MET_COL%>"
              valueBinding="metricColSelected@defaultBean@servletRequest"/>
          <uix:formValue name="<%=WebsiteConstants.PERIOD%>"
              valueBinding="periodSelected@defaultBean@servletRequest"/>
          <uix:formValue name="<%=WebsiteConstants.ST_AXIS%>"
              valueBinding="staticAxis@defaultBean@servletRequest"/>
          <uix:formValue name="<%=WebsiteConstants.MET_NM%>"
              valueBinding="metricName@defaultBean@servletRequest"/>
          <uix:formValue name="<%=WebsiteConstants.TARGET_PAGE_PROPERTY%>"
              valueBinding="targetName@defaultBean@servletRequest"/>
          <uix:formValue name="<%=WebsiteConstants.TARGET_TYPE_PAGE_PROPERTY%>"
              valueBinding="targetType@defaultBean@servletRequest"/>

          <uix:header textBinding="chartHeader@defaultBean@servletRequest"/>

          <uix:rowLayout> <%-- Avoids browser from resiz. after img shows --%>
            <uix:cellFormat>
              <oem:chart 
                  titleBinding="chartHeader@defaultBean@servletRequest"
                  titleVisible="false"
                  chartType="timeSeriesChart" 
                  orientation="vertical" 
                  width="700"
                  height="300" 
                  seriesColorsAutomatic="true"
                  legendPosition="south"
                  timeGranularityBinding="tmGran@defaultBean@servletRequest"
                  warningThresholdBinding=
                    "warningThresh@defaultBean@servletRequest"
                  criticalThresholdBinding=
                    "criticalThresh@defaultBean@servletRequest">
                <uix:contents>
                  <oem:boundChartDataSource
                      dataClass="oracle.sysman.eml.chronos.data.TxnDataDisplay"
                      dataMethod="getChartData2"/>
                  <%--
                  <oem:sqlChartDataSource
                      sqlResultSetBinding="abicursor@servletRequest"
                      sqlConnectionBinding="abiconnection@servletRequest"/>
                  --%>
                  <oem:chartColumn sourceIndex="0" isTimeColumn="true"/>
                  <oem:chartColumn sourceIndex="1" isKey="true"/>
                  <%-- Do nott remove displayLabel --> the chart disappears! --%>
                  <oem:chartColumn sourceIndex="2" displayLabel=""/>
                </uix:contents>
              </oem:chart>
            </uix:cellFormat>
          </uix:rowLayout>

          <uix:spacer height="5"/>

          <uix:rowLayout>

            <%--
            <uix:messagePrompt
                promptBinding="minFilterStr@defaultBean@servletRequest"/>
            <uix:textInput name="<%=WebsiteConstants.MIN_FILTER%>"
                text="minFilter@defaultBean@servletRequest" columns="17"/>

            <uix:spacer height="5"/>

            <uix:messagePrompt
                promptBinding="maxFilterStr@defaultBean@servletRequest"/>
            <uix:textInput name="<%=WebsiteConstants.MAX_FILTER%>"
                textBinding="maxFilter@defaultBean@servletRequest"
                columns="17"/>

            <uix:spacer height="5"/>
            --%>

            <uix:stackLayout>
              <uix:messageTextInput name="<%=WebsiteConstants.MIN_DATE_FILTER%>"
                  promptBinding="minDateStr@defaultBean@servletRequest"
                  textBinding="minDate@defaultBean@servletRequest" columns="17"
                  tipBinding="dateFormatTip@defaultBean@servletRequest"/>
            </uix:stackLayout>

            <uix:spacer width="25"/>

            <uix:stackLayout>
              <uix:messageTextInput name="<%=WebsiteConstants.MAX_DATE_FILTER%>"
                  promptBinding="maxDateStr@defaultBean@servletRequest"
                  textBinding="maxDate@defaultBean@servletRequest" columns="17"
                  tipBinding="dateFormatTip@defaultBean@servletRequest"/>
            </uix:stackLayout>

            <uix:spacer width="25"/>

            <uix:submitButton 
                textBinding="applyButtonStr@defaultBean@servletRequest"/>

          </uix:rowLayout>

          <uix:spacer height="15"/>

          <uix:header
              textBinding="avgTableHeaderStr@defaultBean@servletRequest"/>

          <uix:spacer height="10"/>

          <oem:table width="100%" name="tbl" dataSourceProp="txnAvgDataTbl"
              summaryBinding="avgTableHeaderStr@defaultBean@servletRequest"
              alternateText="No data">
          </oem:table>

          <uix:spacer height="25"/>

          <uix:header
              textBinding="curTableHeaderStr@defaultBean@servletRequest"/>

          <uix:spacer height="10"/>

          <uix:switcher
              childNameBinding="metricName@defaultBean@servletRequest">
            <uix:case name="<%=WebsiteConstants.METRIC_NAME%>">
              <uix:stackLayout>
         
                <%-- Avoids browser from resiz. after img shows --%>
                <uix:rowLayout>
                  <uix:cellFormat>
                  <uix:contents>
                    <oem:chart chartType="barChart" orientation="horizontal"
                        width="800"
                        heightBinding="height@defaultBean@servletRequest"
                        seriesColorsAutomatic="true"
                        stacked="true"
                        legendPosition="south">
                        <oem:boundChartDataSource
                            dataMethod="getBarChartData"
                            dataClass=
                              "oracle.sysman.eml.chronos.data.TxnDataDisplay"/>
                        <oem:chartColumn sourceIndex="0" isKey="true"/>
                        <oem:chartColumn sourceIndex="1"
                            displayLabel="<%=defaultBean.getBcnString(
                                BeaconResourceBundleID.CONNECTTIME)%>"/>
                        <oem:chartColumn sourceIndex="2"
                            displayLabel="<%=defaultBean.getBcnString(
                                BeaconResourceBundleID.REDIRECT_TIME)%>"/>
                        <oem:chartColumn sourceIndex="3"
                            displayLabel="<%=defaultBean.getBcnString(
                                BeaconResourceBundleID.FIRST_BYTE_TIME)%>"/>
                        <oem:chartColumn sourceIndex="4"
                            displayLabel="<%=defaultBean.getBcnString(
                                BeaconResourceBundleID.BASE_PAGE_TIME)%>"/>
                        <oem:chartColumn sourceIndex="5"
                            displayLabel="<%=defaultBean.getBcnString(
                                BeaconResourceBundleID.IMAGE_TIME)%>"/>
                    </oem:chart>
                  </uix:contents>
                  </uix:cellFormat>
                </uix:rowLayout>

                <uix:spacer height="25"/>

              </uix:stackLayout>
            </uix:case>
          </uix:switcher>

          <oem:table width="100%" name="tbl" dataSourceProp="txnCurDataTbl"
              summaryBinding="curTableHeaderStr@defaultBean@servletRequest"
              alternateText="No data">
          </oem:table>

        </uix:form>
      </uix:contents>
    </uix:pageLayout>
  </uix:document>
</uix:renderingContext>
<%@ include file="/oemNoscript.jspf" %>

<script language="JavaScript1.3">

  var myTxnIdRef = document.txnDataDisplay.<%=WebsiteConstants.TXN_ID%>;
  var myBcnIdRef = document.txnDataDisplay.<%=WebsiteConstants.BCN_ID%>;
  var myMetColRef = document.txnDataDisplay.<%=WebsiteConstants.MET_COL%>;

  var myTxnIdIdx = [getIdx(myTxnIdRef)];
  var myBcnIdIdx = [getIdx(myBcnIdRef)];
  var myMetColIdx = [getIdx(myMetColRef)];

  var myAll = "<%=WebsiteConstants.ALL%>";
  var myTime = "<%=WebsiteConstants.TIME%>";
  var myAvail = "<%=WebsiteConstants.AVL%>";

  var errMsgAllTxnAll =
    "<%=defaultBean.getString(WebsiteResourceBundleID.ALL_TXN_BY_ALL)%>";
  var errMsgAllBcnAll =
    "<%=defaultBean.getString(WebsiteResourceBundleID.ALL_BCN_BY_ALL)%>";
  var errMsgAllTxnTime =
    "<%=defaultBean.getString(WebsiteResourceBundleID.ALL_TXN_BY_TIME)%>";
  var errMsgAllBcnTime =
    "<%=defaultBean.getString(WebsiteResourceBundleID.ALL_BCN_BY_TIME)%>";
  var errMsgAvailAll =
    "<%=defaultBean.getString(WebsiteResourceBundleID.AVAIL_BY_ALL)%>";
  var errMsgAvailTime =
    "<%=defaultBean.getString(WebsiteResourceBundleID.AVAIL_BY_TIME)%>";

  function setIdx(refObject, idx)
  {
    if(refObject.type == "select-one")
      refObject.selectedIndex = idx;
  }

  function getIdx(refObject)
  {
    if(refObject.type == "select-one")
      return(refObject.selectedIndex);
    return(-1);
  }

  function getVal(refObject)
  {
    if(refObject.type == "select-one")
      return((refObject.options)[refObject.selectedIndex].value);
    return(refObject.value);
  }

  function checkVal(myAxisRef, myIdxRef)
  {
    var metCount = 0;
    var bcnCount = 0;
    var txnCount = 0;
    var allCount = 0;
    var tmp      = 0;  /* Tmp value holder */

    value = getVal(myMetColRef);
    if(value == myAll)
    {
      metCount = 1;
      allCount++;
    }
    else if(value == myTime)
    {
      metCount = 2;
      allCount++;
    }

    value = getVal(myBcnIdRef);
    if(value == myAll)
    {
      bcnCount = 1;
      allCount++;
    }
    else if(value == myAvail)
    {
      bcnCount = 2;
      allCount++;
    }

    value = getVal(myTxnIdRef);
    if(value == myAll)
    {
      txnCount = 1;
      allCount++;
    }

    if(allCount > 1)
    {
      if(txnCount == 1)
      {
        if(metCount == 1)
          errMsg = errMsgAllTxnAll;
        else // if(metCount == 2)
          errMsg = errMsgAllTxnTime;
      }
      else if(bcnCount == 1)
      {
        if(metCount == 1)
          errMsg = errMsgAllBcnAll;
        else // if(metCount == 2)
          errMsg = errMsgAllBcnTime;
      }
      else //if(bcnCount == 2)
      {
        if(metCount == 1)
          errMsg = errMsgAvailAll;
        else // if(metCount == 2)
          errMsg = errMsgAvailTime;
      }
      alert(errMsg);
      setIdx(myAxisRef, myIdxRef);
    }
    else
      myIdxRef[0] = getIdx(myAxisRef);
  }

  myTxnIdRef.onchange = new Function("checkVal(myTxnIdRef, myTxnIdIdx)");
  myBcnIdRef.onchange = new Function("checkVal(myBcnIdRef, myBcnIdIdx)");
  myMetColRef.onchange = new Function("checkVal(myMetColRef, myMetColIdx)");

</script>

