
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>

<uix:buildTree scope="request" nodeID="NetAlertsTable">
  <uix:header text="Open Network Alerts"
              renderedBinding="showAlertsSection@">

  <uix:stackLayout>
    <uix:tableLayout>
      <uix:rowLayout vAlign="center">

        <uix:rowLayout
              renderedBinding="showErrorCount@">
          <uix:styledText 
                  styleClass="OraPromptText"
                  textBinding="METRIC_COLLECTION_ERRORS@sdkMsg"/>
          <uix:spacer width="5"/>
          <uix:image
                  sourceBinding="metricErrorImage@" />
          <uix:spacer width="5"/>
          <uix:link 
                  textBinding="errorCount@"
                  destinationBinding="errorDest@" />
        </uix:rowLayout>
        <uix:spacer width="10" />

      </uix:rowLayout>
    </uix:tableLayout>

    <uix:table nameBinding="tableName@"
               renderedBinding="showAlertsTable@"
               tableDataBinding="alertList@"
               alternateTextBinding="ALERTS_ALT@sdkMsg"
               width="100%"
               showAll="yes"
               blockSizeBinding="blockSize@"
               minValueBinding="minValue@"
               maxValueBinding="maxValue@"
               valueBinding="start@">

        <uix:tableFormat tableBanding="rowBanding"/>

         <uix:contents>
            <uix:column>
              <uix:columnHeader> <uix:styledText textBinding="METRIC@sdkMsg" />
              </uix:columnHeader>
              <uix:link textBinding="name@" destinationBinding="valueDest@" />
            </uix:column>
            <uix:column renderedBinding="showKey1Column@" >
              <uix:columnHeader> <uix:styledText textBinding="key1Header" /> </uix:columnHeader>
              <uix:styledText textBinding="key1Text@" styleClassBinding="key1Style@" />
            </uix:column>
            <uix:column renderedBinding="showKey2Column@" >
              <uix:columnHeader> <uix:styledText textBinding="key2Header" /> </uix:columnHeader>
              <uix:styledText textBinding="key2Text@" styleClassBinding="key2Style@"  />
            </uix:column>
            <uix:column renderedBinding="showKey3Column@" >
              <uix:columnHeader> <uix:styledText textBinding="key3Header" /> </uix:columnHeader>
              <uix:styledText textBinding="key3Text@" styleClassBinding="key3Style@"  />
            </uix:column>
            <uix:column renderedBinding="showTargetColumn@" >
              <uix:columnHeader> <uix:styledText textBinding="TARGET_NAME@sdkMsg" />
              </uix:columnHeader>
              <uix:link textBinding="targetName@" destinationBinding="targetNameDest@" />
            </uix:column>
            <uix:column renderedBinding="showTargetColumn@" >
              <uix:columnHeader> <uix:styledText textBinding="TARGET_TYPE@sdkMsg" />
              </uix:columnHeader>
              <uix:styledText textBinding="targetType@"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader> <uix:styledText textBinding="SEVERITY@sdkMsg" /> 
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="iconButtonFormat" />
              <uix:image sourceBinding="severity@"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader> <uix:styledText textBinding="24@sdkMsg" />
              </uix:columnHeader> 
              <uix:styledText textBinding="openSince@"/>
            </uix:column>
            <uix:column>
              <uix:columnHeader> <uix:styledText textBinding="LAST_VALUE@sdkMsg" />
              </uix:columnHeader>
              <uix:columnFormat columnDataFormat="numberFormat" />
              <uix:styledText textBinding="value@" />
            </uix:column>
            <uix:column>
              <uix:columnHeader> <uix:styledText textBinding="26@sdkMsg" />
              </uix:columnHeader>
              <uix:styledText textBinding="lastChecked@"/>
            </uix:column>
          </uix:contents>

    </uix:table>

  </uix:stackLayout>
  </uix:header>
</uix:buildTree>

