<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script language="javascript">
function setSearchPage()
{
  var userEntered = document.addJobs.jobOwner.value;
  var url = document.addJobs.selectUsersURL.value;
  document.addJobs.selectUsersPage.value = url + "?userChoice=" + userEntered;
  window.myData = 'jobOwner';
}
</script>

<script language="javascript">
function myCallBack()
{
  // do nothing; the popup window handles it
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <uix:body>

      <uix:form name="addJobs" method="POST" >
        <uix:formValue name="selectUsersPage"/>
        <uix:formValue name="selectUsersURL" valueBinding="selectUsersURL@addJobs@servletRequest"/>
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@addJobs@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@addJobs@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@addJobs@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@addJobs@servletRequest">
            <uix:messageBox messageBinding="msg@addJobs@servletRequest"
                            messageTypeBinding="msgType@addJobs@servletRequest"
                            textBinding="valErrText@addJobs@servletRequest">
              <uix:contents childDataBinding="valErrData@addJobs@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@addJobs@servletRequest" >
            <uix:header textBinding="createEditHeader@addJobs@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout >
                <uix:cellFormat hAlign="left" >
                  <uix:styledText textBinding="SELECT_JOBS_FOR_RULE@notifResourceBundle"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" >
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@commonResourceBundle"
                                destination="ruleJobs" />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doAddJobs"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5" />

            <uix:header textBinding="JOBS@notifResourceBundle" >

              <uix:labeledFieldLayout fieldWidth="90%" labelWidth="10%" >

                  <uix:messageTextInput promptBinding="JOB_NAME@notifResourceBundle"
                                        shortDescBinding="JOB_NAME@notifResourceBundle"
                                        name="jobName"
                                        id="jobName"
                                        rows="1"
                                        columns="40"
                                        textBinding="jobName@addJobs@servletRequest"/>

                  <uix:inlineMessage promptBinding="JOB_TYPE@notifResourceBundle" >
                    <uix:choice name="jobType"
                                id="jobType"
                                selectedValueBinding="jobType@addJobs@servletRequest" 
                                shortDescBinding="JOB_TYPE@notifResourceBundle" >

                      <uix:contents childDataBinding="jobTypesList@addJobs@servletRequest" >
                        <uix:option textBinding="available"
                                    valueBinding="availID" />
                      </uix:contents>
                    </uix:choice>

                  </uix:inlineMessage>

                  <uix:inlineMessage promptBinding="JOB_OWNER@notifResourceBundle" >
                        <uix:lovField name="jobOwner" 
                                      id="jobOwner"
                                      onClick="setSearchPage(); openWindow(window, document.addJobs.selectUsersPage.value, 'lovWindow', {width:500, height:430}, true, 'dialog', myCallBack); return false;"
                                      textBinding="jobOwner@addJobs@servletRequest"
                                      columns="40"
                                      shortDescBinding="CLICK_TO_SELECT_OWNER@notifResourceBundle" 
                                      searchDescBinding="CLICK_TO_SELECT_OWNER@notifResourceBundle"/>
                  </uix:inlineMessage>

               <uix:styledText text="" />

                <uix:submitButton textBinding="SEARCH@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="searchJobs"/>

              </uix:labeledFieldLayout>
              
              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:styledText textBinding="JOBS_SHOWN_INSTR@notifResourceBundle"
                              styleClass="OraInstructionText" />

              <uix:table name="addJobs"
                         width="100%"
                         showAll="yes"
                         formSubmitted="true"
                         alternateTextBinding="NO_JOBS_FOUND@notifResourceBundle"
                         summaryBinding="JOBS@notifResourceBundle"
                         valueBinding="value@addJobs@servletRequest"
                         minValueBinding="minValue@addJobs@servletRequest"
                         blockSizeBinding="blockSize@addJobs@servletRequest"
                         maxValueBinding="maxValue@addJobs@servletRequest"
                         columnHeaderDataBinding="columnHeader@addJobs@servletRequest"
                         tableDataBinding="availJobs@addJobs@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@"
                                         shortDescBinding="SELECT@notifResourceBundle" >
                  </uix:multipleSelection>
                </uix:tableSelection>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:contents >
                  <uix:styledText textBinding="nameLabel@"
                                  shortDescBinding="JOB_NAME@notifResourceBundle" />

                  <uix:styledText textBinding="typeLabel@"
                                  shortDescBinding="JOB_TYPE@notifResourceBundle" />
                  <uix:styledText textBinding="owner@"
                                  shortDescBinding="JOB_OWNER@notifResourceBundle" />

                  <uix:formValue name="job" valueBinding="value@" />

                </uix:contents >

              </uix:table>

            </uix:header>

            <uix:spacer height="10" />
    
            <uix:header textBinding="JOB_STATUS@notifResourceBundle" >
              <uix:styledText textBinding="SELECT_JOB_STATUS@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer width="30" />
                <uix:checkBox name="scheduled" 
                              textBinding="JOB_SCHEDULED@notifResourceBundle" 
                              shortDescBinding="JOB_SCHEDULED@notifResourceBundle" 
                              checkedBinding="scheduled@addJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="started" 
                              textBinding="JOB_STARTED@notifResourceBundle" 
                              shortDescBinding="JOB_STARTED@notifResourceBundle" 
                              checkedBinding="started@addJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="suspended" 
                              textBinding="JOB_SUSPENDED@notifResourceBundle" 
                              shortDescBinding="JOB_SUSPENDED@notifResourceBundle" 
                              checkedBinding="suspended@addJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="succeeded" 
                              textBinding="JOB_SUCCEEDED@notifResourceBundle" 
                              shortDescBinding="JOB_SUCCEEDED@notifResourceBundle"
                              checkedBinding="succeeded@addJobs@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="problem" 
                              textBinding="JOB_PROBLEM@notifResourceBundle" 
                              shortDescBinding="JOB_PROBLEM@notifResourceBundle"
                              checkedBinding="problem@addJobs@servletRequest" 
                              value="true" />
              </uix:rowLayout>

            </uix:header>

            </uix:header>

          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@addJobs@servletRequest" >
              <uix:pageButtonBar>

                <uix:button textBinding="CANCEL@commonResourceBundle"
                            destination="ruleJobs" />
                <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="doAddJobs"/>
              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
