<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script language="javascript">
function setLovUrl(url)
{
  // alert(url);
  document.forms[0].lovUrl.value = url;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form name="addMetrics" method="POST" >
        <uix:pageLayout>

          <uix:formValue name="lovUrl"/>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@addMetrics@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@addMetrics@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@addMetrics@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@addMetrics@servletRequest">
            <uix:messageBox messageBinding="msg@addMetrics@servletRequest"
                            messageTypeBinding="msgType@addMetrics@servletRequest"
                            textBinding="valErrText@addMetrics@servletRequest">
              <uix:contents childDataBinding="valErrData@addMetrics@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@addMetrics@servletRequest" >
            <uix:header textBinding="createEditHeader@addMetrics@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout >
                <uix:cellFormat hAlign="left" >
                  <uix:styledText textBinding="SELECT_STATUS_COND_FOR_RULE@notifResourceBundle"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right" >
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@commonResourceBundle"
                                destination="ruleMetrics" />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doAddMetrics"/>

                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5" />

            <uix:header textBinding="METRICS@notifResourceBundle" >

              <uix:table name="addMetrics"
                         width="100%"
                         showAll="yes"
                         formSubmitted="true"
                         alternateTextBinding="ALL_METRICS_ADDED@notifResourceBundle"
                         summaryBinding="METRICS@notifResourceBundle"
                         valueBinding="value@addMetrics@servletRequest"
                         minValueBinding="minValue@addMetrics@servletRequest"
                         blockSizeBinding="blockSize@addMetrics@servletRequest"
                         maxValueBinding="maxValue@addMetrics@servletRequest"
                         columnHeaderDataBinding="columnHeader@addMetrics@servletRequest"
                         tableDataBinding="availMetrics@addMetrics@servletRequest" >
                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@"
                                         shortDescBinding="SELECT@notifResourceBundle" >
                  </uix:multipleSelection>
                </uix:tableSelection>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:contents >
                  <uix:styledText textBinding="label@"
                                  shortDescBinding="METRIC@notifResourceBundle" />

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:formValue name="metricID" 
                                 valueBinding="metricID@"  />
                  <uix:styledText rendered="true"
                                  renderedBinding="noKeyColumn@"
                                  textBinding="textNA@" />
                  <uix:stackLayout rendered="false"
                                   renderedBinding="hasKeyColumn@" >
                    <uix:radioButton name="keyValuesChoice"
                                     textBinding="keyColLabel@"
                                     shortDescBinding="keyColLabel@"
                                     value="all"
                                     selectedBinding="allSelected@" />
                      <uix:flowLayout>
                        <uix:radioButton name="keyValuesChoice"
                                         textBinding="SELECT@notifResourceBundle"
                                         shortDescBinding="SELECT@notifResourceBundle"
                                         selectedBinding="selectSelected@"
                                         value="select" />
                        <uix:lovField name="keyValuesField" 
                                      onClickBinding="onClickScript@"
                                      textBinding="keyValuesField@"
                                      columns="40"
                                      shortDescBinding="CLICK_TO_SELECT_OBJ@notifResourceBundle" 
                                      searchDescBinding="CLICK_TO_SELECT_OBJ@notifResourceBundle"/>
                      </uix:flowLayout>
                    </uix:stackLayout>
                  </uix:column>

                  <uix:formValue name="metric" valueBinding="value@" />

                 </uix:contents>

                </uix:table>

              </uix:header>

              <uix:spacer height="10" />
    
              <uix:header textBinding="SEVERITY_STATES@notifResourceBundle" >
                <uix:styledText textBinding="SEVERITY_STATES_MSG@notifResourceBundle" 
                                styleClass="OraInstructionText"/>

                <uix:rowLayout>
                  <uix:spacer height="5" />
                </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer width="30" />
                  <uix:checkBox name="critical" 
                                textBinding="CRITICAL@notifResourceBundle" 
                                shortDescBinding="CRITICAL@notifResourceBundle"
                                checkedBinding="critical@addMetrics@servletRequest" 
                                value="true" />
                  <uix:spacer width="10" />
                  <uix:checkBox name="warning" 
                                textBinding="WARNING@notifResourceBundle" 
                                shortDescBinding="WARNING@notifResourceBundle" 
                                checkedBinding="warning@addMetrics@servletRequest" 
                                value="true" />
                  <uix:spacer width="10" />
                  <uix:checkBox name="clear" 
                                textBinding="CLEAR@notifResourceBundle" 
                                shortDescBinding="CLEAR@notifResourceBundle" 
                                checkedBinding="clear@addMetrics@servletRequest" 
                                value="true" />
                </uix:rowLayout>

              </uix:header>
    
              <uix:spacer height="10" />

              <uix:header textBinding="CORRECTIVE_ACTION@notifResourceBundle" >
                <uix:styledText textBinding="SELECT_METRIC_CA@notifResourceBundle" 
                                styleClass="OraInstructionText"/>

                <uix:rowLayout>
                  <uix:spacer height="5" />
                </uix:rowLayout>

                <uix:labeledFieldLayout fieldWidth="70%" labelWidth="30%" >

                  <uix:styledText textBinding="CORRECTIVE_ACTION_CRITICAL@notifResourceBundle" />

                  <uix:rowLayout>
                    <uix:checkBox name="succeedOnCritical" 
                                  textBinding="SUCCEEDED@notifResourceBundle" 
                                  shortDescBinding="SUCCEEDED@notifResourceBundle"
                                  checkedBinding="succeedOnCritical@addMetrics@servletRequest" 
                                  value="true" />
                                          
                    <uix:spacer width="10" />
                    <uix:checkBox name="problemOnCritical" 
                                  textBinding="PROBLEM@notifResourceBundle" 
                                  shortDescBinding="PROBLEM@notifResourceBundle" 
                                  checkedBinding="problemOnCritical@addMetrics@servletRequest" 
                                  value="true" />
                  </uix:rowLayout>

                  <uix:styledText textBinding="CORRECTIVE_ACTION_WARNING@notifResourceBundle" />

                  <uix:rowLayout>
                    <uix:checkBox name="succeedOnWarning" 
                                  textBinding="SUCCEEDED@notifResourceBundle" 
                                  shortDescBinding="SUCCEEDED@notifResourceBundle"
                                  checkedBinding="succeedOnWarning@addMetrics@servletRequest" 
                                  value="true" />
                      <uix:spacer width="10" />
                      <uix:checkBox name="problemOnWarning" 
                                    textBinding="PROBLEM@notifResourceBundle" 
                                    shortDescBinding="PROBLEM@notifResourceBundle" 
                                    checkedBinding="problemOnWarning@addMetrics@servletRequest" 
                                    value="true" />
                    </uix:rowLayout>

                  </uix:labeledFieldLayout>

                </uix:header>
    
                </uix:header>

              </uix:stackLayout>

              <uix:contentFooter>
                <uix:stackLayout rendered="true"
                                 renderedBinding="showContents@addMetrics@servletRequest" >
                <uix:pageButtonBar>

                <uix:button textBinding="CANCEL@commonResourceBundle"
                            destination="ruleMetrics" />
                <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="doAddMetrics"/>

              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
