<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>

  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>

      <uix:form name="addPolicies" method="POST" >
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@addPolicies@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@addPolicies@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@addPolicies@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@addPolicies@servletRequest">
            <uix:messageBox messageBinding="msg@addPolicies@servletRequest"
                            messageTypeBinding="msgType@addPolicies@servletRequest"
                            textBinding="valErrText@addPolicies@servletRequest">
              <uix:contents childDataBinding="valErrData@addPolicies@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@addPolicies@servletRequest" >
            <uix:header textBinding="createEditHeader@addPolicies@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout >
                <uix:cellFormat hAlign="left" >
                  <uix:styledText textBinding="SELECT_POLICIES_FOR_RULE@notifResourceBundle"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat hAlign="right">
                  <uix:pageButtonBar>

                    <uix:button textBinding="CANCEL@commonResourceBundle"
                                destination="rulePolicies" />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doAddPolicies"/>

                  </uix:pageButtonBar>

                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5" />

            <uix:header textBinding="POLICIES@notifResourceBundle" >

              <uix:table name="addPolicies"
                         width="100%"
                         showAll="yes"
                         formSubmitted="true"
                         alternateTextBinding="ALL_POLICIES_ADDED@notifResourceBundle"
                         summaryBinding="POLICIES@notifResourceBundle"
                         valueBinding="value@addPolicies@servletRequest"
                         minValueBinding="minValue@addPolicies@servletRequest"
                         blockSizeBinding="blockSize@addPolicies@servletRequest"
                         maxValueBinding="maxValue@addPolicies@servletRequest"
                         columnHeaderDataBinding="columnHeader@addPolicies@servletRequest"
                         tableDataBinding="availPolicies@addPolicies@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@"
                                         shortDescBinding="SELECT@notifResourceBundle" >
                  </uix:multipleSelection>
                                 
                </uix:tableSelection>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:contents >
                  <uix:styledText textBinding="label@"
                                  shortDescBinding="POLICY@notifResourceBundle" />
                  <uix:styledText textBinding="categoryLabel@"
                                  shortDescBinding="@notifResourceBundle" />

                  <uix:formValue name="policy" valueBinding="value@" />
                  <uix:formValue name="categoryName" valueBinding="categoryName@" />
                </uix:contents>

              </uix:table>

            </uix:header>

            <uix:spacer height="10" />
    
            <uix:header textBinding="SEVERITY_STATES@notifResourceBundle" >
              <uix:styledText textBinding="SEVERITY_STATES_MSG@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:rowLayout>
                <uix:spacer width="30" />
                <uix:checkBox name="violation" 
                              textBinding="VIOLATION@notifResourceBundle" 
                              shortDescBinding="VIOLATION@notifResourceBundle"
                              checkedBinding="violation@addPolicies@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="clear" 
                              textBinding="CLEAR@notifResourceBundle" 
                              shortDescBinding="CLEAR@notifResourceBundle"
                              checkedBinding="clear@addPolicies@servletRequest" 
                              value="true" />
              </uix:rowLayout>

            </uix:header>
    
            <uix:spacer height="10" />

            <uix:header textBinding="CORRECTIVE_ACTION@notifResourceBundle" >
              <uix:styledText textBinding="SELECT_POLICY_CA@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

                <uix:rowLayout>
                  <uix:spacer width="30" />
                  <uix:checkBox name="succeedOnViolation" 
                                textBinding="SUCCEEDED@notifResourceBundle" 
                                shortDescBinding="SUCCEEDED@notifResourceBundle"
                                checkedBinding="succeedOnViolation@addPolicies@servletRequest" 
                                value="true" />
                                          
                  <uix:spacer width="10" />
                  <uix:checkBox name="problemOnViolation" 
                                textBinding="PROBLEM@notifResourceBundle" 
                                shortDescBinding="PROBLEM@notifResourceBundle"
                                checkedBinding="problemOnViolation@addPolicies@servletRequest" 
                                value="true" />
                </uix:rowLayout>

            </uix:header>

            </uix:header>

          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@addPolicies@servletRequest" >
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@commonResourceBundle"
                            destination="rulePolicies" />
                <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="doAddPolicies"/>
              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
