<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>

    <uix:body>

      <uix:form nameBinding="formName@ruleAvail@servletRequest" method="POST" >
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@ruleAvail@servletRequest" />
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@ruleAvail@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@ruleAvail@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                          renderedBinding="showValErr@ruleAvail@servletRequest">
            <uix:messageBox messageBinding="msg@ruleAvail@servletRequest"
                            messageTypeBinding="msgType@ruleAvail@servletRequest"
                            textBinding="valErrText@ruleAvail@servletRequest">
              <uix:contents childDataBinding="valErrData@ruleAvail@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@ruleAvail@servletRequest" >
            <uix:header textBinding="createEditHeader@ruleAvail@servletRequest" />

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      shortDescBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="Cancel"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      shortDescBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="OK"/>

                  </uix:pageButtonBar>

                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="selectedPageIndex@ruleAvail@servletRequest">
                  <uix:contents childDataBinding="subTabs@ruleAvail@servletRequest" >
                    <uix:link textBinding="tabName"
                              onClickBinding="onClickScript"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:subTabs>

              <uix:rowLayout>
                <uix:spacer height="10" />
              </uix:rowLayout>
                
              <uix:styledText textBinding="SELECT_AVAIL_STATES_FOR_RULE@notifResourceBundle"
                              rendered="false" 
                              renderedBinding="showDetails@ruleAvail@servletRequest" 
                              styleClass="OraInstructionText" />

              <uix:rowLayout  rendered="false" 
                              renderedBinding="showDetails@ruleAvail@servletRequest" >
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:stackLayout rendered="true"
                               renderedBinding="showAvailList@ruleAvail@servletRequest" >
                <uix:contents childDataBinding="allAvail@ruleAvail@servletRequest" >
                 <uix:rowLayout>

                  <uix:checkBox nameBinding="name"
                                textBinding="text"
                                shortDescBinding="text"
                                checkedBinding="checked"
                                onClickBinding="onClickScript"
                                valueBinding="value" />

                 </uix:rowLayout>

                 <uix:styledText rendered="true"
                                 renderedBinding="showHint"
                                 textBinding="hint"
                                 styleClass="OraInlineInfoText" />

                 <uix:rowLayout rendered="false"
                                renderedBinding="isDown" 
                                width="100%" >

                  <uix:cellFormat width="20" >
                   <uix:spacer width="20" />
                  </uix:cellFormat >

                  <uix:cellFormat width="100%" >
                   <uix:header rendered="false"
                               renderedBinding="isDown" 
                               textBinding="CORRECTIVE_ACTION_ON_DOWN@notifResourceBundle"
                               size="2">

                    <uix:checkBox name="problemOnDown" 
                                  textBinding="PROBLEM@notifResourceBundle" 
                                  shortDescBinding="PROBLEM@notifResourceBundle" 
                                  checkedBinding="problemOnDown@ruleAvail@servletRequest" 
                                  valueBinding="problemValue@ruleAvail@servletRequest" />

                    <uix:spacer width="10" />
                    <uix:checkBox name="succeedOnDown" 
                                  textBinding="SUCCEEDED@notifResourceBundle" 
                                  shortDescBinding="SUCCEEDED@notifResourceBundle"
                                  checkedBinding="succeedOnDown@ruleAvail@servletRequest" 
                                  valueBinding="succeedValue@ruleAvail@servletRequest" />
    
                   </uix:header>

                   <uix:header rendered="false"
                               renderedBinding="isService" 
                               textBinding="ROOT_CAUSE_ANALYSIS@notifResourceBundle" 
                               size="2">

                    <uix:stackLayout>
                    <uix:radioButton name="rcaChoice"
                                  textBinding="SEND_NOTIF_IMMEDIATELY@notifResourceBundle"
                                  shortDescBinding="SEND_NOTIF_IMMEDIATELY@notifResourceBundle"
                                  selectedValueBinding="rcaValue@ruleAvail@servletRequest"
                                  disabledBinding="rcaDisabled@ruleAvail@servletRequest"
                                  value="noRCA" />

                    <uix:radioButton name="rcaChoice"
                                  textBinding="WAIT_FOR_RCA@notifResourceBundle"
                                  shortDescBinding="WAIT_FOR_RCA@notifResourceBundle"
                                  selectedValueBinding="rcaValue@ruleAvail@servletRequest"
                                  disabledBinding="rcaDisabled@ruleAvail@servletRequest"
                                  value="yesRCA" />
                    </uix:stackLayout>
                   </uix:header>
                  </uix:cellFormat >

                 </uix:rowLayout>

                </uix:contents>
              </uix:stackLayout>

              <uix:styledText rendered="false"
                              renderedBinding="hideDetails@ruleAvail@servletRequest"
                              textBinding="noDetailsMsg@ruleAvail@servletRequest"
                              styleClass="OraInstructionText" />


              <uix:rowLayout>
                <uix:spacer height="10" />
              </uix:rowLayout>

            </uix:subTabLayout>
          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@ruleAvail@servletRequest" >
              <uix:pageButtonBar>

                <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="Cancel"/>
                <uix:submitButton textBinding="OK@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="OK"/>

              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

