<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>

    <uix:body>

      <uix:form nameBinding="formName@ruleGeneral@servletRequest" method="POST" >
        <uix:pageLayout>
          <%@ include file="/enablePPR.jspf" %>
          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@ruleGeneral@servletRequest" />
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@ruleGeneral@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@ruleGeneral@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                          renderedBinding="showValErr@ruleGeneral@servletRequest">
            <uix:messageBox messageBinding="msg@ruleGeneral@servletRequest"
                            messageTypeBinding="msgType@ruleGeneral@servletRequest"
                            textBinding="valErrText@ruleGeneral@servletRequest">
              <uix:contents childDataBinding="valErrData@ruleGeneral@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@ruleGeneral@servletRequest" >
            <uix:header textBinding="createEditHeader@ruleGeneral@servletRequest" />

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar >

                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="Cancel"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="OK"/>

                  </uix:pageButtonBar>

                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="selectedPageIndex@ruleGeneral@servletRequest">
                  <uix:contents childDataBinding="subTabs@ruleGeneral@servletRequest" >
                    <uix:link textBinding="tabName"
                              onClickBinding="onClickScript"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:subTabs>

              <uix:spacer height="10" />

                <uix:labeledFieldLayout fieldWidth="95%" labelWidth="5%">

                  <uix:styledText rendered="false"
                                  renderedBinding="editMode@ruleGeneral@servletRequest"
                                  textBinding="RULE_NAME@notifResourceBundle"/>
                  <uix:styledText rendered="false"
                                  renderedBinding="editMode@ruleGeneral@servletRequest"
                                  styleClass="OraInstructionTextStrong"
                                  textBinding="notifRuleName@ruleGeneral@servletRequest"/>

                  <uix:messageTextInput promptBinding="RULE_NAME@notifResourceBundle"
                                        shortDescBinding="RULE_NAME@notifResourceBundle"
                                        rows="1"
                                        columns="70"
                                        maximumLength ="64" 
                                        required="uiOnly"
                                        name="notifRuleName"
                                        messageBinding="ruleNameMsg@ruleGeneral@servletRequest"
                                        messageTypeBinding="ruleNameMsgType@ruleGeneral@servletRequest"
                                        renderedBinding="createMode@ruleGeneral@servletRequest"
                                        textBinding="notifRuleName@ruleGeneral@servletRequest"/>

                  <uix:messageTextInput promptBinding="RULE_DESCRIPTION@notifResourceBundle"
                                        shortDescBinding="RULE_DESCRIPTION@notifResourceBundle"
                                        rows="3"
                                        columns="75"
                                        name="notifRuleDesc"
                                        textBinding="notifRuleDesc@ruleGeneral@servletRequest"/>

                  <uix:styledText text=""/>
                  <uix:spacer height="10"/>

                  <uix:styledText text=""/>
                  <uix:checkBox name="makePublicCheckbox"
                                textBinding="MAKE_PUBLIC@notifResourceBundle"
                                shortDescBinding="MAKE_PUBLIC@notifResourceBundle"
                                checkedBinding="publicRule@ruleGeneral@servletRequest"
                                value="public" />

                  <uix:styledText text=""/>
                  <uix:styledText textBinding="ALLOW_ADMIN_TO_RECEIVE_EMAIL@notifResourceBundle"
                                  styleClass="OraInlineInfoText" />

                  <uix:styledText text=""/>
                  <uix:spacer height="10"/>

                  <uix:inlineMessage promptBinding="TARGET_TYPE@notifResourceBundle"
                                     messageTypeBinding="targetTypeMsgType@ruleGeneral@servletRequest"
                                     messageBinding="targetTypeMsg@ruleGeneral@servletRequest"
                                     required="uiOnly">
                    <uix:choice name="itemTypeChoice"
                                id="itemTypeChoice"
                                selectedValueBinding="ruleType@ruleGeneral@servletRequest" 
                                shortDescBinding="TARGET_TYPE@notifResourceBundle"
                                primaryClientActionBinding="onChangeTargetTypeDropBox@servletRequest">

                      <uix:contents childDataBinding="typeList@ruleGeneral@servletRequest" >
                        <uix:option textBinding="available"
                                    valueBinding="availID" />
                      </uix:contents>
                    </uix:choice>

                  </uix:inlineMessage>

                  <uix:styledText text=""/>
                  <uix:spacer height="10"/>

                  <uix:styledText text=""/>
                  <uix:rowLayout><uix:contents>
                  <uix:radioButton name="typeRadioButton" id="typeRadioButton0"
                                   onClick="submitForm('ruleGeneral', true, {'event':'selectAll'});"
                                   selectedValueBinding="allOrIndividual@ruleGeneral@servletRequest"
                                   shortDescBinding="msgApplyRuleToAll@ruleGeneral@servletRequest"
                                   value="all"/>
                  </uix:contents>
                  <uix:contents>
                      <uix:styledText styleClass="OraInstructionText" textBinding="msgApplyRuleToAll@ruleGeneral@servletRequest" id="typeRadioButton1"/> 
                  </uix:contents>
                  </uix:rowLayout>
                  <uix:styledText text=""/>
                  <uix:styledText text=""/>

                  <uix:styledText text=""/>
                  <uix:rowLayout><uix:contents>
                  <uix:radioButton name="typeRadioButton" id="typeRadioButton2"
                                   onClick="submitForm('ruleGeneral', true, {'event':'selectIndividual'});"
                                   selectedValueBinding="allOrIndividual@ruleGeneral@servletRequest"
                                   shortDescBinding="msgApplyRuleToSpecified@ruleGeneral@servletRequest"
                                   value="individual"/>
                  </uix:contents>
                  <uix:contents>
                      <uix:styledText styleClass="OraInstructionText"
		      textBinding="msgApplyRuleToSpecified@ruleGeneral@servletRequest" id="typeRadioButton4"/> 
                  </uix:contents>
                  </uix:rowLayout>
                  <uix:spacer height="5"/>
                  <uix:spacer height="5"/>

                  <uix:styledText text=""/>
                  <uix:table name="targets" id="typeRadioButton3"
                             width="100%"
                             showAll="yes"
                             rendered="false"
                             renderedBinding="showAddTable@ruleGeneral@servletRequest"
                             formSubmitted="true"
                             alternateTextBinding="CLICK_TO_ADD_TARGETS@notifResourceBundle"
                             summaryBinding="TARGETS@notifResourceBundle"
                             valueBinding="value@ruleGeneral@servletRequest"
                             minValueBinding="minValue@ruleGeneral@servletRequest"
                             blockSizeBinding="blockSize@ruleGeneral@servletRequest"
                             maxValueBinding="maxValue@ruleGeneral@servletRequest"
                             columnHeaderDataBinding="columnHeader@ruleGeneral@servletRequest"
                             tableDataBinding="selectedTargets@ruleGeneral@servletRequest" >

                    <uix:tableFormat tableBanding="rowBanding"/>

                    <uix:tableSelection>
                      <uix:multipleSelection selectedBinding="selected@"
                                             disabled="false"
                                             disabledBinding="disableAdd@ruleGeneral@servletRequest"
                                             shortDescBinding="SELECT@notifResourceBundle" >
                        <uix:submitButton textBinding="REMOVE@notifResourceBundle" 
                                          disabled="false"
                                          disabledBinding="disableAdd@ruleGeneral@servletRequest"
                                          name="event"
                                          value="removeTargets" />
                      </uix:multipleSelection>
                    </uix:tableSelection>

                    <uix:tableActions>
                      <oem:targetSelection textBinding="ADD@sdkUIMsg" />
                    </uix:tableActions>
                    <uix:columnHeaderStamp>
                      <uix:sortableHeader sortableBinding="sortable"
                                          textBinding="text"/>
                    </uix:columnHeaderStamp>

                    <uix:contents >
                        <uix:styledText textBinding="text@"
                                        shortDescBinding="TARGET_NAME@notifResourceBundle" />
 
                        <uix:styledText textBinding="typeLabel@"
                                        shortDescBinding="TARGET_TYPE@notifResourceBundle" />

                        <uix:formValue name="value" valueBinding="value@" />
                        <uix:formValue name="targetName" valueBinding="text@" />
                        <uix:formValue name="targetType" valueBinding="type@" />

                      </uix:contents>

                  </uix:table>
                </uix:labeledFieldLayout>

                <uix:spacer height="10" />

              </uix:subTabLayout>

            </uix:stackLayout>

            <uix:contentFooter>
              <uix:stackLayout rendered="true"
                               renderedBinding="showContents@ruleGeneral@servletRequest">
                <uix:pageButtonBar>
                  <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="Cancel"/>
                  <uix:submitButton textBinding="OK@commonResourceBundle"
                                    unvalidated="true"
                                    name="event"
                                    value="OK"/>

                </uix:pageButtonBar>
              </uix:stackLayout>
            </uix:contentFooter>

          </uix:pageLayout>

        </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

