<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script language="javascript">
function setRowID(rowNum)
{
  //alert("rowNum=" + rowNum);
  document.forms[0].rowID.value = rowNum;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form nameBinding="formName@ruleJobs@servletRequest" method="POST" >
        <uix:formValue name="rowID" value="" />
          <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:contents>
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@ruleJobs@servletRequest" />
              </uix:contents>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@ruleJobs@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@ruleJobs@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@ruleJobs@servletRequest">
            <uix:messageBox messageBinding="msg@ruleJobs@servletRequest"
                            messageTypeBinding="msgType@ruleJobs@servletRequest"
                            textBinding="valErrText@ruleJobs@servletRequest">
              <uix:contents childDataBinding="valErrData@ruleJobs@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@ruleJobs@servletRequest" >
            <uix:header textBinding="createEditHeader@ruleJobs@servletRequest" />

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      shortDescBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="Cancel"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      shortDescBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="OK"/>

                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="selectedPageIndex@ruleJobs@servletRequest">
                  <uix:contents childDataBinding="subTabs@ruleJobs@servletRequest" >
                    <uix:link textBinding="tabName"
                              onClickBinding="onClickScript"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:subTabs>
                      
              <uix:spacer height="5" />

              <uix:styledText textBinding="ADD_JOBS_INSTR@notifResourceBundle"
                              rendered="false"
                              renderedBinding="showDetails@ruleJobs@servletRequest"
                              styleClass="OraInstructionText" />

              <uix:rowLayout rendered="false"
                             renderedBinding="showDetails@ruleJobs@servletRequest" >
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:table name="ruleJobs"
                         width="100%"
                         showAll="yes"
                         rendered="false"
                         renderedBinding="showDetails@ruleJobs@servletRequest"
                         formSubmitted="true"
                         alternateTextBinding="CLICK_TO_ADD_JOBS@notifResourceBundle"
                         summaryBinding="JOBS@notifResourceBundle"
                         valueBinding="value@ruleJobs@servletRequest"
                         minValueBinding="minValue@ruleJobs@servletRequest"
                         blockSizeBinding="blockSize@ruleJobs@servletRequest"
                         maxValueBinding="maxValue@ruleJobs@servletRequest"
                         columnHeaderDataBinding="columnHeader@ruleJobs@servletRequest"
                         tableDataBinding="selectedJobs@ruleJobs@servletRequest" >
                          
                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@"
                                         shortDescBinding="SELECT@notifResourceBundle" >
                    <uix:spacer width="5" />
                    <uix:submitButton textBinding="REMOVE@notifResourceBundle" 
                                      name="event"
                                      value="removeJobs" />
                  </uix:multipleSelection>
                </uix:tableSelection>

                <uix:tableActions>
                  <uix:messageChoice name="addJobMode" promptBinding="ADD@notifResourceBundle" selectedIndexBinding="jobChoiceIndex@ruleJobs@servletRequest" >
                    <uix:contents >
                      <uix:option textBinding="JOB_PATTERNS@notifResourceBundle" value="pattern" /> 
                      <uix:option textBinding="SPECIFIC_JOBS@notifResourceBundle" value="specific" /> 
                    </uix:contents>
                    <uix:end>
                      <uix:flowLayout>
                        <uix:submitButton textBinding="GO@notifResourceBundle" 
                                          name="event"
                                          value="addJobs" />
                       </uix:flowLayout>
                    </uix:end>
                  </uix:messageChoice>

                </uix:tableActions>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="nameLabel@"
                                  shortDescBinding="JOB_NAME@notifResourceBundle" />
                  <uix:formValue name="jobName" valueBinding="nameValue@" />
                  <uix:formValue name="job" valueBinding="value@" />
                </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="typeLabel@"
                                  shortDescBinding="JOB_TYPE@notifResourceBundle" />
                  <uix:formValue name="jobType" valueBinding="typeValue@" />
                </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="owner@"
                                  shortDescBinding="JOB_OWNER@notifResourceBundle" />
                </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="status@"
                                  shortDescBinding="JOB_STATUS@notifResourceBundle" />
                </uix:column>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="EDIT@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                  <uix:image source="/em/images/updateicon_enabled.gif"
                             onClickBinding="editScript@"
                             shortDescBinding="EDIT@notifResourceBundle"
                             />
                </uix:column>

              </uix:table>

              <uix:styledText rendered="false"
                              renderedBinding="hideDetails@ruleJobs@servletRequest"
                              textBinding="noDetailsMsg@ruleJobs@servletRequest"
                              styleClass="OraInstructionText" />

              <uix:spacer height="20" />

            </uix:subTabLayout>
          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@ruleJobs@servletRequest" >
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="Cancel"/>
                <uix:submitButton textBinding="OK@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="OK"/>

              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>
        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
