<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>

      <uix:form nameBinding="formName@ruleMethods@servletRequest" method="POST" >
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@ruleMethods@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@ruleMethods@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@ruleMethods@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@ruleMethods@servletRequest">
            <uix:messageBox messageBinding="msg@ruleMethods@servletRequest"
                            messageTypeBinding="msgType@ruleMethods@servletRequest"
                            textBinding="valErrText@ruleMethods@servletRequest">
              <uix:contents childDataBinding="valErrData@ruleMethods@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@ruleMethods@servletRequest" >
            <uix:header textBinding="createEditHeader@ruleMethods@servletRequest" />

              <uix:tableLayout width="100%" >
                <uix:rowLayout hAlign="right">
                  <uix:cellFormat>
                    <uix:pageButtonBar>
                      <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                        unvalidated="true"
                                        name="event"
                                        value="Cancel"/>
                      <uix:submitButton textBinding="OK@commonResourceBundle"
                                        unvalidated="true"
                                        name="event"
                                        value="OK"/>
                    </uix:pageButtonBar>
                  </uix:cellFormat>
                </uix:rowLayout>
              </uix:tableLayout>

              <uix:subTabLayout>
                <uix:subTabs>
                  <uix:subTabBar selectedIndexBinding="selectedPageIndex@ruleMethods@servletRequest">
                    <uix:contents childDataBinding="subTabs@ruleMethods@servletRequest" >
                      <uix:link textBinding="tabName"
                                onClickBinding="onClickScript"/>
                    </uix:contents>
                  </uix:subTabBar>
                </uix:subTabs>

                <uix:spacer height="10" />

                <uix:header textBinding="EMAIL@notifResourceBundle">
                  <uix:stackLayout>
                    <uix:checkBox name="emailCheckbox" 
                                  disabledBinding="disableSendEmail@ruleMethods@servletRequest" 
                                  textBinding="SEND_ME_EMAIL@notifResourceBundle" 
                                  shortDescBinding="SEND_ME_EMAIL@notifResourceBundle"  
                                  checkedBinding="sendEmail@ruleMethods@servletRequest" 
                                  value="0" />
                    <uix:styledText textBinding="actionMsg@ruleMethods@servletRequest"
                                    styleClass="OraInlineInfoText"/>
                  </uix:stackLayout>

                  <!-- start repeat-->                  
                  <uix:spacer height="10" />
                  
                  <uix:header textBinding="REPEATED_NOTIFICATIONS@notifResourceBundle">
                    <uix:stackLayout>

                      <uix:styledText textBinding="REPEAT_NOTIFICATION_RULE_MSG@notifResourceBundle"
                                      styleClass="OraInstructionText"/>
                      <uix:spacer height="5" width="10"/>
                      <uix:checkBox name="REPEAT_ENABLED" 
                                    textBinding="ENABLE_REPEATED_NOTIFICATIONS@notifResourceBundle" 
                                    shortDescBinding="ENABLE_REPEATED_NOTIFICATIONS@notifResourceBundle"  
                                    checkedBinding="repeat@ruleMethods@servletRequest" 
                                    value="true" />
                      <uix:styledText textBinding="ruleRepeatTip@ruleMethods@servletRequest"
                                      styleClass="OraInlineInfoText"/>

                      <uix:labeledFieldLayout fieldWidth="75%" labelWidth="25%"> 
                        <uix:contents>
                          <uix:spacer height="15"/>

                          <uix:messageStyledText promptBinding="GLOBAL_REPEAT_NOTIF_SETTINGS@notifResourceBundle"
                                                 textBinding="globalRepeatSetting@ruleMethods@servletRequest"
                                                 id="GLOBAL_REPEAT"
                                                 styleClass="OraInstructionTextStrong"
                                                 shortDescBinding="GLOBAL_REPEAT_NOTIF_SETTINGS@notifResourceBundle"/>

                          <uix:messageStyledText promptBinding="FREQUENCY@notifResourceBundle"
                                            textBinding="repeatFrequency@ruleMethods@servletRequest"
                                            id="REPEAT_FREQUENCY"
                                            styleClass="OraInstructionTextStrong"
                                            shortDescBinding="FREQUENCY@notifResourceBundle"/>

                          <uix:messageStyledText promptBinding="MAXIMUM_REPEATED_NOTIFICATIONS@notifResourceBundle"
                                            textBinding="repeatCount@ruleMethods@servletRequest"
                                            id="REPEAT_COUNT"
                                            styleClass="OraInstructionTextStrong"
                                            shortDescBinding="MAXIMUM_REPEATED_NOTIFICATIONS@notifResourceBundle"/>
                        </uix:contents>           
                      </uix:labeledFieldLayout>

                    </uix:stackLayout>                                                        
                  </uix:header>
                  <!-- End repeat-->
                  
                </uix:header>
     
                <uix:spacer height="15" />

                <uix:header textBinding="ADVANCED_NOTIF_METHODS@notifResourceBundle">
                  <uix:table name="devices"
                             width="100%"
                             formSubmitted="true"
                             alternateTextBinding="NO_DEVICES_FOUND_MSG@notifResourceBundle"
                             summaryBinding="ADVANCED_NOTIF_METHODS@notifResourceBundle"
                             tableDataBinding="deviceData@ruleMethods@servletRequest" >
                       
                    <uix:tableFormat tableBanding="rowBanding"/>

                      <uix:column >
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="DEVICE_NAME@notifResourceBundle" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat" />
                          <uix:styledText textBinding="deviceName@"
                                          shortDescBinding="DEVICE_NAME@notifResourceBundle" />
                      </uix:column>

                      <uix:column >
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="DEVICE_TYPE@notifResourceBundle" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat" />
                        <uix:styledText textBinding="typeDisplay@"
                                        shortDescBinding="DEVICE_TYPE@notifResourceBundle" />
                      </uix:column>

                      <uix:column >
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="DEVICE_DESC@notifResourceBundle" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="textFormat" />
                        <uix:styledText textBinding="deviceDesc@"
                                        shortDescBinding="DEVICE_DESC@notifResourceBundle" />
                      </uix:column>

                      <uix:column >
                        <uix:columnHeader>
                          <uix:sortableHeader textBinding="ASSIGN_DEVICE_TO_RULE@notifResourceBundle" />
                        </uix:columnHeader>
                        <uix:columnFormat columnDataFormat="iconButtonFormat" />
                        <uix:checkBox name="assign"
                                      valueBinding="deviceID@"
                                      shortDescBinding="ASSIGN_DEVICE_TO_RULE@notifResourceBundle"
                                      checkedBinding="selected@" />
                      </uix:column>

                    </uix:table>
                        
                  </uix:header>
     
                  <uix:spacer height="10" />

                </uix:subTabLayout>
              </uix:stackLayout>

              <uix:contentFooter>
                <uix:stackLayout rendered="true"
                                 renderedBinding="showContents@ruleMethods@servletRequest" >
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="Cancel"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="OK"/>
                  </uix:pageButtonBar>
                </uix:stackLayout>
              </uix:contentFooter>
            </uix:pageLayout>
            
        </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
