<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script language="javascript">
function setRowID(rowNum)
{
  //alert("rowNum=" + rowNum);
  document.forms[0].rowID.value = rowNum;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form nameBinding="formName@ruleMetrics@servletRequest" method="POST" >
        <uix:formValue name="rowID" value="" />

        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@ruleMetrics@servletRequest" />
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@ruleMetrics@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@ruleMetrics@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@ruleMetrics@servletRequest">
            <uix:messageBox messageBinding="msg@ruleMetrics@servletRequest"
                            messageTypeBinding="msgType@ruleMetrics@servletRequest"
                            textBinding="valErrText@ruleMetrics@servletRequest">
              <uix:contents childDataBinding="valErrData@ruleMetrics@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@ruleMetrics@servletRequest" >
            <uix:header textBinding="createEditHeader@ruleMetrics@servletRequest" />

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="Cancel"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="OK"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="selectedPageIndex@ruleMetrics@servletRequest">
                  <uix:contents childDataBinding="subTabs@ruleMetrics@servletRequest" >
                    <uix:link textBinding="tabName"
                              onClickBinding="onClickScript"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:subTabs>
                      
              <uix:spacer height="5" />

              <uix:table name="ruleMetrics"
                         width="100%"
                         showAll="yes"
                         rendered="false"
                         renderedBinding="showDetails@ruleMetrics@servletRequest"
                         formSubmitted="true"
                         alternateTextBinding="CLICK_TO_ADD_METRICS@notifResourceBundle"
                         summaryBinding="METRICS@notifResourceBundle"
                         valueBinding="value@ruleMetrics@servletRequest"
                         minValueBinding="minValue@ruleMetrics@servletRequest"
                         blockSizeBinding="blockSize@ruleMetrics@servletRequest"
                         maxValueBinding="maxValue@ruleMetrics@servletRequest"
                         columnHeaderDataBinding="columnHeader@ruleMetrics@servletRequest"
                         tableDataBinding="selectedMetrics@ruleMetrics@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>
                          
                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@"
                                         shortDescBinding="SELECT@notifResourceBundle" >
                    <uix:spacer width="5" />
                    <uix:submitButton textBinding="REMOVE@notifResourceBundle" 
                                      name="event"
                                      value="removeMetrics" />
                  </uix:multipleSelection>
                </uix:tableSelection>

                <uix:tableActions>
                  <uix:submitButton textBinding="ADD@notifResourceBundle" 
                                    name="event"
                                    value="addMetrics" />
                </uix:tableActions>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                    <uix:styledText textBinding="label@"
                                    shortDescBinding="METRIC@notifResourceBundle" />
                    <uix:formValue name="metric" valueBinding="value@" />
                    <uix:formValue name="keyVal" valueBinding="keyVal@" />
                  </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="keyValuesField@" />
                </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="severity@" />
                </uix:column>

                <uix:columnGroup >
                  <uix:columnHeader>
                    <uix:styledText textBinding="CORRECTIVE_ACTION@notifResourceBundle" />
                  </uix:columnHeader>

                  <uix:column >
                    <uix:columnFormat columnDataFormat="textFormat" />
                    <uix:styledText textBinding="onCritical@" />
                  </uix:column>

                  <uix:column >
                    <uix:columnFormat columnDataFormat="textFormat" />
                    <uix:styledText textBinding="onWarning@" />
                  </uix:column>

                </uix:columnGroup >

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="EDIT@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                  <uix:image source="/em/images/updateicon_enabled.gif"
                             onClickBinding="editScript@"
                             shortDescBinding="EDIT@notifResourceBundle"
                             />
                </uix:column>

              </uix:table>

              <uix:styledText rendered="false"
                              renderedBinding="hideDetails@ruleMetrics@servletRequest"
                              textBinding="noDetailsMsg@ruleMetrics@servletRequest"
                              styleClass="OraInstructionText" />

              <uix:spacer height="20" />

            </uix:subTabLayout>
          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@ruleMetrics@servletRequest">
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="Cancel"/>
                <uix:submitButton textBinding="OK@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="OK"/>
              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

