<%@ include file="/sdk/oemTop.jspf" %>
<%@ include file="/oemNoscript.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<script language="javascript">
function setRowID(rowNum)
{
  //alert("rowNum=" + rowNum);
  document.forms[0].rowID.value = rowNum;
}
</script>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>

    <uix:body>

      <uix:form nameBinding="formName@rulePolicies@servletRequest" method="POST" >
        <uix:formValue name="rowID" value="" />
          <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@rulePolicies@servletRequest" />
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@rulePolicies@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@rulePolicies@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@rulePolicies@servletRequest">
            <uix:messageBox messageBinding="msg@rulePolicies@servletRequest"
                            messageTypeBinding="msgType@rulePolicies@servletRequest"
                            textBinding="valErrText@rulePolicies@servletRequest">
              <uix:contents childDataBinding="valErrData@rulePolicies@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@rulePolicies@servletRequest" >
            <uix:header textBinding="createEditHeader@rulePolicies@servletRequest" />

            <uix:tableLayout width="100%" >
              <uix:rowLayout hAlign="right">
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="Cancel"/>
                    <uix:submitButton textBinding="OK@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="OK"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:subTabLayout>
              <uix:subTabs>
                <uix:subTabBar selectedIndexBinding="selectedPageIndex@rulePolicies@servletRequest">
                  <uix:contents childDataBinding="subTabs@rulePolicies@servletRequest" >
                    <uix:link textBinding="tabName"
                              onClickBinding="onClickScript"/>
                  </uix:contents>
                </uix:subTabBar>
              </uix:subTabs>
                      
              <uix:spacer height="10" />

              <uix:table name="rulePolicies"
                         width="100%"
                         showAll="yes"
                         rendered="false"
                         renderedBinding="showDetails@rulePolicies@servletRequest"
                         formSubmitted="true"
                         alternateTextBinding="CLICK_TO_ADD_POLICIES@notifResourceBundle"
                         summaryBinding="POLICIES@notifResourceBundle"
                         valueBinding="value@rulePolicies@servletRequest"
                         minValueBinding="minValue@rulePolicies@servletRequest"
                         blockSizeBinding="blockSize@rulePolicies@servletRequest"
                         maxValueBinding="maxValue@rulePolicies@servletRequest"
                         columnHeaderDataBinding="columnHeader@rulePolicies@servletRequest"
                         tableDataBinding="selectedPolicies@rulePolicies@servletRequest" >

                <uix:tableFormat tableBanding="rowBanding"/>

                <uix:tableSelection>
                  <uix:multipleSelection selectedBinding="selected@"
                                         shortDescBinding="SELECT@notifResourceBundle" >
                    <uix:spacer width="5" />
                    <uix:submitButton textBinding="REMOVE@notifResourceBundle" 
                                      name="event"
                                      value="removePolicies" />
                  </uix:multipleSelection>
                </uix:tableSelection>

                <uix:tableActions>
                  <uix:submitButton textBinding="ADD@notifResourceBundle" 
                                    name="event"
                                    value="addPolicies" />
                </uix:tableActions>

                <uix:columnHeaderStamp>
                  <uix:sortableHeader sortableBinding="sortable"
                                      textBinding="text"/>
                </uix:columnHeaderStamp>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                    <uix:styledText textBinding="label@"
                                    shortDescBinding="POLICY@notifResourceBundle" />
                    <uix:formValue name="policy" valueBinding="value@" />
                  </uix:column>

                  <uix:column >
                    <uix:columnFormat columnDataFormat="textFormat" />
                    <uix:styledText textBinding="categoryLabel@"
                                    shortDescBinding="CATEGORY@notifResourceBundle" />
                    <uix:formValue name="categoryName" valueBinding="categoryName@" />
                  </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="severity@" />
                </uix:column>

                <uix:column >
                  <uix:columnFormat columnDataFormat="textFormat" />
                  <uix:styledText textBinding="onViolation@" />
                </uix:column>

                <uix:column >
                  <uix:columnHeader>
                    <uix:sortableHeader textBinding="EDIT@notifResourceBundle" />
                  </uix:columnHeader>
                  <uix:columnFormat columnDataFormat="iconButtonFormat" />
                  <uix:image source="/em/images/updateicon_enabled.gif"
                             onClickBinding="editScript@"
                             shortDescBinding="EDIT@notifResourceBundle"
                             />
                </uix:column>

              </uix:table>

              <uix:styledText rendered="false"
                              renderedBinding="hideDetails@rulePolicies@servletRequest"
                              textBinding="noDetailsMsg@rulePolicies@servletRequest"
                              styleClass="OraInstructionText" />

              <uix:spacer height="20" />

            </uix:subTabLayout>
          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@rulePolicies@servletRequest" >
              <uix:pageButtonBar>
                <uix:submitButton textBinding="CANCEL@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="Cancel"/>
                <uix:submitButton textBinding="OK@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="OK"/>
              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>

