<%@ include file="/sdk/oemTop.jspf" %>
<%@ taglib uri="http://xmlns.oracle.com/uix/ui" prefix="uix" %>
<%@ taglib uri="http://xmlns.oracle.com/oem/jsp/tag" prefix="oem" %>

<uix:renderingContext id="renderingContext">
  <oem:setURLEncoder id="renderingContext"/>
  <uix:bundle name="commonResourceBundle"
              class="oracle.sysman.resources.CommonResourceBundle"/>
  <uix:bundle name="sdkUIMsg"
              class="oracle.sysman.emSDK.eml.SDKUIMsg"/>
  <uix:bundle name="notifResourceBundle"
              class="oracle.sysman.resources.NotifMsg"/>
  <uix:document>
    <%@ include file="/oemTitle.jspf" %>
    <%@ include file="/oemNoscript.jspf" %>
    <uix:body>

      <uix:form name="updateJobPattern" method="POST" >
        <uix:pageLayout>

          <%@ include file="/oemGlobal.jspf" %>

          <uix:pageHeader >
            <uix:globalHeader selectedIndex="0" >
              <uix:link textBinding="1@sdkUIMsg"
                        styleClass="OraGlobalPageTitle"
                        destinationBinding="ruleMainPage@updateJobPattern@servletRequest"/>
            </uix:globalHeader>
          </uix:pageHeader>

          <uix:spacer height="5"/>

          <uix:stackLayout  >
            <uix:messageBox rendered="false"
                            renderedBinding="cacheLost@updateJobPattern@servletRequest"
                            textBinding="CACHE_ERR_HEADER_MSG@notifResourceBundle"
                            messageType="error"
                            messageBinding="CACHE_ERR_MSG@notifResourceBundle" >
              <uix:styledText textBinding="CACHE_ERR_CONTINUE_MSG@notifResourceBundle"
                              destinationBinding="ruleMainPage@updateJobPattern@servletRequest"/>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="false"
                           renderedBinding="showValErr@updateJobPattern@servletRequest">
            <uix:messageBox messageBinding="msg@updateJobPattern@servletRequest"
                            messageTypeBinding="msgType@updateJobPattern@servletRequest"
                            textBinding="valErrText@updateJobPattern@servletRequest">
              <uix:contents childDataBinding="valErrData@updateJobPattern@servletRequest" >
                <uix:link textBinding="text"
                          longDescBinding="longDesc"
                          destinationBinding="destination"/>
              </uix:contents>
            </uix:messageBox>
          </uix:stackLayout>

          <uix:stackLayout rendered="true"
                           renderedBinding="showContents@updateJobPattern@servletRequest" >
            <uix:header textBinding="createEditHeader@updateJobPattern@servletRequest" >

            <uix:tableLayout width="100%" >
              <uix:rowLayout >
                <uix:cellFormat hAlign="left" >
                  <uix:styledText textBinding="JOB_PATTERN_FOR_RULE@notifResourceBundle"
                                  styleClass="OraInstructionText" />
                </uix:cellFormat>
                <uix:cellFormat>
                  <uix:pageButtonBar>
                    <uix:button textBinding="CANCEL@commonResourceBundle"
                                destination="ruleJobs" />
                    <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                      unvalidated="true"
                                      name="event"
                                      value="doUpdateJobPattern"/>
                  </uix:pageButtonBar>
                </uix:cellFormat>
              </uix:rowLayout>
            </uix:tableLayout>

            <uix:spacer height="5" />

            <uix:header textBinding="JOBS@notifResourceBundle" >

              <uix:labeledFieldLayout fieldWidth="90%" labelWidth="10%" >

                  <uix:messageTextInput promptBinding="JOB_NAME@notifResourceBundle"
                                        shortDescBinding="JOB_NAME@notifResourceBundle"
                                        name="jobName"
                                        id="jobName"
                                        rows="1"
                                        columns="40"
                                        textBinding="jobName@updateJobPattern@servletRequest"/>

                  <uix:inlineMessage promptBinding="JOB_TYPE@notifResourceBundle" >
                    <uix:choice name="jobType"
                                id="jobType"
                                selectedValueBinding="jobType@updateJobPattern@servletRequest" 
                                shortDescBinding="JOB_TYPE@notifResourceBundle">

                      <uix:contents childDataBinding="jobTypesList@updateJobPattern@servletRequest" >
                        <uix:option textBinding="available"
                                    valueBinding="availID" />
                      </uix:contents>
                    </uix:choice>

                  </uix:inlineMessage>

                  <uix:styledText textBinding="JOB_OWNER@notifResourceBundle"
                                  styleClass="OraInstructionText" />

                  <uix:styledText textBinding="ALL_OWNERS@notifResourceBundle"
                                  styleClass="OraInstructionTextStrong" />

              </uix:labeledFieldLayout>

            </uix:header>

            <uix:spacer height="10" />
    
            <uix:header textBinding="JOB_STATUS@notifResourceBundle" >
              <uix:styledText textBinding="SELECT_JOB_STATUS@notifResourceBundle" 
                              styleClass="OraInstructionText"/>

              <uix:rowLayout>
                <uix:spacer height="5" />
              </uix:rowLayout>

              <uix:rowLayout rendered="true"
                             renderedBinding="singleJob@updateJobPattern@servletRequest" >
                <uix:spacer width="30" />
                <uix:checkBox name="scheduled" 
                              textBinding="JOB_SCHEDULED@notifResourceBundle" 
                              shortDescBinding="JOB_SCHEDULED@notifResourceBundle"
                              checkedBinding="scheduled@updateJobPattern@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="started" 
                              textBinding="JOB_STARTED@notifResourceBundle" 
                              shortDescBinding="JOB_STARTED@notifResourceBundle"
                              checkedBinding="started@updateJobPattern@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="suspended" 
                              textBinding="JOB_SUSPENDED@notifResourceBundle" 
                              shortDescBinding="JOB_STARTED@notifResourceBundle"
                              checkedBinding="suspended@updateJobPattern@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="succeeded" 
                              textBinding="JOB_SUCCEEDED@notifResourceBundle" 
                              shortDescBinding="JOB_SUCCEEDED@notifResourceBundle"
                              checkedBinding="succeeded@updateJobPattern@servletRequest" 
                              value="true" />
                <uix:spacer width="10" />
                <uix:checkBox name="problem" 
                              textBinding="JOB_PROBLEM@notifResourceBundle" 
                              shortDescBinding="JOB_PROBLEM@notifResourceBundle"
                              checkedBinding="problem@updateJobPattern@servletRequest" 
                              value="true" />
              </uix:rowLayout>

            </uix:header>
    
            </uix:header>

          </uix:stackLayout>

          <uix:contentFooter>
            <uix:stackLayout rendered="true"
                             renderedBinding="showContents@updateJobPattern@servletRequest" >
              <uix:pageButtonBar>
                <uix:button textBinding="CANCEL@commonResourceBundle"
                            destination="ruleJobs" />
                <uix:submitButton textBinding="CONTINUE@commonResourceBundle"
                                  unvalidated="true"
                                  name="event"
                                  value="doUpdateJobPattern"/>
              </uix:pageButtonBar>
            </uix:stackLayout>
          </uix:contentFooter>

        </uix:pageLayout>

      </uix:form>

    </uix:body>
  </uix:document>
</uix:renderingContext>
